/* File interface  Rob Chapman  Jan 18, 1993 */

#if THINK_C
  #include <Files.h>
#endif

#include <stdio.h>
#include "botforth.h"
#include "file.h"

Byte	file_cell_[sizeof(Cell)];	/* cell buffer for reading from a file */
FILE	*file_;						/* pointer to open file */
fpos_t	byte_pointer_;				/* byte pointer within a file */
Cell	line_no_;					/* line number in a file incremented by INPUT-LINE */

void byte_pointer()  /* -- a */  /* push address of byte pointer onto stack */
{
	*--sp=(Cell)&byte_pointer_;
}

void line_no()  /* -- a */  /* push address of line number onto stack */
{
	*--sp=(Cell)&line_no_;
}

void file()  /* -- n */  /* push file descriptor */
{
	*--sp = (Cell)&file_;
}

Cell file_status_;  /* indicates end of file has been reached */

void file_status()  /* -- a */
{
	*--sp = (Cell)&file_status_;
}

/* Folder interface  Rob Chapman  Oct 18, 1993 */
struct
{
	Byte name1;
	Byte name2[255];
}fullfilename_={0,};

void fullfilename()  /* -- a */  /* full path file name for opening */
{
	*--sp=(Cell)&fullfilename_;
}

struct
{
	Cell name4;
}pathlength_={0,};

void pathlength()  /* -- a */  /* length of pathname */
{
	*--sp=(Cell)&pathlength_;
}

struct
{
	Cell name6;
}rootlength_={0,};

void rootlength()  /* -- a */  	/* length of root name */
{
	*--sp=(Cell)&rootlength_;
}


void PWD()  /* -- */
{
	QUESTION_CR();
	*(char**)--sp="\024 Working directory: ";
	COUNT();
	TYPE();
	fullfilename();
	sp[0]+=1;	/* + */
	pathlength();
	sp[0]=*(Cell *)sp[0];	/* @ */
	QUESTION_DUP();
	if(*sp++)	/* IF */
	{
		TYPE();
	}
	else	/* ELSE */
	{
		sp++;	/* DROP */
		*(char**)--sp="\010default.";
		COUNT();
		TYPE();
	}
	_CR();
}

void SET_ROOT()  /* s -- */
{
	--sp,sp[0]=*(Byte*)sp[1];	/* DUP C@ */
	--sp,sp[0]=sp[1];	/* DUP */
	pathlength();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
	rootlength();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
	fullfilename();
	DOLLARS_STORE();
	input_echo();
	if(*(Cell *)*sp++)
	{	/* @ IF */
		PWD();
	}
}

void ADD_PATH()  /* s -- s' */
{
	pathlength();
	sp[0]=*(Cell *)sp[0];	/* @ */
	fullfilename();
	*(Byte *)sp[0]=(Byte)sp[1],sp+=2;	/* C! */
	fullfilename();
	*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
	COUNT();
	PLUS_DOLLARS();
	fullfilename();
}

void CD()  /* "path" -- */  /* change to path as root directory */
{
	BL();
	SKIP();
	*--sp=0;
	PARSE();
	HERE();
	SET_ROOT();
}

void WD()  /* "text" -- */  /* append working directory to root directory */
{
	rootlength();
	sp[0]=*(Cell *)sp[0];	/* @ */
	pathlength();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
	BL();
	SKIP();
	*--sp=0;
	PARSE();
	HERE();
	ADD_PATH();
	sp[0]=(Cell)(*(Byte *)sp[0]);	/* C@ */
	pathlength();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

/* ==== File access ==== */
Byte access = 0;		/* bits: 0 for modify; 2 for new; 4 for binary */

void MODIFY()  /* -- */  /* modify a new file */
{
	access |= 1;
}

void NEW()  /* -- */  /* create a new file */
{
	access |= 2;
}

void BINARY()  /* -- */  /* set access to reading binary files */
{
	access |= 4;
}

void OPEN()  /* s -- */
{
	ADD_PATH();
    COUNT();        /* convert count prefixed string to null terminated */
    TUCK();
    HERE();
    SWAP();
    CMOVE();
    *--sp = 0;
    SWAP();
    HERE();
    PLUS();
    C_STORE();
    HERE();
	switch(access)
	{
		case	0:  *--sp = (Cell)"r";		/* for reading a text file */
					break;
		case	1:  *--sp = (Cell)"r+";	/* for read/writing a text file */
					break;
		case	2:
		case	3:  *--sp = (Cell)"w+";	/* for creating a text file */
					break;
		case	4:  *--sp = (Cell)"rb";	/* for reading a binary file */
					break;
		case	5:  *--sp = (Cell)"r+b";	/* for read/writing a binary file */
					break;
		case	6:
		case	7:  *--sp = (Cell)"w+b";	/* for creating a binary file */
					break;
	}
	PUSH_FILE();
        file_ = fopen ( (char *)sp[1], (char *)sp[0] );
	sp += 2;
	access = 0;
	if(file_ == 0)
		file_status_ = -1;
	else
		file_status_ = ferror(file_);
	byte_pointer_ = 0;
	line_no_ = 1;
}

void CLOSE()  /* -- */
{
	if ( file_ )
		{
			file_status_ = fclose ( file_ );
			file_ = 0;
		}
	POP_FILE();
}

void QUESTION_FILE()  /* -- */
{
	file_status();
	FETCH();
	QUESTION_DUP();
	if(*sp++)	/* IF */
	{
		ERROR_STRING();
		*(char**)--sp="\007W.ERROR";
		EXECUTE_WORD();
		POP_FILE();
		ABORT();
	}
}

void LOCATE_FILE()  /* s -- f */  /* locate a file */
{
	OPEN();
	if(file_status_)
	{
		NO();
		POP_FILE();
	}
	else
	{
		CLOSE();
		YES();
	}
}

void READ()  /* -- c */
{
	fsetpos(file_, &byte_pointer_);
	*--sp = fgetc(file_);
	if(ferror(file_) || feof(file_))
		file_status_ = -1;
	fgetpos (file_, &byte_pointer_);
}

void WRITE()  /* c -- */
{
	fsetpos(file_, &byte_pointer_);
	fputc(*sp++, file_);
	if(ferror(file_) || feof(file_))
		file_status_ = -1;
	fgetpos (file_, &byte_pointer_);
}

void READ_LINE()  /* a \ n -- n */
{
	fsetpos(file_, &byte_pointer_);
	if(fgets((char *)sp[1], sp[0], file_))
	{
		if((sp[0] = strlen((char *)sp[1])) != 0)
		{
			if(*(Byte *)(sp[1] + sp[0] -1) == '\n')
				*(Byte *)(sp[1] + sp[0] -1) = 0;	/* replace newline with 0 */
			while(sp[0]--)
			{
				if((*(Byte *)sp[1] < 32) && (*(Byte *)sp[1] != 0))
					*(Byte *)sp[1] = 32;
				sp[1]++;
			}
		}
		*++sp = byte_pointer_;
		fgetpos (file_, &byte_pointer_);
		sp[0] = byte_pointer_ - sp[0];
	}
	else
	{
		file_status_ = -1;
		*(Byte *)sp[1] = 0;
		*++sp = 0;
	}
}
			
void WRITE_LINE()  /* a \ n -- */ /* Not implemented yet!!! */
{
	file_status_ = -1;
	sp += 2;
}

void READ_BYTES()  /* a \ n -- */
{
	fsetpos(file_, &byte_pointer_);
	if(feof(file_))
		file_status_ = -1;
	else
	{
		fread((char *)sp[1], 1, sp[0], file_);
		if(ferror(file_))
			file_status_ = -1;
		else
			fgetpos (file_, &byte_pointer_);
	}
	sp += 2;
}

void WRITE_BYTES()  /* a \ n -- */
{
	fsetpos(file_, &byte_pointer_);
	fwrite((char *)sp[1], 1, sp[0], file_);
	if(ferror(file_) || feof(file_))
		file_status_ = -1;
	fgetpos (file_, &byte_pointer_);
	sp += 2;
}

void READ_CELL()  /* -- n */
{	/* this shouldn't have byte ordering problems */
	*--sp = 0;
	*--sp = (Cell)file_cell_, CELL(), TWO_DUP(), READ_BYTES();
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		C_FETCH_PLUS(), sp[2] = (sp[2]<<8) + sp[1], NIP(); 
	}	  /* NEXT */
	rp++;
	sp++;
}

void WRITE_CELL()  /* n -- */
{
	fsetpos(file_, &byte_pointer_);
	fwrite((char *)&sp[0], sizeof(Cell), 1, file_),sp++;
	if(ferror(file_) || feof(file_))
		file_status_ = -1;
	fgetpos (file_, &byte_pointer_);
}

void bytes()  /* -- n */  /* number of bytes in a block */
{
	*--sp=512;     /* LITERAL */
}

void BLOCK()  /* n -- a */  /* Not implemented yet!! */
{
	DROP(), HERE();
}

void UPDATE()  /* -- */ /* Not implemented yet!!! */
{
}

/* ==== File info editing for the Mac ==== */
#if THINK_C
FInfo info;	/* | Type | Creator | Flags | Location | Where-abouts | */

void GET_INFO()  /* s -- a */
{
	ADD_PATH();
	file_status_ = GetFInfo(*(Str255 *)sp[0], 0, &info);
	sp[0] = (Cell)&info;
}

void SET_INFO()  /* a \ s -- */
{
	ADD_PATH();
	file_status_ = SetFInfo(*(Str255 *)sp[0], 0, (FInfo *)sp[1]);
	sp += 2;
}

#else
void GET_INFO()  /* s -- a */
{
	DROP(), HERE();
}

void SET_INFO()  /* a \ s -- */
{
	TWO_DROP();
}

#endif

/* ==== File loader ==== */
struct
{
	Cell *i;
	Cell *r;
	Cell *e;
	Cell q[41];
}filesq_={&filesq_.q[40],&filesq_.q[40],&filesq_.q[40]};

void filesq()  /* -- q */  /* contains file id and byte-pointer of nested file */
{
	*--sp=(Cell)&filesq_;
}

void FILE_QUERY()  /* -- f */
{
	filesq();
	Q_QUERY();
}

void CLOSE_ALL()  /* --  */ /* close all open files */
{ 
	for(;;)	/* BEGIN */
	{
		FILE_QUERY();
		if(!*sp++)break;	/* WHILE */
		CLOSE();
	}	/* REPEAT */
}

void PUSH_FILE()  /* -- */
{
	file();
	FETCH();
	byte_pointer();
	FETCH();
	line_no();
	FETCH();
	file_status();
	FETCH();
	filesq();
	PUSH();
	filesq();
	PUSH();
	filesq();
	PUSH();
	filesq();
	PUSH();
}

void POP_FILE()  /* -- */
{
	FILE_QUERY();
	if (!*sp++)  return;
	filesq();
	POP();
	file();
	STORE();
	filesq();
	POP();
	byte_pointer();
	STORE();
	filesq();
	POP();
	line_no();
	STORE();
	filesq();
	POP();
	file_status();
	STORE();
}

Cell input_echo_ = 0;

void input_echo()  /* -- a */	/* echo input lines for debugging */
{
	*--sp = (Cell)&input_echo_;
}

/* Note: a recursive nesting of shells can occur if INPUT-LINE is outside of
   a shell with INTERPRET inside.  i.e.  recursive nesting:
     BEGIN  INPUT-LINE  ?DUP  WHILE  SHELL{ INTERPRET }SHELL ...  REPEAT
   Should use the following structure:
     SHELL{  BEGIN  INPUT-LINE  ?DUP  WHILE  INTERPRET  REPEAT  }SHELL ...
   This is also more efficient. */

void INPUT_LINE()  /* -- flag */
{
	FLUSH_EMITS();
	ZERO_TIB();
	if(file_ == 0)
	{
		NO();
		return;
	}
	if(file_status_)  /* check for end of file condition */
	{
		NO();
		return;
	}
	INPUT();
	*--sp = LINELENGTH;
	READ_LINE();
	line_no_ += 1;
	if( input_echo_ == 0)
	{
		sp++;
	}
	else
	{
		INPUT(), SWAP(), QUESTION_CR(), QUESTION_STOP(), TYPE(), FLUSH_EMITS();
	}
	YES();
}

void LD()  /* "filename" -- */
{
	BL();
	WORD();
	HERE();
	QUESTION_CR(), DUP(), COUNT(), TYPE(), SPACE();
	OPEN();
	QUESTION_FILE();
	shell_nest();
	if(setjmp(*ep)==0)
	{
		for(;;)	/* BEGIN */
		{
			INPUT_LINE();
			if(!*sp++)break;	/* WHILE */
			INTERPRET();
		}	/* REPEAT */
	}
	shell_unest();
	ZERO_TIB();
	CLOSE();
	if(!*sp++)
	{
		LEFT_SQUARE_BRACKET();
		SHELL_OUT();
	}
}
 