/* Global stuff for botForth  Rob Chapman  May 19, 1993 */

/* ==== Includes for everyone ==== */
#include <setjmp.h>	/* for nested error handling */
#include <string.h>	/* for memory operations in kernel */

/* ==== Global defines ==== */
#define MSIZE 200000	/* size of memory allocated */
#define DCELLS 64		/* number of data stack cells */
#define RCELLS 64		/* number of return stack cells */
#define LINELENGTH 255	/* number of characters allowed in tib */
#define SHELLS 10		/* number of environment shells */

/* ==== Types for portability ==== */
/* Normally Byte = 8bit, Word = 16bit, Cell = 32bit */

typedef unsigned char Byte;	/* minimum memory transfer unit */
typedef unsigned short Word;	/* next in size */
typedef unsigned long Cell;	/* default memory transfer unit; big enough for pointer */
typedef unsigned long Whole;	/* whole numbers; 0 to finite infinity */
typedef   signed long Integer;	/* for operations requiring the set of signed numbers */

typedef void (*vector)();
typedef void (**thread)();

typedef struct { void *link; Byte name[1]; } TIE ;

/* ==== Kernel globals ==== */
extern Cell *sp,*rp,*sp0_,*rp0_;        /* Stacks */
extern void (***ip)(), (**tick)();		/* Indirect-threaded code pointers */

/* ==== Nested shells for error protection ==== */
extern jmp_buf *ep;			/* for saving C context */

/* ==== Debuggers ==== */
#define BadTick		end_program("bad tick.")
#define	TestTick
  /* if(*(Cell *)tick&1 || ((Cell)ip^(Cell)tick)>800000) ERROR() */

/*			     Queues
  This queue structure is used to refer to the elements.  The size of
  storage is irrevelant but ANSI C must have a size greater than 0.
  The element, end, points to the last storage item.
*/
typedef struct{
	Cell *insert;
	Cell *remove;
	Cell *end;
	Cell storage[1];
}Queue;

/* Somewhat 'personal' way of defining resizable dictionary entries */

#define DictEntry(n) const struct { void *link; Byte name[ n ]; vector tick; }
 