/* Source file generated by Timbre */

#include "botforth.h"  /* interface to VFM */
#include "aoloader.h" /* headers */ 

/* Activate objects  Rob Chapman  Aug 25, 1992 */

/* ==== Error accumulator ==== */
struct
{
	Cell name1;
}unknowns_={0,};

void unknowns()  /* -- a */  /* number of unknown symbols encountered */
{
	*--sp=(Cell)&unknowns_;
}


void ZERO_ERRORS()  /* -- */
{
	*--sp=0;
	unknowns();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void PLUS_UNKNOWN()  /* -- */
{
	*--sp=1;
	unknowns();
	*(Cell *)sp[0]+=sp[1];
	sp+=2;	/* 2DROP */	/* +! */
}

void DOT_DONE()  /* f -- */
{
	unknowns();
	sp[0]=*(Cell *)sp[0];	/* @ */
	sp[1]|=sp[0],sp++;	/* OR */
	if(*sp++)	/* IF */
	{
		*(char**)--sp="\044Errors occurred during file loading.";
		W_DOT_ERROR();
		unknowns();
		sp[0]=*(Cell *)sp[0];	/* @ */
		QUESTION_DUP();
		if(*sp++)	/* IF */
		{
			NUMBER_arg();
			*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
			*(char**)--sp="\045unresolvable symbol(s) encountered.  ";
			*(char**)--sp="\044Please have your dictionary checked.";
			*--sp=4;
			W_DOT_NOTICES();
		}
	}
	else	/* ELSE */
	{
		*(char**)--sp="\023Object file loaded.";
		W_DOT_NOTICE();
	}
}

/* ==== Object file interpreter ==== */

void READ_NAME()  /* -- s */
{
	READ();
	--sp,sp[0]=sp[1];	/* DUP */
	HERE();
	C_STORE_PLUS();
	*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
	READ_BYTES();
	HERE();
}

void UNKNOWN()  /* -- */
{
	_CR();
	*(char**)--sp="\032Can't execute, ABORTing...";
	W_DOT_ERROR();
	ABORT();
}

void NEXT_SYMBOL()  /* -- tick | 0 */
{
	READ_NAME();
	latest();
	SEARCH_DICTIONARY();
	if(*sp++)	/* IF */
	{
		L_TO_TICK();
	}
	else	/* ELSE */
	{
		sp++;	/* DROP */
		*--sp=0;
	}
}

void LOOKUP_SYMBOL()  /* -- tick */
{
	NEXT_SYMBOL();
	QUESTION_DUP();
	sp[0]=sp[0]==0?-1:0;	/* 0= */
	if(*sp++)	/* IF */
	{
		_CR();
		*(char**)--sp="\020Unknown symbol: ";
		COUNT();
		TYPE();
		HERE();
		COUNT();
		TYPE();
		*--sp=(Cell)&_UNKNOWN.tick;	/* ' */
		PLUS_UNKNOWN();
	}
}

void ACTIVATE_OBJECT()  /* -- */
{
	LOOKUP_SYMBOL();
	tick=(void(**)())(*sp++), (**tick)();	/* EXECUTE */
}

void ACTIVATE_FILE()  /* s -- */
{
	BINARY();
	OPEN();
	QUESTION_FILE();
	*(char**)--sp="\026Loading object file...";
	W_DOT_NOTICE();
	FLUSH_EMITS();
	shell_nest();
	if(setjmp(*ep)==0)
	{
		ACTIVATE_OBJECT();
	}
	shell_unest();
	sp[0]=sp[0]==0?-1:0;	/* 0= */
	CLOSE();
	DOT_DONE();
}

void EXECAO()  /* s -- */
{
	ZERO_ERRORS();
	INSTALL();
	ACTIVATE_FILE();
}

void ACT()  /* "object" -- */
{
	BL();
	WORD();
	HERE();
	EXECAO();
}

/* ==== Repeated objects ==== */

void REPEAT_OBJECT()  /* -- */
{
	LOOKUP_SYMBOL();
	READ_CELL();
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		*--rp=*sp++;	/* >R */
		*--sp=*rp;	/* R */
		tick=(void(**)())(*sp++), (**tick)();	/* EXECUTE */
		*--sp=*rp++;	/* R> */
	}	/* NEXT */
	rp++;
	sp++;	/* DROP */
}

/* ==== Messages ==== */

void AO_MESSAGE()  /* -- */
{
	READ();
	for(*--rp=*sp++;*rp;(*rp)--)	/* FOR */
	{
		READ();
		EMIT();
	}	/* NEXT */
	rp++;
}

/* ==== Interpreted objects ==== */

void ASSUME_NUMBER()  /* s -- n */
{
	--sp,sp[0]=sp[1];	/* DUP */
	NUMBER_QUERY();
	if(*sp++)	/* IF */
	{
		NUMBER();
	}
	else	/* ELSE */
	{
		*(char**)--sp="\020Unknown object: ";
		*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
		*(char**)--sp="\014 ABORTing...";
		*--sp=3;
		W_DOT_NOTICES();
		ABORT();
	}
}

void INTERPRET_OBJECT()  /* s -- */
{
	latest();
	SEARCH_DICTIONARY();
	if(*sp++)	/* IF */
	{
		--sp,sp[0]=sp[1];	/* DUP */
		L_TO_TICK();
		*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
		L_TO_NAME();
		sp[0]=(Cell)(*(Byte *)sp[0]);	/* C@ */
		sp[0]&=224;	/* AND */
		QUESTION_EXECUTE();
	}
	else	/* ELSE */
	{
		ASSUME_NUMBER();
	}
}

void ACTIVATOR()  /* -- */
{  /* activate objects in a file until 0 is encountered */
	for(;;)	/* BEGIN */
	{
		READ_NAME();
		--sp,sp[0]=*(Byte*)sp[1];	/* DUP C@ */
		if(!*sp++)break;	/* WHILE */
		INTERPRET_OBJECT();
	}	/* REPEAT */
	sp++;	/* DROP */
}

void LOAD_AOF()  /* -- */
{
	READ_NAME();
	--sp,sp[0]=sp[1];	/* DUP */
	LOCATE_FILE();
	if(*sp++)	/* IF */
	{
		file();
		sp[0]=*(Cell *)sp[0];	/* @ */
		byte_pointer();
		sp[0]=*(Cell *)sp[0];	/* @ */
		*--rp=*sp++;	/* >R */
		*--rp=*sp++;	/* >R */
		ACTIVATE_FILE();
		*--sp=*rp++;	/* R> */
		*--sp=*rp++;	/* R> */
		byte_pointer();
		*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
		file();
		*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
	}
	else	/* ELSE */
	{
		*(char**)--sp="\020 can't be found.";
		*--sp=2;
		W_DOT_ERRORS();
		SHELL_OUT();
	}
}

/* ==== Relocatable images from files ==== */

/* ==== Relative and absolute data space rendering ==== */
struct
{
	Cell name3;
}image_={0,};

void image()  /* -- a */  /* pointer to start of working image */
{
	*--sp=(Cell)&image_;
}


void ABSOLUTE()  /* ra -- aa */
{
	sp[0]-=1;	/* - */
	image();
	sp[0]=*(Cell *)sp[0];	/* @ */
	sp[1]+=sp[0],sp++;	/* + */
}

void RELATIVE()  /* aa -- ra */
{
	image();
	sp[0]=*(Cell *)sp[0];	/* @ */
	sp[1]-=sp[0],sp++;	/* - */
	sp[0]+=1;	/* + */  /* can't allow 0 */
}

/* ==== Image relocaters ==== */

void IMMEDIATE_QUERY()  /* tick -- f */
{
	T_TO_NAME();
	sp[0]=(Cell)(*(Byte *)sp[0]);	/* C@ */
	sp[0]&=64;	/* AND */
}

void RESOLVE_SYMBOL()  /* -- a */
{
	LOOKUP_SYMBOL();
	--sp,sp[0]=sp[1];	/* DUP */
	*--sp=(Cell)&_UNKNOWN.tick;	/* ' */
	if(sp[1]==sp[0]) *++sp=-1; else *++sp=0;	/* = */
	if(*sp++)	/* IF */
	{
		READ_CELL();
		sp+=2;	/* 2DROP */
		HERE();
	}
	else	/* ELSE */
	{
		--sp,sp[0]=sp[1];	/* DUP */
		IMMEDIATE_QUERY();
		if(*sp++)	/* IF */
		{
			PLUS_UNKNOWN();
			_CR();
			*(char**)--sp="\020IMMEDIATE word: ";
			COUNT();
			TYPE();
			T_TO_LINK();
			DOT_NAME();
			READ_CELL();
			sp++;	/* DROP */
			HERE();
		}
		else	/* ELSE */
		{
			READ_CELL();
			sp[1]+=sp[0],sp++;	/* + */
		}
	}
}

void LOAD_IMAGE()  /* a -- */
{
	--sp,sp[0]=sp[1];	/* DUP */
	image();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
	READ_CELL();
	READ_BYTES();
}

void EXTERNAL_VALUE()  /* -- */
{
	READ_CELL();
	RESOLVE_SYMBOL();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void EXTERNAL_REF()  /* -- */
{
	RESOLVE_SYMBOL();
	RESOLVE_SYMBOL();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void INLINK()  /* -- */
{
	READ_CELL();
	ABSOLUTE();
	RESOLVE_SYMBOL();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void OUTLINK()  /* -- */
{
	RESOLVE_SYMBOL();
	READ_CELL();
	ABSOLUTE();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void OUTLIST()  /* -- */
{
	RESOLVE_SYMBOL();
	READ_CELL();
	for(;;)	/* BEGIN */
	{
		QUESTION_DUP();
		if(!*sp++)break;	/* WHILE */
		ABSOLUTE();
		--sp,sp[0]=*(Cell*)sp[1];	/* DUP @ */
		*--rp=*sp++;	/* >R */
		--sp,sp[0]=sp[1],sp[1]=sp[2];	/* NUP */
		*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
		*--sp=*rp++;	/* R> */
	}	/* REPEAT */
	sp++;	/* DROP */
}

void INTERNAL_REF()  /* -- */
{
	READ_CELL();
	ABSOLUTE();
	READ_CELL();
	ABSOLUTE();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void INTERNAL_VALUE()  /* -- */
{
	READ_CELL();
	READ_CELL();
	ABSOLUTE();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void TABLE_ENTRY()  /* a -- */
{
	READ_CELL();
	ABSOLUTE();
	*--rp=sp[1],sp[1]=sp[0],sp[0]=*rp++;	/* SWAP */
	READ_CELL();
	sp[1]+=sp[0],sp++;	/* + */
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

/* ==== Control objects ==== */

void branch()  /* -- */
{
	READ_CELL();
	byte_pointer();
	*(Cell *)sp[0]=sp[1],sp+=2;	/* ! */
}

void ZERO_branch()  /* f -- */
{
	if(*sp++)	/* IF */
	{
		READ_CELL();
		sp++;	/* DROP */
	}
	else	/* ELSE */
	{
		branch();
	}
}

void AOBJ_FILE()  /* -- n */  /* FDTYPE for an active object file */
{
	*--sp=6;
}
 