( Optimization rules  Rob Chapman  Jul 9, 1992 )
( ==== Phrase printing ==== )
  0 VARIABLE phrase
: .P  ( -- )  phrase @ 0=  IF  GET-PHRASE phrase !  " print-phrase"  inputq STUFF  ENDIF ;

compiler RULES
{ .phrase }[ phrase @  .PHRASE  0 phrase ! ]
{ print-phrase }[ phrase @  IF  { +c tab /* _ f .phrase +c */ f }  ENDIF ]

( ==== Literal storage ==== )
  RULE-SET literals
  RULE-SET literal

  10 QUEUE litq

: >L  ( n -- )  litq PUSH ;
: L>  ( -- n )  litq POP  ;

literal RULES
{ }[ inputq PULL  DUP NUMBER?  IF  NUMBER  { LITERAL }  ELSE  { Done. } ENDIF ]

{ ( }[ ` ) SCAN ]

{ LITERAL }[ >L  literals RULES ]
{ Done. }[ inputq STUFF  L> { LIT }  compiler RULES ]

{ SWAP }[ .P ]{ c --sp, sp[0] = sp[1], sp[1] = literal ; f }
{ DUP  }[ L> DUP >L  { LITERAL } ]
{ DROP }[ L> DROP  compiler RULES ]

{ NOT    }[ L> NOT >L ]
{ NEGATE }[ L> NEGATE >L ]
{ ABS    }[ L> ABS >L ]
{ 2/     }[ L> 2/ >L ]
{ 2*     }[ L> 2* >L ]
{ U2/    }[ L> U2/ >L ]
{ CELLS  }[ L> CELLS >L ]  ( not portable to a 16 bit machine )

{ YES }[ YES >L  literals RULES ]
{ NO  }[ NO >L   literals RULES ]

{ c  }{ +c nl }
{ +c }[ L>  c RULES ]

{ +   }[ .P ]{ c  sp[0] += literal ; f }
{ -   }[ .P ]{ c  sp[0] -= literal ; f }
{ *   }[ .P ]{ c  sp[0] *= literal ; f }
{ /   }[ .P ]{ c  sp[0] /= literal ; f }
{ MOD }[ .P ]{ c  sp[0] %= literal ; f }
{ AND }[ .P ]{ c  sp[0] &= literal ; f }
{ OR  }[ .P ]{ c  sp[0] |= literal ; f }
{ XOR }[ .P ]{ c  sp[0] ^= literal ; f }

{ @ }[ .P ]{ c *--sp = *( Cell *) literal ; f }
{ ! }[ .P ]{ c ( Cell *) literal = *sp++; f }

{ FOR }[ .P ]{ c  for(*--rp= literal ;*rp;(*rp)--)    \ FOR  sb  f }

literals RULES
{ }[ litq Q?  IF  { LIT }  L>  ELSE  compiler RULES  ENDIF ]

{ ( }[ ` ) SCAN ]

{ one left? }[ litq Q? 1 =  IF  literal RULES  ENDIF ]

{ SWAP }[ L> L> SWAP >L >L ]
{ DUP  }[ L> DUP >L >L ]
{ DROP }[ L> DROP  { one left? } ]

{ OVER }[ L> L>  TUCK  >L >L >L ]
{ TUCK }[ L> L>  OVER  >L >L >L ]

{ 2DUP  }{ OVER OVER }
{ 2DROP }{ DROP DROP }

{ ?DUP }[ L>  DUP >L  IF  { DUP }  ENDIF ]

{ +    }[ L> L>      +   >L  { one left? } ]
{ -    }[ L> L> SWAP -   >L  { one left? } ]
{ *    }[ L> L>      *   >L  { one left? } ]
{ /    }[ L> L> SWAP /   >L  { one left? } ]
{ MOD  }[ L> L> SWAP MOD >L  { one left? } ]
{ /MOD }[ L> L> SWAP /MOD  SWAP >L >L ]

{ AND }[ L> L> AND >L  { one left? } ]
{ OR  }[ L> L> OR  >L  { one left? } ]
{ XOR }[ L> L> XOR >L  { one left? } ]

{ =  }[ L> L> =  >L  { one left? } ]
{ <  }[ L> L> >  >L  { one left? } ]
{ >  }[ L> L> <  >L  { one left? } ]
{ U> }[ L> L> U< >L  { one left? } ]
{ U< }[ L> L> U> >L  { one left? } ]

{ MIN }[ L> L> MIN >L  { one left? } ]
{ MAX }[ L> L> MAX >L  { one left? } ]

{ NOT    }[ L> NOT >L ]
{ NEGATE }[ L> NEGATE >L ]
{ ABS    }[ L> ABS >L ]
{ 2/     }[ L> 2/ >L ]
{ 2*     }[ L> 2* >L ]
{ U2/    }[ L> U2/ >L ]

{ YES }[ YES >L ]
{ NO  }[ NO >L ]


compiler RULES
{ LIT }{ c *--sp = literal ; f }
{ LITERAL }[ >L  literal RULES ]

{ R }[ .P ]{ r }
{ R> }[ .P ]{ rfrom }
{ >R }[ .P ]{ tor }
{ SWAP }[ .P ]{ swap }
{ DUP }[ .P ]{ dup }
{ DROP }[ .P ]{ drop }
{ NUP }{ >R DUP R> }[ .P ]{ nup }
{ NIP }{ SWAP DROP }[ .P ]{ nip }
{ OVER }{ NUP SWAP }[ .P ]{ c --sp, sp[0] = sp[2] ; f }
{ TUCK }{ SWAP OVER }[ .P ]{ c --sp, sp[0]=sp[1], sp[1]=sp[2], sp[2]=sp[0]; f }
{ 2DUP  }{ OVER OVER }
{ 2DROP }{ DROP DROP }[ .P ]{ c sp+=2; f }

{ DUP >R  }[ .P ]{ c *--rp = sp[0] ; f }
{ SWAP >R }[ .P ]{ c *--rp = sp[1] ; f  NIP }
{ R> DROP }[ .P ]{ c rp++; f }
{ DROP R> }[ .P ]{ c sp[0] = *rp++; f }
{ OVER +  }[ .P ]{ c sp[0] += sp[1] ; f }
{ NUP C!+ }[ .P ]{ c *( Byte   _ *)(sp[0]) = ( Byte   )(sp[1]) ; f  1 + }
{ R + }[ .P ]{ c sp[0] += rp[0] ; f }

{ + }[ .P ]{ plus }
{ - }[ .P ]{ minus }
{ AND }[ .P ]{ and }
{ OR }[ .P ]{ or }
{ XOR }[ .P ]{ xor }
{ NOT }[ .P ]{ not }
{ 2* }{ 2 * }{ DUP + }[ .P ]{ left }
{ 2/ }{ 2 / }[ .P ]{ right }
{ U2/ }[ .P ]{ uturn }
{ /MOD }[ .P ]{ udiv }
{ /   }{ /MOD NIP  }[ .P ]{ c sp[1]/=sp[0], sp++ ; f }
{ MOD }{ /MOD DROP }[ .P ]{ c sp[1]%=sp[0], sp++ ; f }
{ * }[ .P ]{ mult }
{ NEGATE }{ NOT 1 + }[ .P ]{ c sp[0]=-(sp[0]); f }

{ CELL   }[ .P ]{ c *--sp = sizeof( Cell ); f }
{ CELL + }[ .P ]{ c sp[0] += sizeof( Cell ); f }
{ CELL - }[ .P ]{ c sp[0] -= sizeof( Cell ); f }
{ CELL * }{ CELLS }[ .P ]{ c sp[0] *= sizeof( Cell ); f }
{ CELL / }[ .P ]{ c sp[0] /= sizeof( Cell ); f }

{ @  }[ .P ]{ fetch }
{ W@ }[ .P ]{ wfetch }
{ C@ }[ .P ]{ cfetch }
{ !  }[ .P ]{ store }
{ W! }[ .P ]{ wstore }
{ C! }[ .P ]{ cstore }

{  +! }[ .P ]{ c  *( Cell _ *)sp[0] += sp[1] ;  f  2DROP }
{ TUCK  @ +  SWAP ! }{ +! }

{ EXECUTE }[ .P ]{ execute }

{ 0< }{ 0 < }[ .P ]{ negative? }
{ 0= }{ 0 = }[ .P ]{ c  sp[0] = sp[0] == 0 ? -1 : 0 ; f }
{ IF  NO  ELSE  YES  ENDIF }{ 0= }
{ NO  }[ .P NO { LITERAL } ]
{ YES }[ .P YES { LITERAL } ]

{ =  }{ XOR 0= }[ .P      " sp[1]==sp[0]"      ]{ truth }
{ <  }[ .P  " (Integer)sp[1]<(Integer)sp[0]" ]{ truth }
{ >  }[ .P  " (Integer)sp[1]>(Integer)sp[0]" ]{ truth }
{ U< }[ .P     " sp[1]<sp[0]"      ]{ truth }
{ U> }[ .P     " sp[1]>sp[0]"      ]{ truth }

{ truth }{ c if( text ) _ *++sp=-1; _ else _ *++sp=0; f }

| truth UNTIL |[ .P ]| c  if(   text  ) _ { sp+=2; break; } nl sp+=2; eb  f |
| truth WHILE |[ .P ]| c  if(!( text )) _ { sp+=2; break; } nl sp+=2; f |

{ 2DUP XOR 0<  IF  DROP  ELSE  -       ENDIF  0< }{ < }
{ 2DUP XOR 0<  IF   NIP  ELSE  SWAP -  ENDIF  0< }{ > }
{ 2DUP XOR 0<  IF   NIP  ELSE  -       ENDIF  0< }{ U< }
{ 2DUP XOR 0<  IF  DROP  ELSE  SWAP -  ENDIF  0< }{ U> }

{ ABS }[ .P ]{ c  if(sp[0] < 0 ) _ sp[0]=-(sp[0]) ; f }
{ MAX }[ .P ]{ c  if(sp[0] > sp[1]) _ sp[1] = sp[0]; _ sp++; f }
{ MIN }[ .P ]{ c  if(sp[0] < sp[1]) _ sp[1] = sp[0]; _ sp++; f }
{ DUP 0<  IF  NEGATE  ENDIF }{ ABS }
{ 2DUP <  IF  NIP  ELSE  DROP  ENDIF }{ MAX }
{ 2DUP >  IF  NIP  ELSE  DROP  ENDIF }{ MIN }

{ @ IF    }[ .P ]{ c if(*( Cell _ *)*sp++)  start block f } 
{ @ UNTIL }[ .P ]{ c if(*( Cell _ *)*sp++)  _ break ; end block  f } 
{ @ WHILE }[ .P ]{ c if(!(*( Cell _ *)*sp++))  _ break ;  f }

{ C@ IF    }[ .P ]{ c if(*( Byte _ *)*sp++)  start block f } 
{ C@ UNTIL }[ .P ]{ c if(*( Byte _ *)*sp++)  _ break ; end block  f } 
{ C@ WHILE }[ .P ]{ c if(!(*( Byte _ *)*sp++))  _ break ;  f }

{ 0= IF    }[ .P ]{ c  if(!*sp++)  start block  f }
{ 0= UNTIL }[ .P ]{ c  if(!*sp++)break;  end block  f }

{ DUP IF    }[ .P ]{ c  if(sp[0])  start block  f }
{ DUP UNTIL }[ .P ]{ c  if(sp[0]) _ break ; end block  f }
{ DUP WHILE }[ .P ]{ c  if(sp[0] == 0) _ break ;  f }
{ DUP 0= IF }[ .P ]{ c  if(sp[0] == 0)  start block  f }
{ DUP 0= UNTIL }[ .P ]{ c  if(sp[0] == 0) _ break ; end block  f }
{ DUP 0= WHILE }[ .P ]{ c  if(sp[0] != 0) _ break ;  f }

{ DUP @  }[ .P ]{ c --sp, sp[0] = *( Cell *)sp[1]; f }
{ DUP C@ }[ .P ]{ c --sp, sp[0] = *( Byte *)sp[1]; f }

{ OVER @  }[ .P ]{ c --sp, sp[0] = *( Cell *)sp[2]; f }
{ OVER C@ }[ .P ]{ c --sp, sp[0] = *( Byte *)sp[2]; f }

{ SWAP !  }[ .P ]{ c  *( Cell _ *)sp[1] = sp[0] ;  f }
{ SWAP C! }[ .P ]{ c  *( Byte _ *)sp[1] = sp[0] ;  f }
