I_noop:	/* noop ( -- ) */
/*  */
NAME("noop")
{
DEF_CA
NEXT_P0;
{
;
}
NEXT_P1;
NEXT_P2;
}

I_lit:	/* lit ( -- w ) */
/*  */
NAME("lit")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = (Cell)NEXT_INST;
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_execute:	/* execute ( xt -- ) */
/*  */
NAME("execute")
{
DEF_CA
Xt xt;
NEXT_P0;
xt = (Xt) TOS;
sp += 1;
{
ip=IP;
cfa = xt;
IF_TOS(TOS = sp[0]);
NEXT1;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_branch_lp_plus_store_number:	/* branch-lp+!# ( -- ) */
/*  */
NAME("branch-lp+!#")
{
DEF_CA
NEXT_P0;
{
/* this will probably not be used */
branch_adjust_lp:
lp += (Cell)(IP[1]);
goto branch;
}
NEXT_P1;
NEXT_P2;
}

I_branch:	/* branch ( -- ) */
/*  */
NAME("branch")
{
DEF_CA
NEXT_P0;
{
branch:
ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
NEXT_P0;
}
NEXT_P1;
NEXT_P2;
}

I_question_branch:	/* ?branch ( f -- ) */
/*  */
NAME("?branch")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
sp += 1;
{
if (f==0) {
    IF_TOS(TOS = sp[0]);
	ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
        NEXT_P0;
	NEXT;
}
else
    INC_IP(1);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_question_branch_lp_plus_store_number:	/* ?branch-lp+!# ( f -- ) */
/*  */
NAME("?branch-lp+!#")
{
DEF_CA
Bool f;
NEXT_P0;
f = (Bool) TOS;
sp += 1;
{
if (f==0) {
    IF_TOS(TOS = sp[0]);
    goto branch_adjust_lp;
}
else
    INC_IP(2);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_next:	/* (next) ( -- ) */
/*  */
NAME("(next)")
{
DEF_CA
NEXT_P0;
{
if ((*rp)--) {
	ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
        NEXT_P0;
	NEXT;
}
else
    INC_IP(1);
}
NEXT_P1;
NEXT_P2;
}

I_paren_next_lp_plus_store_number:	/* (next)-lp+!# ( -- ) */
/*  */
NAME("(next)-lp+!#")
{
DEF_CA
NEXT_P0;
{
if ((*rp)--) {
    goto branch_adjust_lp;
}
else
    INC_IP(2);
}
NEXT_P1;
NEXT_P2;
}

I_paren_loop:	/* (loop) ( -- ) */
/*  */
NAME("(loop)")
{
DEF_CA
NEXT_P0;
{
Cell index = *rp+1;
Cell limit = rp[1];
if (index != limit) {
    *rp = index;
	ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
        NEXT_P0;
	NEXT;
}
else
    INC_IP(1);
}
NEXT_P1;
NEXT_P2;
}

I_paren_loop_lp_plus_store_number:	/* (loop)-lp+!# ( -- ) */
/*  */
NAME("(loop)-lp+!#")
{
DEF_CA
NEXT_P0;
{
Cell index = *rp+1;
Cell limit = rp[1];
if (index != limit) {
    *rp = index;
    goto branch_adjust_lp;
}
else
    INC_IP(2);
}
NEXT_P1;
NEXT_P2;
}

I_paren_plus_loop:	/* (+loop) ( n -- ) */
/*  */
NAME("(+loop)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
/* !! check this thoroughly */
Cell index = *rp;
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
/* dependent upon two's complement arithmetic */
Cell olddiff = index-rp[1];
#ifndef undefined
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#else
#ifndef MAXINT
#define MAXINT ((((Cell)1)<<(8*sizeof(Cell)-1))-1)
#endif
if(((olddiff^MAXINT) >= n) ^ ((olddiff+n) < 0)) {
#endif
#ifdef i386
    *rp += n;
#else
    *rp = index + n;
#endif
    IF_TOS(TOS = sp[0]);
	ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
        NEXT_P0;
	NEXT;
}
else
    INC_IP(1);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_plus_loop_lp_plus_store_number:	/* (+loop)-lp+!# ( n -- ) */
/*  */
NAME("(+loop)-lp+!#")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
/* !! check this thoroughly */
Cell index = *rp;
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
/* dependent upon two's complement arithmetic */
Cell olddiff = index-rp[1];
#ifndef undefined
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#else
#ifndef MAXINT
#define MAXINT ((((Cell)1)<<(8*sizeof(Cell)-1))-1)
#endif
if(((olddiff^MAXINT) >= n) ^ ((olddiff+n) < 0)) {
#endif
#ifdef i386
    *rp += n;
#else
    *rp = index + n;
#endif
    IF_TOS(TOS = sp[0]);
    goto branch_adjust_lp;
}
else
    INC_IP(2);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_symmetric_plus_loop:	/* (s+loop) ( n -- ) */
/* The run-time procedure compiled by S+LOOP. It loops until the index
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
version of (+LOOP). */
NAME("(s+loop)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
/* !! check this thoroughly */
Cell index = *rp;
Cell diff = index-rp[1];
Cell newdiff = diff+n;
if (n<0) {
    diff = -diff;
    newdiff = -newdiff;
}
if (diff>=0 || newdiff<0) {
#ifdef i386
    *rp += n;
#else
    *rp = index + n;
#endif
    IF_TOS(TOS = sp[0]);
	ip = (Xt *)(((Cell)IP)+(Cell)NEXT_INST);
        NEXT_P0;
	NEXT;
}
else
    INC_IP(1);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_symmetric_plus_loop_lp_plus_store_number:	/* (s+loop)-lp+!# ( n -- ) */
/* The run-time procedure compiled by S+LOOP. It loops until the index
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
version of (+LOOP). */
NAME("(s+loop)-lp+!#")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
/* !! check this thoroughly */
Cell index = *rp;
Cell diff = index-rp[1];
Cell newdiff = diff+n;
if (n<0) {
    diff = -diff;
    newdiff = -newdiff;
}
if (diff>=0 || newdiff<0) {
#ifdef i386
    *rp += n;
#else
    *rp = index + n;
#endif
    IF_TOS(TOS = sp[0]);
    goto branch_adjust_lp;
}
else
    INC_IP(2);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_unloop:	/* unloop ( -- ) */
/*  */
NAME("unloop")
{
DEF_CA
NEXT_P0;
{
rp += 2;
}
NEXT_P1;
NEXT_P2;
}

I_paren_for:	/* (for) ( ncount -- ) */
/*  */
NAME("(for)")
{
DEF_CA
Cell ncount;
NEXT_P0;
ncount = (Cell) TOS;
sp += 1;
{
/* or (for) = >r -- collides with unloop! */
*--rp = 0;
*--rp = ncount;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_do:	/* (do) ( nlimit nstart -- ) */
/*  */
NAME("(do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
/* or do it in high-level? 0.09/0.23% */
*--rp = nlimit;
*--rp = nstart;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_question_do:	/* (?do) ( nlimit nstart -- ) */
/*  */
NAME("(?do)")
{
DEF_CA
Cell nlimit;
Cell nstart;
NEXT_P0;
nlimit = (Cell) sp[1];
nstart = (Cell) TOS;
sp += 2;
{
*--rp = nlimit;
*--rp = nstart;
if (nstart == nlimit) {
    IF_TOS(TOS = sp[0]);
    goto branch;
    }
else {
    INC_IP(1);
}
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_i:	/* i ( -- n ) */
/*  */
NAME("i")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
n = *rp;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_j:	/* j ( -- n ) */
/*  */
NAME("j")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
n = rp[2];
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_paren_emit:	/* (emit) ( c -- ) */
/*  */
NAME("(emit)")
{
DEF_CA
Char c;
NEXT_P0;
c = (Char) TOS;
sp += 1;
{
putchar(c);
emitcounter++;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_type:	/* (type) ( c_addr n -- ) */
/*  */
NAME("(type)")
{
DEF_CA
Char * c_addr;
Cell n;
NEXT_P0;
c_addr = (Char *) sp[1];
n = (Cell) TOS;
sp += 2;
{
fwrite(c_addr,sizeof(Char),n,stdout);
emitcounter += n;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_paren_key:	/* (key) ( -- n ) */
/*  */
NAME("(key)")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
fflush(stdout);
/* !! noecho */
n = key();
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_key_q:	/* key? ( -- n ) */
/*  */
NAME("key?")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
fflush(stdout);
n = key_query;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_cr:	/* cr ( -- ) */
/*  */
NAME("cr")
{
DEF_CA
NEXT_P0;
{
puts("");
}
NEXT_P1;
NEXT_P2;
}

I_move:	/* move ( c_from c_to ucount -- ) */
/*  */
NAME("move")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell ucount;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
ucount = (UCell) TOS;
sp += 3;
{
memmove(c_to,c_from,ucount);
/* make an Ifdef for bsd and others? */
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_cmove:	/* cmove ( c_from c_to u -- ) */
/*  */
NAME("cmove")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell u;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
u = (UCell) TOS;
sp += 3;
{
while (u-- > 0)
  *c_to++ = *c_from++;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_c_move_up:	/* cmove> ( c_from c_to u -- ) */
/*  */
NAME("cmove>")
{
DEF_CA
Char * c_from;
Char * c_to;
UCell u;
NEXT_P0;
c_from = (Char *) sp[2];
c_to = (Char *) sp[1];
u = (UCell) TOS;
sp += 3;
{
while (u-- > 0)
  c_to[u] = c_from[u];
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fill:	/* fill ( c_addr u c -- ) */
/*  */
NAME("fill")
{
DEF_CA
Char * c_addr;
UCell u;
Char c;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
c = (Char) TOS;
sp += 3;
{
memset(c_addr,c,u);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_compare:	/* compare ( c_addr1 u1 c_addr2 u2 -- n ) */
/* Compare the strings lexicographically. If they are equal, n is 0; if
the first string is smaller, n is -1; if the first string is larger, n
is 1. Currently this is based on the machine's character
comparison. In the future, this may change to considering the current
locale and its collation order. */
NAME("compare")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[3];
u1 = (UCell) sp[2];
c_addr2 = (Char *) sp[1];
u2 = (UCell) TOS;
sp += 3;
{
n = memcmp(c_addr1, c_addr2, u1<u2 ? u1 : u2);
if (n==0)
  n = u1-u2;
if (n<0)
  n = -1;
else if (n>0)
  n = 1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_dash_text:	/* -text ( c_addr1 u c_addr2 -- n ) */
/*  */
NAME("-text")
{
DEF_CA
Char * c_addr1;
UCell u;
Char * c_addr2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u = (UCell) sp[1];
c_addr2 = (Char *) TOS;
sp += 2;
{
n = memcmp(c_addr1, c_addr2, u);
if (n<0)
  n = -1;
else if (n>0)
  n = 1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_capscomp:	/* capscomp ( c_addr1 u c_addr2 -- n ) */
/*  */
NAME("capscomp")
{
DEF_CA
Char * c_addr1;
UCell u;
Char * c_addr2;
Cell n;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u = (UCell) sp[1];
c_addr2 = (Char *) TOS;
sp += 2;
{
Char c1, c2;
for (;; u--, c_addr1++, c_addr2++) {
  if (u == 0) {
    n = 0;
    break;
  }
  c1 = toupper(*c_addr1);
  c2 = toupper(*c_addr2);
  if (c1 != c2) {
    if (c1 < c2)
      n = -1;
    else
      n = 1;
    break;
  }
}
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_dash_trailing:	/* -trailing ( c_addr u1 -- c_addr u2 ) */
/*  */
NAME("-trailing")
{
DEF_CA
Char * c_addr;
UCell u1;
UCell u2;
NEXT_P0;
c_addr = (Char *) sp[1];
u1 = (UCell) TOS;
{
u2 = u1;
while (c_addr[u2-1] == ' ')
  u2--;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_slash_string:	/* /string ( c_addr1 u1 n -- c_addr2 u2 ) */
/*  */
NAME("/string")
{
DEF_CA
Char * c_addr1;
UCell u1;
Cell n;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[2];
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
c_addr2 = c_addr1+n;
u2 = u1-n;
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_plus:	/* + ( n1 n2 -- n ) */
/*  */
NAME("+")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
n = n1+n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_minus:	/* - ( n1 n2 -- n ) */
/*  */
NAME("-")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
n = n1-n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_negate:	/* negate ( n1 -- n2 ) */
/*  */
NAME("negate")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
/* use minus as alias */
n2 = -n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_one_plus:	/* 1+ ( n1 -- n2 ) */
/*  */
NAME("1+")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = n1+1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_one_minus:	/* 1- ( n1 -- n2 ) */
/*  */
NAME("1-")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = n1-1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_max:	/* max ( n1 n2 -- n ) */
/*  */
NAME("max")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
if (n1<n2)
  n = n2;
else
  n = n1;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_min:	/* min ( n1 n2 -- n ) */
/*  */
NAME("min")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
if (n1<n2)
  n = n1;
else
  n = n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_abs:	/* abs ( n1 -- n2 ) */
/*  */
NAME("abs")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
if (n1<0)
  n2 = -n1;
else
  n2 = n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_star:	/* * ( n1 n2 -- n ) */
/*  */
NAME("*")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
n = n1*n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_slash:	/* / ( n1 n2 -- n ) */
/*  */
NAME("/")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
n = n1/n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_mod:	/* mod ( n1 n2 -- n ) */
/*  */
NAME("mod")
{
DEF_CA
Cell n1;
Cell n2;
Cell n;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
n = n1%n2;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_slash_mod:	/* /mod ( n1 n2 -- n3 n4 ) */
/*  */
NAME("/mod")
{
DEF_CA
Cell n1;
Cell n2;
Cell n3;
Cell n4;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
{
n4 = n1/n2;
n3 = n1%n2; /* !! is this correct? look into C standard! */
}
NEXT_P1;
sp[1] = (Cell)n3;
TOS = (Cell)n4;
NEXT_P2;
}

I_two_star:	/* 2* ( n1 -- n2 ) */
/*  */
NAME("2*")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = 2*n1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_two_slash:	/* 2/ ( n1 -- n2 ) */
/*  */
NAME("2/")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
/* !! is this still correct? */
n2 = n1>>1;
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_f_m_slash_mod:	/* fm/mod ( d1 n1 -- n2 n3 ) */
/* floored division: d1 = n3*n1+n2, n1>n2>=0 or 0>=n2>n1 */
NAME("fm/mod")
{
DEF_CA
DCell d1;
Cell n1;
Cell n2;
Cell n3;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
n1 = (Cell) TOS;
sp += 1;
{
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3>0 is optimized by the compiler */
if (1%-3>0 && (d1<0) != (n1<0) && n2!=0) {
  n3--;
  n2+=n1;
}
}
NEXT_P1;
sp[1] = (Cell)n2;
TOS = (Cell)n3;
NEXT_P2;
}

I_s_m_slash_rem:	/* sm/rem ( d1 n1 -- n2 n3 ) */
/* symmetric division: d1 = n3*n1+n2, sign(n2)=sign(d1) or 0 */
NAME("sm/rem")
{
DEF_CA
DCell d1;
Cell n1;
Cell n2;
Cell n3;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
n1 = (Cell) TOS;
sp += 1;
{
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3<0 is optimized by the compiler */
if (1%-3<0 && (d1<0) != (n1<0) && n2!=0) {
  n3++;
  n2-=n1;
}
}
NEXT_P1;
sp[1] = (Cell)n2;
TOS = (Cell)n3;
NEXT_P2;
}

I_m_star:	/* m* ( n1 n2 -- d ) */
/*  */
NAME("m*")
{
DEF_CA
Cell n1;
Cell n2;
DCell d;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
{
d = (DCell)n1 * (DCell)n2;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_u_m_star:	/* um* ( u1 u2 -- ud ) */
/*  */
NAME("um*")
{
DEF_CA
UCell u1;
UCell u2;
UDCell ud;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
{
/* use u* as alias */
ud = (UDCell)u1 * (UDCell)u2;
}
NEXT_P1;
{Double_Store _d; _d.dcell = ud; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_u_m_slash_mod:	/* um/mod ( ud u1 -- u2 u3 ) */
/*  */
NAME("um/mod")
{
DEF_CA
UDCell ud;
UCell u1;
UCell u2;
UCell u3;
NEXT_P0;
ud= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
u1 = (UCell) TOS;
sp += 1;
{
u3 = ud/u1;
u2 = ud%u1;
}
NEXT_P1;
sp[1] = (Cell)u2;
TOS = (Cell)u3;
NEXT_P2;
}

I_m_plus:	/* m+ ( d1 n -- d2 ) */
/*  */
NAME("m+")
{
DEF_CA
DCell d1;
Cell n;
DCell d2;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
n = (Cell) TOS;
sp += 1;
{
d2 = d1+n;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d2; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_d_plus:	/* d+ ( d1 d2 -- d ) */
/*  */
NAME("d+")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 2;
{
d = d1+d2;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_d_minus:	/* d- ( d1 d2 -- d ) */
/*  */
NAME("d-")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 2;
{
d = d1-d2;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_dnegate:	/* dnegate ( d1 -- d2 ) */
/*  */
NAME("dnegate")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
{
/* use dminus as alias */
d2 = -d1;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d2; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_dmax:	/* dmax ( d1 d2 -- d ) */
/*  */
NAME("dmax")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 2;
{
if (d1<d2)
  d = d2;
else
  d = d1;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_dmin:	/* dmin ( d1 d2 -- d ) */
/*  */
NAME("dmin")
{
DEF_CA
DCell d1;
DCell d2;
DCell d;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 2;
{
if (d1<d2)
  d = d1;
else
  d = d2;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_dabs:	/* dabs ( d1 -- d2 ) */
/*  */
NAME("dabs")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
{
if (d1<0)
  d2 = -d1;
else
  d2 = d1;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d2; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_d_two_star:	/* d2* ( d1 -- d2 ) */
/*  */
NAME("d2*")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
{
d2 = 2*d1;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d2; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_d_two_slash:	/* d2/ ( d1 -- d2 ) */
/*  */
NAME("d2/")
{
DEF_CA
DCell d1;
DCell d2;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
{
/* !! is this still correct? */
d2 = d1>>1;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d2; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_d_to_s:	/* d>s ( d -- n ) */
/*  */
NAME("d>s")
{
DEF_CA
DCell d;
Cell n;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
/* make this an alias for drop? */
n = d;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_and:	/* and ( w1 w2 -- w ) */
/*  */
NAME("and")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
w = w1&w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_or:	/* or ( w1 w2 -- w ) */
/*  */
NAME("or")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
w = w1|w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_xor:	/* xor ( w1 w2 -- w ) */
/*  */
NAME("xor")
{
DEF_CA
Cell w1;
Cell w2;
Cell w;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
w = w1^w2;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_invert:	/* invert ( w1 -- w2 ) */
/*  */
NAME("invert")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) TOS;
{
w2 = ~w1;
}
NEXT_P1;
TOS = (Cell)w2;
NEXT_P2;
}

I_rshift:	/* rshift ( u1 n -- u2 ) */
/*  */
NAME("rshift")
{
DEF_CA
UCell u1;
Cell n;
UCell u2;
NEXT_P0;
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
  u2 = u1>>n;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_lshift:	/* lshift ( u1 n -- u2 ) */
/*  */
NAME("lshift")
{
DEF_CA
UCell u1;
Cell n;
UCell u2;
NEXT_P0;
u1 = (UCell) sp[1];
n = (Cell) TOS;
sp += 1;
{
  u2 = u1<<n;
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_zero_equals:	/* 0= ( n -- f ) */
/*  */
NAME("0=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
f = FLAG(n==0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_different:	/* 0<> ( n -- f ) */
/*  */
NAME("0<>")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
/* use != as alias ? */
f = FLAG(n!=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_less:	/* 0< ( n -- f ) */
/*  */
NAME("0<")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
f = FLAG(n<0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_greater:	/* 0> ( n -- f ) */
/*  */
NAME("0>")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
f = FLAG(n>0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_less_or_equal:	/* 0<= ( n -- f ) */
/*  */
NAME("0<=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
f = FLAG(n<=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_zero_greater_or_equal:	/* 0>= ( n -- f ) */
/*  */
NAME("0>=")
{
DEF_CA
Cell n;
Bool f;
NEXT_P0;
n = (Cell) TOS;
{
f = FLAG(n>=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_equals:	/* = ( n1 n2 -- f ) */
/*  */
NAME("=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
f = FLAG(n1==n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_different:	/* <> ( n1 n2 -- f ) */
/*  */
NAME("<>")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
/* use != as alias ? */
f = FLAG(n1!=n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_less:	/* < ( n1 n2 -- f ) */
/*  */
NAME("<")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
f = FLAG(n1<n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_greater:	/* > ( n1 n2 -- f ) */
/*  */
NAME(">")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
f = FLAG(n1>n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_less_or_equal:	/* <= ( n1 n2 -- f ) */
/*  */
NAME("<=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
f = FLAG(n1<=n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_greater_or_equal:	/* >= ( n1 n2 -- f ) */
/*  */
NAME(">=")
{
DEF_CA
Cell n1;
Cell n2;
Bool f;
NEXT_P0;
n1 = (Cell) sp[1];
n2 = (Cell) TOS;
sp += 1;
{
f = FLAG(n1>=n2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_equals:	/* u= ( u1 u2 -- f ) */
/*  */
NAME("u=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
f = FLAG(u1==u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_different:	/* u<> ( u1 u2 -- f ) */
/*  */
NAME("u<>")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
/* use != as alias ? */
f = FLAG(u1!=u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_less:	/* u< ( u1 u2 -- f ) */
/*  */
NAME("u<")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
f = FLAG(u1<u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_greater:	/* u> ( u1 u2 -- f ) */
/*  */
NAME("u>")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
f = FLAG(u1>u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_less_or_equal:	/* u<= ( u1 u2 -- f ) */
/*  */
NAME("u<=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
f = FLAG(u1<=u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_u_greater_or_equal:	/* u>= ( u1 u2 -- f ) */
/*  */
NAME("u>=")
{
DEF_CA
UCell u1;
UCell u2;
Bool f;
NEXT_P0;
u1 = (UCell) sp[1];
u2 = (UCell) TOS;
sp += 1;
{
f = FLAG(u1>=u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_equals:	/* d= ( d1 d2 -- f ) */
/*  */
NAME("d=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(d1==d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_different:	/* d<> ( d1 d2 -- f ) */
/*  */
NAME("d<>")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
/* use != as alias ? */
f = FLAG(d1!=d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_less:	/* d< ( d1 d2 -- f ) */
/*  */
NAME("d<")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(d1<d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_greater:	/* d> ( d1 d2 -- f ) */
/*  */
NAME("d>")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(d1>d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_less_or_equal:	/* d<= ( d1 d2 -- f ) */
/*  */
NAME("d<=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(d1<=d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_greater_or_equal:	/* d>= ( d1 d2 -- f ) */
/*  */
NAME("d>=")
{
DEF_CA
DCell d1;
DCell d2;
Bool f;
NEXT_P0;
d1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
d2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(d1>=d2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_equals:	/* d0= ( d -- f ) */
/*  */
NAME("d0=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
f = FLAG(d==0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_different:	/* d0<> ( d -- f ) */
/*  */
NAME("d0<>")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
/* use != as alias ? */
f = FLAG(d!=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_less:	/* d0< ( d -- f ) */
/*  */
NAME("d0<")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
f = FLAG(d<0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_greater:	/* d0> ( d -- f ) */
/*  */
NAME("d0>")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
f = FLAG(d>0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_less_or_equal:	/* d0<= ( d -- f ) */
/*  */
NAME("d0<=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
f = FLAG(d<=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_zero_greater_or_equal:	/* d0>= ( d -- f ) */
/*  */
NAME("d0>=")
{
DEF_CA
DCell d;
Bool f;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 1;
{
f = FLAG(d>=0);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_equals:	/* du= ( ud1 ud2 -- f ) */
/*  */
NAME("du=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(ud1==ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_different:	/* du<> ( ud1 ud2 -- f ) */
/*  */
NAME("du<>")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
/* use != as alias ? */
f = FLAG(ud1!=ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_less:	/* du< ( ud1 ud2 -- f ) */
/*  */
NAME("du<")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(ud1<ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_greater:	/* du> ( ud1 ud2 -- f ) */
/*  */
NAME("du>")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(ud1>ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_less_or_equal:	/* du<= ( ud1 ud2 -- f ) */
/*  */
NAME("du<=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(ud1<=ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_d_u_greater_or_equal:	/* du>= ( ud1 ud2 -- f ) */
/*  */
NAME("du>=")
{
DEF_CA
UDCell ud1;
UDCell ud2;
Bool f;
NEXT_P0;
ud1= ({Double_Store _d; _d.cells.low = sp[3]; _d.cells.high = sp[2]; _d.dcell;});
ud2= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 3;
{
f = FLAG(ud1>=ud2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_within:	/* within ( u1 u2 u3 -- f ) */
/*  */
NAME("within")
{
DEF_CA
UCell u1;
UCell u2;
UCell u3;
Bool f;
NEXT_P0;
u1 = (UCell) sp[2];
u2 = (UCell) sp[1];
u3 = (UCell) TOS;
sp += 2;
{
f = FLAG(u1-u2 < u3-u2);
}
NEXT_P1;
TOS = (Cell)f;
NEXT_P2;
}

I_spat:	/* sp@ ( -- a_addr ) */
/*  */
NAME("sp@")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
a_addr = sp+1;
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_spstore:	/* sp! ( a_addr -- ) */
/*  */
NAME("sp!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
sp = a_addr;
/* works with and without TOS caching */
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_rpat:	/* rp@ ( -- a_addr ) */
/*  */
NAME("rp@")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
a_addr = rp;
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_rpstore:	/* rp! ( a_addr -- ) */
/*  */
NAME("rp!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
rp = a_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_fp_fetch:	/* fp@ ( -- f_addr ) */
/*  */
NAME("fp@")
{
DEF_CA
Float * f_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
f_addr = fp;
}
NEXT_P1;
TOS = (Cell)f_addr;
NEXT_P2;
}

I_fp_store:	/* fp! ( f_addr -- ) */
/*  */
NAME("fp!")
{
DEF_CA
Float * f_addr;
NEXT_P0;
f_addr = (Float *) TOS;
sp += 1;
{
fp = f_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_semis:	/* ;s ( -- ) */
/*  */
NAME(";s")
{
DEF_CA
NEXT_P0;
{
ip = (Xt *)(*rp++);
NEXT_P0;
}
NEXT_P1;
NEXT_P2;
}

I_to_r:	/* >r ( w -- ) */
/*  */
NAME(">r")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
*--rp = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_r_from:	/* r> ( -- w ) */
/*  */
NAME("r>")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *rp++;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_r_fetch:	/* r@ ( -- w ) */
/*  */
NAME("r@")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
/* use r as alias */
/* make r@ an alias for i */
w = *rp;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_rdrop:	/* rdrop ( -- ) */
/*  */
NAME("rdrop")
{
DEF_CA
NEXT_P0;
{
rp++;
}
NEXT_P1;
NEXT_P2;
}

I_i_tick:	/* i' ( -- w ) */
/*  */
NAME("i'")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w=rp[1];
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_two_to_r:	/* 2>r ( w1 w2 -- ) */
/*  */
NAME("2>r")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 2;
{
*--rp = w1;
*--rp = w2;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_r_from:	/* 2r> ( -- w1 w2 ) */
/*  */
NAME("2r>")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
w2 = *rp++;
w1 = *rp++;
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_r_fetch:	/* 2r@ ( -- w1 w2 ) */
/*  */
NAME("2r@")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -2;
{
w2 = rp[0];
w1 = rp[1];
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_r_drop:	/* 2rdrop ( -- ) */
/*  */
NAME("2rdrop")
{
DEF_CA
NEXT_P0;
{
rp+=2;
}
NEXT_P1;
NEXT_P2;
}

I_over:	/* over ( w1 w2 -- w1 w2 w1 ) */
/*  */
NAME("over")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -1;
{
}
NEXT_P1;
IF_TOS(sp[1] = (Cell)w2;);
TOS = (Cell)w1;
NEXT_P2;
}

I_drop:	/* drop ( w -- ) */
/*  */
NAME("drop")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_swap:	/* swap ( w1 w2 -- w2 w1 ) */
/*  */
NAME("swap")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
{
}
NEXT_P1;
sp[1] = (Cell)w2;
TOS = (Cell)w1;
NEXT_P2;
}

I_dup:	/* dup ( w -- w w ) */
/*  */
NAME("dup")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += -1;
{
}
NEXT_P1;
IF_TOS(sp[1] = (Cell)w;);
TOS = (Cell)w;
NEXT_P2;
}

I_rote:	/* rot ( w1 w2 w3 -- w2 w3 w1 ) */
/*  */
NAME("rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
w3 = (Cell) TOS;
{
}
NEXT_P1;
sp[2] = (Cell)w2;
sp[1] = (Cell)w3;
TOS = (Cell)w1;
NEXT_P2;
}

I_not_rote:	/* -rot ( w1 w2 w3 -- w3 w1 w2 ) */
/*  */
NAME("-rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
w3 = (Cell) TOS;
{
}
NEXT_P1;
sp[2] = (Cell)w3;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_nip:	/* nip ( w1 w2 -- w2 ) */
/*  */
NAME("nip")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 1;
{
}
NEXT_P1;
TOS = (Cell)w2;
NEXT_P2;
}

I_tuck:	/* tuck ( w1 w2 -- w2 w1 w2 ) */
/*  */
NAME("tuck")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -1;
{
}
NEXT_P1;
sp[2] = (Cell)w2;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_question_dupe:	/* ?dup ( w -- w ) */
/*  */
NAME("?dup")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
{
if (w!=0) {
  IF_TOS(*sp-- = w;)
#ifndef USE_TOS
  *--sp = w;
#endif
}
}
NEXT_P1;
IF_TOS(TOS = (Cell)w;);
NEXT_P2;
}

I_pick:	/* pick ( u -- w ) */
/*  */
NAME("pick")
{
DEF_CA
UCell u;
Cell w;
NEXT_P0;
u = (UCell) TOS;
{
w = sp[u+1];
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_two_drop:	/* 2drop ( w1 w2 -- ) */
/*  */
NAME("2drop")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += 2;
{
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_dupe:	/* 2dup ( w1 w2 -- w1 w2 w1 w2 ) */
/*  */
NAME("2dup")
{
DEF_CA
Cell w1;
Cell w2;
NEXT_P0;
w1 = (Cell) sp[1];
w2 = (Cell) TOS;
sp += -2;
{
}
NEXT_P1;
IF_TOS(sp[2] = (Cell)w2;);
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_over:	/* 2over ( w1 w2 w3 w4 -- w1 w2 w3 w4 w1 w2 ) */
/*  */
NAME("2over")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
sp += -2;
{
}
NEXT_P1;
IF_TOS(sp[2] = (Cell)w4;);
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_swap:	/* 2swap ( w1 w2 w3 w4 -- w3 w4 w1 w2 ) */
/*  */
NAME("2swap")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
NEXT_P0;
w1 = (Cell) sp[3];
w2 = (Cell) sp[2];
w3 = (Cell) sp[1];
w4 = (Cell) TOS;
{
}
NEXT_P1;
sp[3] = (Cell)w3;
sp[2] = (Cell)w4;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_two_rote:	/* 2rot ( w1 w2 w3 w4 w5 w6 -- w3 w4 w5 w6 w1 w2 ) */
/*  */
NAME("2rot")
{
DEF_CA
Cell w1;
Cell w2;
Cell w3;
Cell w4;
Cell w5;
Cell w6;
NEXT_P0;
w1 = (Cell) sp[5];
w2 = (Cell) sp[4];
w3 = (Cell) sp[3];
w4 = (Cell) sp[2];
w5 = (Cell) sp[1];
w6 = (Cell) TOS;
{
}
NEXT_P1;
sp[5] = (Cell)w3;
sp[4] = (Cell)w4;
sp[3] = (Cell)w5;
sp[2] = (Cell)w6;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_fetch:	/* @ ( a_addr -- w ) */
/*  */
NAME("@")
{
DEF_CA
Cell * a_addr;
Cell w;
NEXT_P0;
a_addr = (Cell *) TOS;
{
w = *a_addr;
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_store:	/* ! ( w a_addr -- ) */
/*  */
NAME("!")
{
DEF_CA
Cell w;
Cell * a_addr;
NEXT_P0;
w = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
*a_addr = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_plus_store:	/* +! ( n a_addr -- ) */
/*  */
NAME("+!")
{
DEF_CA
Cell n;
Cell * a_addr;
NEXT_P0;
n = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
*a_addr += n;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_cfetch:	/* c@ ( c_addr -- c ) */
/*  */
NAME("c@")
{
DEF_CA
Char * c_addr;
Char c;
NEXT_P0;
c_addr = (Char *) TOS;
{
c = *c_addr;
}
NEXT_P1;
TOS = (Cell)c;
NEXT_P2;
}

I_cstore:	/* c! ( c c_addr -- ) */
/*  */
NAME("c!")
{
DEF_CA
Char c;
Char * c_addr;
NEXT_P0;
c = (Char) sp[1];
c_addr = (Char *) TOS;
sp += 2;
{
*c_addr = c;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_store:	/* 2! ( w1 w2 a_addr -- ) */
/*  */
NAME("2!")
{
DEF_CA
Cell w1;
Cell w2;
Cell * a_addr;
NEXT_P0;
w1 = (Cell) sp[2];
w2 = (Cell) sp[1];
a_addr = (Cell *) TOS;
sp += 3;
{
a_addr[0] = w2;
a_addr[1] = w1;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_two_fetch:	/* 2@ ( a_addr -- w1 w2 ) */
/*  */
NAME("2@")
{
DEF_CA
Cell * a_addr;
Cell w1;
Cell w2;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += -1;
{
w2 = a_addr[0];
w1 = a_addr[1];
}
NEXT_P1;
sp[1] = (Cell)w1;
TOS = (Cell)w2;
NEXT_P2;
}

I_d_store:	/* d! ( d a_addr -- ) */
/*  */
NAME("d!")
{
DEF_CA
DCell d;
Cell * a_addr;
NEXT_P0;
d= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
a_addr = (Cell *) TOS;
sp += 3;
{
/* !! alignment problems on some machines */
*(DCell *)a_addr = d;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_d_fetch:	/* d@ ( a_addr -- d ) */
/*  */
NAME("d@")
{
DEF_CA
Cell * a_addr;
DCell d;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += -1;
{
d = *(DCell *)a_addr;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
NEXT_P2;
}

I_cell_plus:	/* cell+ ( a_addr1 -- a_addr2 ) */
/*  */
NAME("cell+")
{
DEF_CA
Cell * a_addr1;
Cell * a_addr2;
NEXT_P0;
a_addr1 = (Cell *) TOS;
{
a_addr2 = a_addr1+1;
}
NEXT_P1;
TOS = (Cell)a_addr2;
NEXT_P2;
}

I_cells:	/* cells ( n1 -- n2 ) */
/*  */
NAME("cells")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = n1 * sizeof(Cell);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_care_plus:	/* char+ ( c_addr1 -- c_addr2 ) */
/*  */
NAME("char+")
{
DEF_CA
Char * c_addr1;
Char * c_addr2;
NEXT_P0;
c_addr1 = (Char *) TOS;
{
c_addr2 = c_addr1 + 1;
}
NEXT_P1;
TOS = (Cell)c_addr2;
NEXT_P2;
}

I_paren_cares:	/* (chars) ( n1 -- n2 ) */
/*  */
NAME("(chars)")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = n1 * sizeof(Char);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_count:	/* count ( c_addr1 -- c_addr2 u ) */
/*  */
NAME("count")
{
DEF_CA
Char * c_addr1;
Char * c_addr2;
UCell u;
NEXT_P0;
c_addr1 = (Char *) TOS;
sp += -1;
{
u = *c_addr1;
c_addr2 = c_addr1+1;
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u;
NEXT_P2;
}

I_paren_bye:	/* (bye) ( n -- ) */
/*  */
NAME("(bye)")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
return (Label *)n;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_system:	/* system ( c_addr u -- n ) */
/*  */
NAME("system")
{
DEF_CA
Char * c_addr;
UCell u;
Cell n;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 1;
{
n=system(cstr(c_addr,u,1)); /* ~ expansion on first part of string? */
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_getenv:	/* getenv ( c_addr1 u1 -- c_addr2 u2 ) */
/*  */
NAME("getenv")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[1];
u1 = (UCell) TOS;
{
c_addr2 = getenv(cstr(c_addr1,u1,1));
u2=strlen(c_addr2);
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_popen:	/* popen ( c_addr u n -- wfileid ) */
/*  */
NAME("popen")
{
DEF_CA
Char * c_addr;
UCell u;
Cell n;
Cell wfileid;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
n = (Cell) TOS;
sp += 2;
{
static char* mode[2]={"r","w"}; /* !! should we use FAM here? */
wfileid=(Cell)popen(cstr(c_addr,u,1),mode[n]); /* ~ expansion of 1st arg? */
}
NEXT_P1;
TOS = (Cell)wfileid;
NEXT_P2;
}

I_pclose:	/* pclose ( wfileid -- wior ) */
/*  */
NAME("pclose")
{
DEF_CA
Cell wfileid;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
{
wior=pclose((FILE *)wfileid); /* !! what to do with the result */
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_time_and_date:	/* time&date ( -- nsec nmin nhour nday nmonth nyear ) */
/*  */
NAME("time&date")
{
DEF_CA
Cell nsec;
Cell nmin;
Cell nhour;
Cell nday;
Cell nmonth;
Cell nyear;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -6;
{
struct timeval time1;
struct timezone zone1;
struct tm *ltime;
gettimeofday(&time1,&zone1);
ltime=localtime(&time1.tv_sec);
nyear =ltime->tm_year+1900;
nmonth=ltime->tm_mon+1;
nday  =ltime->tm_mday;
nhour =ltime->tm_hour;
nmin  =ltime->tm_min;
nsec  =ltime->tm_sec;
}
NEXT_P1;
sp[5] = (Cell)nsec;
sp[4] = (Cell)nmin;
sp[3] = (Cell)nhour;
sp[2] = (Cell)nday;
sp[1] = (Cell)nmonth;
TOS = (Cell)nyear;
NEXT_P2;
}

I_ms:	/* ms ( n -- ) */
/*  */
NAME("ms")
{
DEF_CA
Cell n;
NEXT_P0;
n = (Cell) TOS;
sp += 1;
{
struct timeval timeout;
timeout.tv_sec=n/1000;
timeout.tv_usec=1000*(n%1000);
(void)select(0,0,0,0,&timeout);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_allocate:	/* allocate ( u -- a_addr wior ) */
/*  */
NAME("allocate")
{
DEF_CA
UCell u;
Cell * a_addr;
Cell wior;
NEXT_P0;
u = (UCell) TOS;
sp += -1;
{
a_addr = (Cell *)malloc(u);
wior = IOR(a_addr==NULL);
}
NEXT_P1;
sp[1] = (Cell)a_addr;
TOS = (Cell)wior;
NEXT_P2;
}

I_free:	/* free ( a_addr -- wior ) */
/*  */
NAME("free")
{
DEF_CA
Cell * a_addr;
Cell wior;
NEXT_P0;
a_addr = (Cell *) TOS;
{
free(a_addr);
wior = 0;
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_resize:	/* resize ( a_addr1 u -- a_addr2 wior ) */
/* Change the size of the allocated area at @i{a_addr1} to @i{u}
address units, possibly moving the contents to a different
area. @i{a_addr2} is the address of the resulting area. If
@code{a_addr2} is 0, gforth's (but not the standard) @code{resize}
@code{allocate}s @i{u} address units. */
NAME("resize")
{
DEF_CA
Cell * a_addr1;
UCell u;
Cell * a_addr2;
Cell wior;
NEXT_P0;
a_addr1 = (Cell *) sp[1];
u = (UCell) TOS;
{
/* the following check is not necessary on most OSs, but it is needed
   on SunOS 4.1.2. */
if (a_addr1==NULL)
  a_addr2 = (Cell *)malloc(u);
else
  a_addr2 = (Cell *)realloc(a_addr1, u);
wior = IOR(a_addr2==NULL);	/* !! Define a return code */
}
NEXT_P1;
sp[1] = (Cell)a_addr2;
TOS = (Cell)wior;
NEXT_P2;
}

I_paren_f83find:	/* (f83find) ( c_addr u f83name1 -- f83name2 ) */
/*  */
NAME("(f83find)")
{
DEF_CA
Char * c_addr;
UCell u;
F83Name * f83name1;
F83Name * f83name2;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
f83name1 = (F83Name *) TOS;
sp += 2;
{
for (; f83name1 != NULL; f83name1 = f83name1->next)
  if (F83NAME_COUNT(f83name1)==u &&
      strncasecmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
    break;
f83name2=f83name1;
}
NEXT_P1;
TOS = (Cell)f83name2;
NEXT_P2;
}

I_paren_hashfind:	/* (hashfind) ( c_addr u a_addr -- f83name2 ) */
/*  */
NAME("(hashfind)")
{
DEF_CA
Char * c_addr;
UCell u;
Cell * a_addr;
F83Name * f83name2;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
a_addr = (Cell *) TOS;
sp += 2;
{
F83Name *f83name1;
f83name2=NULL;
while(a_addr != NULL)
{
   f83name1=(F83Name *)(a_addr[1]);
   a_addr=(Cell *)(a_addr[0]);
   if (F83NAME_COUNT(f83name1)==u &&
       strncasecmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
     {
	f83name2=f83name1;
	break;
     }
}
}
NEXT_P1;
TOS = (Cell)f83name2;
NEXT_P2;
}

I_paren_hashkey:	/* (hashkey) ( c_addr u1 -- u2 ) */
/*  */
NAME("(hashkey)")
{
DEF_CA
Char * c_addr;
UCell u1;
UCell u2;
NEXT_P0;
c_addr = (Char *) sp[1];
u1 = (UCell) TOS;
sp += 1;
{
u2=0;
while(u1--)
   u2+=(Cell)toupper(*c_addr++);
}
NEXT_P1;
TOS = (Cell)u2;
NEXT_P2;
}

I_paren_hashkey1:	/* (hashkey1) ( c_addr u ubits -- ukey ) */
/* ukey is the hash key for the string c_addr u fitting in ubits bits */
NAME("(hashkey1)")
{
DEF_CA
Char * c_addr;
UCell u;
UCell ubits;
UCell ukey;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ubits = (UCell) TOS;
sp += 2;
{
/* this hash function rotates the key at every step by rot bits within
   ubits bits and xors it with the character. This function does ok in
   the chi-sqare-test.  Rot should be <=7 (preferably <=5) for
   ASCII strings (larger if ubits is large), and should share no
   divisors with ubits.
*/
unsigned rot = ((char []){5,0,1,2,3,4,5,5,5,5,3,5,5,5,5,7,5,5,5,5,7,5,5,5,5,6,5,5,5,5,7,5,5})[ubits];
Char *cp = c_addr;
for (ukey=0; cp<c_addr+u; cp++)
    ukey = ((((ukey<<rot) | (ukey>>(ubits-rot))) 
	     ^ toupper(*cp))
	    & ((1<<ubits)-1));
}
NEXT_P1;
TOS = (Cell)ukey;
NEXT_P2;
}

I_paren_parse_white:	/* (parse-white) ( c_addr1 u1 -- c_addr2 u2 ) */
/*  */
NAME("(parse-white)")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
NEXT_P0;
c_addr1 = (Char *) sp[1];
u1 = (UCell) TOS;
{
/* use !isgraph instead of isspace? */
Char *endp = c_addr1+u1;
while (c_addr1<endp && isspace(*c_addr1))
  c_addr1++;
if (c_addr1<endp) {
  for (c_addr2 = c_addr1; c_addr1<endp && !isspace(*c_addr1); c_addr1++)
    ;
  u2 = c_addr1-c_addr2;
}
else {
  c_addr2 = c_addr1;
  u2 = 0;
}
}
NEXT_P1;
sp[1] = (Cell)c_addr2;
TOS = (Cell)u2;
NEXT_P2;
}

I_close_file:	/* close-file ( wfileid -- wior ) */
/*  */
NAME("close-file")
{
DEF_CA
Cell wfileid;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
{
wior = IOR(fclose((FILE *)wfileid)==EOF);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_open_file:	/* open-file ( c_addr u ntype -- w2 wior ) */
/*  */
NAME("open-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell w2;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ntype = (Cell) TOS;
sp += 1;
{
w2 = (Cell)fopen(tilde_cstr(c_addr, u, 1), fileattr[ntype]);
wior =  IOR(w2 == NULL);
}
NEXT_P1;
sp[1] = (Cell)w2;
TOS = (Cell)wior;
NEXT_P2;
}

I_create_file:	/* create-file ( c_addr u ntype -- w2 wior ) */
/*  */
NAME("create-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell w2;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u = (UCell) sp[1];
ntype = (Cell) TOS;
sp += 1;
{
Cell	fd;
fd = open(tilde_cstr(c_addr, u, 1), O_CREAT|O_RDWR|O_TRUNC, 0666);
if (fd != -1) {
  w2 = (Cell)fdopen(fd, fileattr[ntype]);
  wior = IOR(w2==NULL);
} else {
  w2 = 0;
  wior = IOR(1);
}
}
NEXT_P1;
sp[1] = (Cell)w2;
TOS = (Cell)wior;
NEXT_P2;
}

I_delete_file:	/* delete-file ( c_addr u -- wior ) */
/*  */
NAME("delete-file")
{
DEF_CA
Char * c_addr;
UCell u;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 1;
{
wior = IOR(unlink(tilde_cstr(c_addr, u, 1))==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_rename_file:	/* rename-file ( c_addr1 u1 c_addr2 u2 -- wior ) */
/*  */
NAME("rename-file")
{
DEF_CA
Char * c_addr1;
UCell u1;
Char * c_addr2;
UCell u2;
Cell wior;
NEXT_P0;
c_addr1 = (Char *) sp[3];
u1 = (UCell) sp[2];
c_addr2 = (Char *) sp[1];
u2 = (UCell) TOS;
sp += 3;
{
char *s1=tilde_cstr(c_addr2, u2, 1);
wior = IOR(rename(tilde_cstr(c_addr1, u1, 0), s1)==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_position:	/* file-position ( wfileid -- ud wior ) */
/*  */
NAME("file-position")
{
DEF_CA
Cell wfileid;
UDCell ud;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
sp += -2;
{
/* !! use tell and lseek? */
ud = ftell((FILE *)wfileid);
wior = IOR(ud==-1);
}
NEXT_P1;
{Double_Store _d; _d.dcell = ud; sp[2] = _d.cells.low; sp[1]= _d.cells.high;}
TOS = (Cell)wior;
NEXT_P2;
}

I_reposition_file:	/* reposition-file ( ud wfileid -- wior ) */
/*  */
NAME("reposition-file")
{
DEF_CA
UDCell ud;
Cell wfileid;
Cell wior;
NEXT_P0;
ud= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
wfileid = (Cell) TOS;
sp += 2;
{
wior = IOR(fseek((FILE *)wfileid, (long)ud, SEEK_SET)==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_size:	/* file-size ( wfileid -- ud wior ) */
/*  */
NAME("file-size")
{
DEF_CA
Cell wfileid;
UDCell ud;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
sp += -2;
{
struct stat buf;
wior = IOR(fstat(fileno((FILE *)wfileid), &buf)==-1);
ud = buf.st_size;
}
NEXT_P1;
{Double_Store _d; _d.dcell = ud; sp[2] = _d.cells.low; sp[1]= _d.cells.high;}
TOS = (Cell)wior;
NEXT_P2;
}

I_resize_file:	/* resize-file ( ud wfileid -- wior ) */
/*  */
NAME("resize-file")
{
DEF_CA
UDCell ud;
Cell wfileid;
Cell wior;
NEXT_P0;
ud= ({Double_Store _d; _d.cells.low = sp[2]; _d.cells.high = sp[1]; _d.dcell;});
wfileid = (Cell) TOS;
sp += 2;
{
wior = IOR(ftruncate(fileno((FILE *)wfileid), (Cell)ud)==-1);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_read_file:	/* read-file ( c_addr u1 wfileid -- u2 wior ) */
/*  */
NAME("read-file")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
UCell u2;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
sp += 1;
{
/* !! fread does not guarantee enough */
u2 = fread(c_addr, sizeof(Char), u1, (FILE *)wfileid);
wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
/* !! is the value of ferror errno-compatible? */
if (wior)
  clearerr((FILE *)wfileid);
}
NEXT_P1;
sp[1] = (Cell)u2;
TOS = (Cell)wior;
NEXT_P2;
}

I_read_line:	/* read-line ( c_addr u1 wfileid -- u2 flag wior ) */
/*  */
NAME("read-line")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
UCell u2;
Bool flag;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
{
/*
Cell c;
flag=-1;
for(u2=0; u2<u1; u2++)
{
   *c_addr++ = (Char)(c = getc((FILE *)wfileid));
   if(c=='\n') break;
   if(c==EOF)
     {
	flag=FLAG(u2!=0);
	break;
     }
}
wior=FILEIO(ferror((FILE *)wfileid));
*/
if ((flag=FLAG(!feof((FILE *)wfileid) &&
	       fgets(c_addr,u1+1,(FILE *)wfileid) != NULL))) {
  wior=FILEIO(ferror((FILE *)wfileid)); /* !! ior? */
  if (wior)
    clearerr((FILE *)wfileid);
  u2 = strlen(c_addr);
  u2-=((u2>0) && (c_addr[u2-1]==NEWLINE));
}
else {
  wior=0;
  u2=0;
}
}
NEXT_P1;
sp[2] = (Cell)u2;
sp[1] = (Cell)flag;
TOS = (Cell)wior;
NEXT_P2;
}

I_write_file:	/* write-file ( c_addr u1 wfileid -- wior ) */
/*  */
NAME("write-file")
{
DEF_CA
Char * c_addr;
UCell u1;
Cell wfileid;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[2];
u1 = (UCell) sp[1];
wfileid = (Cell) TOS;
sp += 2;
{
/* !! fwrite does not guarantee enough */
{
  Cell u2 = fwrite(c_addr, sizeof(Char), u1, (FILE *)wfileid);
  wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
  if (wior)
    clearerr((FILE *)wfileid);
}
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_flush_file:	/* flush-file ( wfileid -- wior ) */
/*  */
NAME("flush-file")
{
DEF_CA
Cell wfileid;
Cell wior;
NEXT_P0;
wfileid = (Cell) TOS;
{
wior = IOR(fflush((FILE *) wfileid)==EOF);
}
NEXT_P1;
TOS = (Cell)wior;
NEXT_P2;
}

I_file_status:	/* file-status ( c_addr u -- ntype wior ) */
/*  */
NAME("file-status")
{
DEF_CA
Char * c_addr;
UCell u;
Cell ntype;
Cell wior;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
{
char *filename=tilde_cstr(c_addr, u, 1);
if (access (filename, F_OK) != 0) {
  ntype=0;
  wior=IOR(1);
}
else if (access (filename, R_OK | W_OK) == 0) {
  ntype=2; /* r/w */
  wior=0;
}
else if (access (filename, R_OK) == 0) {
  ntype=0; /* r/o */
  wior=0;
}
else if (access (filename, W_OK) == 0) {
  ntype=4; /* w/o */
  wior=0;
}
else {
  ntype=1; /* well, we cannot access the file, but better deliver a legal
	    access mode (r/o bin), so we get a decent error later upon open. */
  wior=0;
}
}
NEXT_P1;
sp[1] = (Cell)ntype;
TOS = (Cell)wior;
NEXT_P2;
}

I_f_equals:	/* f= ( r1 r2 -- f ) */
/*  */
NAME("f=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
f = FLAG(r1==r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_different:	/* f<> ( r1 r2 -- f ) */
/*  */
NAME("f<>")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
/* use != as alias ? */
f = FLAG(r1!=r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_less:	/* f< ( r1 r2 -- f ) */
/*  */
NAME("f<")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
f = FLAG(r1<r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_greater:	/* f> ( r1 r2 -- f ) */
/*  */
NAME("f>")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
f = FLAG(r1>r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_less_or_equal:	/* f<= ( r1 r2 -- f ) */
/*  */
NAME("f<=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
f = FLAG(r1<=r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_greater_or_equal:	/* f>= ( r1 r2 -- f ) */
/*  */
NAME("f>=")
{
DEF_CA
Float r1;
Float r2;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r1 = fp[1];
r2 = FTOS;
sp += -1;
fp += 2;
{
f = FLAG(r1>=r2);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_equals:	/* f0= ( r -- f ) */
/*  */
NAME("f0=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
f = FLAG(r==0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_different:	/* f0<> ( r -- f ) */
/*  */
NAME("f0<>")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
/* use != as alias ? */
f = FLAG(r!=0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_less:	/* f0< ( r -- f ) */
/*  */
NAME("f0<")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
f = FLAG(r<0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_greater:	/* f0> ( r -- f ) */
/*  */
NAME("f0>")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
f = FLAG(r>0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_less_or_equal:	/* f0<= ( r -- f ) */
/*  */
NAME("f0<=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
f = FLAG(r<=0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_zero_greater_or_equal:	/* f0>= ( r -- f ) */
/*  */
NAME("f0>=")
{
DEF_CA
Float r;
Bool f;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -1;
fp += 1;
{
f = FLAG(r>=0.);
}
NEXT_P1;
TOS = (Cell)f;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_d_to_f:	/* d>f ( d -- r ) */
/*  */
NAME("d>f")
{
DEF_CA
DCell d;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
d= ({Double_Store _d; _d.cells.low = sp[1]; _d.cells.high = TOS; _d.dcell;});
sp += 2;
fp += -1;
{
r = d;
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_to_d:	/* f>d ( r -- d ) */
/*  */
NAME("f>d")
{
DEF_CA
Float r;
DCell d;
NEXT_P0;
IF_TOS(sp[0] = TOS);
r = FTOS;
sp += -2;
fp += 1;
{
/* !! basis 15 is not very specific */
d = r;
}
NEXT_P1;
{Double_Store _d; _d.dcell = d; sp[1] = _d.cells.low; TOS= _d.cells.high;}
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_f_store:	/* f! ( r f_addr -- ) */
/*  */
NAME("f!")
{
DEF_CA
Float r;
Float * f_addr;
NEXT_P0;
r = FTOS;
f_addr = (Float *) TOS;
sp += 1;
fp += 1;
{
*f_addr = r;
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_fetch:	/* f@ ( f_addr -- r ) */
/*  */
NAME("f@")
{
DEF_CA
Float * f_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
f_addr = (Float *) TOS;
sp += 1;
fp += -1;
{
r = *f_addr;
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_d_f_fetch:	/* df@ ( df_addr -- r ) */
/*  */
NAME("df@")
{
DEF_CA
DFloat * df_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
df_addr = (DFloat *) TOS;
sp += 1;
fp += -1;
{
#ifdef IEEE_FP
r = *df_addr;
#else
!! df@
#endif
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_d_f_store:	/* df! ( r df_addr -- ) */
/*  */
NAME("df!")
{
DEF_CA
Float r;
DFloat * df_addr;
NEXT_P0;
r = FTOS;
df_addr = (DFloat *) TOS;
sp += 1;
fp += 1;
{
#ifdef IEEE_FP
*df_addr = r;
#else
!! df!
#endif
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_s_f_fetch:	/* sf@ ( sf_addr -- r ) */
/*  */
NAME("sf@")
{
DEF_CA
SFloat * sf_addr;
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
sf_addr = (SFloat *) TOS;
sp += 1;
fp += -1;
{
#ifdef IEEE_FP
r = *sf_addr;
#else
!! sf@
#endif
}
NEXT_P1;
FTOS = r;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_s_f_store:	/* sf! ( r sf_addr -- ) */
/*  */
NAME("sf!")
{
DEF_CA
Float r;
SFloat * sf_addr;
NEXT_P0;
r = FTOS;
sf_addr = (SFloat *) TOS;
sp += 1;
fp += 1;
{
#ifdef IEEE_FP
*sf_addr = r;
#else
!! sf!
#endif
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_plus:	/* f+ ( r1 r2 -- r3 ) */
/*  */
NAME("f+")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = r1+r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_minus:	/* f- ( r1 r2 -- r3 ) */
/*  */
NAME("f-")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = r1-r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_star:	/* f* ( r1 r2 -- r3 ) */
/*  */
NAME("f*")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = r1*r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_slash:	/* f/ ( r1 r2 -- r3 ) */
/*  */
NAME("f/")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = r1/r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_f_star_star:	/* f** ( r1 r2 -- r3 ) */
/* @i{r3} is @i{r1} raised to the @i{r2}th power */
NAME("f**")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = pow(r1,r2);
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_fnegate:	/* fnegate ( r1 -- r2 ) */
/*  */
NAME("fnegate")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = - r1;
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fdrop:	/* fdrop ( r -- ) */
/*  */
NAME("fdrop")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += 1;
{
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_fdup:	/* fdup ( r -- r r ) */
/*  */
NAME("fdup")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += -1;
{
}
NEXT_P1;
IF_FTOS(fp[1] = r;);
FTOS = r;
NEXT_P2;
}

I_fswap:	/* fswap ( r1 r2 -- r2 r1 ) */
/*  */
NAME("fswap")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
{
}
NEXT_P1;
fp[1] = r2;
FTOS = r1;
NEXT_P2;
}

I_fover:	/* fover ( r1 r2 -- r1 r2 r1 ) */
/*  */
NAME("fover")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += -1;
{
}
NEXT_P1;
IF_FTOS(fp[1] = r2;);
FTOS = r1;
NEXT_P2;
}

I_frot:	/* frot ( r1 r2 r3 -- r2 r3 r1 ) */
/*  */
NAME("frot")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[2];
r2 = fp[1];
r3 = FTOS;
{
}
NEXT_P1;
fp[2] = r2;
fp[1] = r3;
FTOS = r1;
NEXT_P2;
}

I_float_plus:	/* float+ ( f_addr1 -- f_addr2 ) */
/*  */
NAME("float+")
{
DEF_CA
Float * f_addr1;
Float * f_addr2;
NEXT_P0;
f_addr1 = (Float *) TOS;
{
f_addr2 = f_addr1+1;
}
NEXT_P1;
TOS = (Cell)f_addr2;
NEXT_P2;
}

I_floats:	/* floats ( n1 -- n2 ) */
/*  */
NAME("floats")
{
DEF_CA
Cell n1;
Cell n2;
NEXT_P0;
n1 = (Cell) TOS;
{
n2 = n1*sizeof(Float);
}
NEXT_P1;
TOS = (Cell)n2;
NEXT_P2;
}

I_floor:	/* floor ( r1 -- r2 ) */
/* round towards the next smaller integral value, i.e., round toward negative infinity */
NAME("floor")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
/* !! unclear wording */
r2 = floor(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fround:	/* fround ( r1 -- r2 ) */
/* round to the nearest integral value */
NAME("fround")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
/* !! unclear wording */
#ifdef HAVE_RINT
r2 = rint(r1);
#else
r2 = floor(r1+0.5);
/* !! This is not quite true to the rounding rules given in the standard */
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fmax:	/* fmax ( r1 r2 -- r3 ) */
/*  */
NAME("fmax")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
if (r1<r2)
  r3 = r2;
else
  r3 = r1;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_fmin:	/* fmin ( r1 r2 -- r3 ) */
/*  */
NAME("fmin")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
if (r1<r2)
  r3 = r1;
else
  r3 = r2;
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_represent:	/* represent ( r c_addr u -- n f1 f2 ) */
/*  */
NAME("represent")
{
DEF_CA
Float r;
Char * c_addr;
UCell u;
Cell n;
Bool f1;
Bool f2;
NEXT_P0;
r = FTOS;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += -1;
fp += 1;
{
char *sig;
Cell flag;
Cell decpt;
sig=ecvt(r, u, &decpt, &flag);
n=(r==0 ? 1 : decpt);
f1=FLAG(flag!=0);
f2=FLAG(isdigit(sig[0])!=0);
memmove(c_addr,sig,u);
}
NEXT_P1;
sp[2] = (Cell)n;
sp[1] = (Cell)f1;
TOS = (Cell)f2;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_to_float:	/* >float ( c_addr u -- flag ) */
/*  */
NAME(">float")
{
DEF_CA
Char * c_addr;
UCell u;
Bool flag;
NEXT_P0;
c_addr = (Char *) sp[1];
u = (UCell) TOS;
sp += 1;
{
/* real signature: c_addr u -- r t / f */
Float r;
char *number=cstr(c_addr, u, 1);
char *endconv;
while(isspace(number[--u]) && u>0);
switch(number[u])
{
   case 'd':
   case 'D':
   case 'e':
   case 'E':  break;
   default :  u++; break;
}
number[u]='\0';
r=strtod(number,&endconv);
if((flag=FLAG(!(Cell)*endconv)))
{
   IF_FTOS(fp[0] = FTOS);
   fp += -1;
   FTOS = r;
}
else if(*endconv=='d' || *endconv=='D')
{
   *endconv='E';
   r=strtod(number,&endconv);
   if((flag=FLAG(!(Cell)*endconv)))
     {
	IF_FTOS(fp[0] = FTOS);
	fp += -1;
	FTOS = r;
     }
}
}
NEXT_P1;
TOS = (Cell)flag;
NEXT_P2;
}

I_fabs:	/* fabs ( r1 -- r2 ) */
/*  */
NAME("fabs")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = fabs(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_facos:	/* facos ( r1 -- r2 ) */
/*  */
NAME("facos")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = acos(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fasin:	/* fasin ( r1 -- r2 ) */
/*  */
NAME("fasin")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = asin(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fatan:	/* fatan ( r1 -- r2 ) */
/*  */
NAME("fatan")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = atan(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fatan2:	/* fatan2 ( r1 r2 -- r3 ) */
/* @i{r1/r2}=tan@i{r3}. The standard does not require, but probably
intends this to be the inverse of @code{fsincos}. In gforth it is. */
NAME("fatan2")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = fp[1];
r2 = FTOS;
fp += 1;
{
r3 = atan2(r1,r2);
}
NEXT_P1;
FTOS = r3;
NEXT_P2;
}

I_fcos:	/* fcos ( r1 -- r2 ) */
/*  */
NAME("fcos")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = cos(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fexp:	/* fexp ( r1 -- r2 ) */
/*  */
NAME("fexp")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = exp(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fexpm1:	/* fexpm1 ( r1 -- r2 ) */
/* @i{r2}=@i{e}**@i{r1}@minus{}1 */
NAME("fexpm1")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#ifdef HAVE_EXPM1
extern double expm1(double);
r2 = expm1(r1);
#else
r2 = exp(r1)-1.;
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fln:	/* fln ( r1 -- r2 ) */
/*  */
NAME("fln")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = log(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_flnp1:	/* flnp1 ( r1 -- r2 ) */
/* @i{r2}=ln(@i{r1}+1) */
NAME("flnp1")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
#ifdef HAVE_LOG1P
extern double log1p(double);
r2 = log1p(r1);
#else
r2 = log(r1+1.);
#endif
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_flog:	/* flog ( r1 -- r2 ) */
/* the decimal logarithm */
NAME("flog")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = log10(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_falog:	/* falog ( r1 -- r2 ) */
/* @i{r2}=10**@i{r1} */
NAME("falog")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
extern double pow10(double);
r2 = pow10(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fsin:	/* fsin ( r1 -- r2 ) */
/*  */
NAME("fsin")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = sin(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fsincos:	/* fsincos ( r1 -- r2 r3 ) */
/* @i{r2}=sin(@i{r1}), @i{r3}=cos(@i{r1}) */
NAME("fsincos")
{
DEF_CA
Float r1;
Float r2;
Float r3;
NEXT_P0;
r1 = FTOS;
fp += -1;
{
r2 = sin(r1);
r3 = cos(r1);
}
NEXT_P1;
fp[1] = r2;
FTOS = r3;
NEXT_P2;
}

I_fsqrt:	/* fsqrt ( r1 -- r2 ) */
/*  */
NAME("fsqrt")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = sqrt(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_ftan:	/* ftan ( r1 -- r2 ) */
/*  */
NAME("ftan")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = tan(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fsinh:	/* fsinh ( r1 -- r2 ) */
/*  */
NAME("fsinh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = sinh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fcosh:	/* fcosh ( r1 -- r2 ) */
/*  */
NAME("fcosh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = cosh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_ftanh:	/* ftanh ( r1 -- r2 ) */
/*  */
NAME("ftanh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = tanh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fasinh:	/* fasinh ( r1 -- r2 ) */
/*  */
NAME("fasinh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = asinh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_facosh:	/* facosh ( r1 -- r2 ) */
/*  */
NAME("facosh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = acosh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_fatanh:	/* fatanh ( r1 -- r2 ) */
/*  */
NAME("fatanh")
{
DEF_CA
Float r1;
Float r2;
NEXT_P0;
r1 = FTOS;
{
r2 = atanh(r1);
}
NEXT_P1;
FTOS = r2;
NEXT_P2;
}

I_to_body:	/* >body ( xt -- a_addr ) */
/*  */
NAME(">body")
{
DEF_CA
Xt xt;
Cell * a_addr;
NEXT_P0;
xt = (Xt) TOS;
{
a_addr = PFA(xt);
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_to_code_address:	/* >code-address ( xt -- c_addr ) */
/* c_addr is the code address of the word xt */
NAME(">code-address")
{
DEF_CA
Xt xt;
Char * c_addr;
NEXT_P0;
xt = (Xt) TOS;
{
/* !! This behaves installation-dependently for DOES-words */
c_addr = CODE_ADDRESS(xt);
}
NEXT_P1;
TOS = (Cell)c_addr;
NEXT_P2;
}

I_to_does_code:	/* >does-code ( xt -- a_addr ) */
/* If xt ist the execution token of a defining-word-defined word,
a_addr is the start of the Forth code after the DOES>; Otherwise the
behaviour is undefined */
NAME(">does-code")
{
DEF_CA
Xt xt;
Cell * a_addr;
NEXT_P0;
xt = (Xt) TOS;
{
/* !! there is currently no way to determine whether a word is
defining-word-defined */
a_addr = (Cell *)DOES_CODE(xt);
}
NEXT_P1;
TOS = (Cell)a_addr;
NEXT_P2;
}

I_code_address_store:	/* code-address! ( n xt -- ) */
/* Creates a code field with code address c_addr at xt */
NAME("code-address!")
{
DEF_CA
Cell n;
Xt xt;
NEXT_P0;
n = (Cell) sp[1];
xt = (Xt) TOS;
sp += 2;
{
MAKE_CF(xt, symbols[CF(n)]);
CACHE_FLUSH(xt,PFA(0));
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_does_code_store:	/* does-code! ( a_addr xt -- ) */
/* creates a code field at xt for a defining-word-defined word; a_addr
is the start of the Forth code after DOES> */
NAME("does-code!")
{
DEF_CA
Cell * a_addr;
Xt xt;
NEXT_P0;
a_addr = (Cell *) sp[1];
xt = (Xt) TOS;
sp += 2;
{
MAKE_DOES_CF(xt, a_addr);
CACHE_FLUSH(xt,PFA(0));
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_does_jump_store:	/* does-handler! ( a_addr -- ) */
/* creates a DOES>-handler at address a_addr. a_addr usually points
just behind a DOES>. */
NAME("does-handler!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
MAKE_DOES_HANDLER(a_addr);
CACHE_FLUSH(a_addr,DOES_HANDLER_SIZE);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_slash_does_handler:	/* /does-handler ( -- n ) */
/* the size of a does-handler (includes possible padding) */
NAME("/does-handler")
{
DEF_CA
Cell n;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
/* !! a constant or environmental query might be better */
n = DOES_HANDLER_SIZE;
}
NEXT_P1;
TOS = (Cell)n;
NEXT_P2;
}

I_toupper:	/* toupper ( c1 -- c2 ) */
/*  */
NAME("toupper")
{
DEF_CA
Char c1;
Char c2;
NEXT_P0;
c1 = (Char) TOS;
{
c2 = toupper(c1);
}
NEXT_P1;
TOS = (Cell)c2;
NEXT_P2;
}

I_fetch_local_number:	/* @local# ( -- w ) */
/*  */
NAME("@local#")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *(Cell *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_zero:	/* @local0 ( -- w ) */
/*  */
NAME("@local0")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *(Cell *)(lp+0*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_four:	/* @local1 ( -- w ) */
/*  */
NAME("@local1")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *(Cell *)(lp+1*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_eight:	/* @local2 ( -- w ) */
/*  */
NAME("@local2")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *(Cell *)(lp+2*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_fetch_local_twelve:	/* @local3 ( -- w ) */
/*  */
NAME("@local3")
{
DEF_CA
Cell w;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
w = *(Cell *)(lp+3*sizeof(Cell));
}
NEXT_P1;
TOS = (Cell)w;
NEXT_P2;
}

I_f_fetch_local_number:	/* f@local# ( -- r ) */
/*  */
NAME("f@local#")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
r = *(Float *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

I_f_fetch_local_zero:	/* f@local0 ( -- r ) */
/*  */
NAME("f@local0")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
r = *(Float *)(lp+0*sizeof(Float));
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

I_f_fetch_local_eight:	/* f@local1 ( -- r ) */
/*  */
NAME("f@local1")
{
DEF_CA
Float r;
NEXT_P0;
IF_FTOS(fp[0] = FTOS);
fp += -1;
{
r = *(Float *)(lp+1*sizeof(Float));
}
NEXT_P1;
FTOS = r;
NEXT_P2;
}

I_laddr_number:	/* laddr# ( -- c_addr ) */
/*  */
NAME("laddr#")
{
DEF_CA
Char * c_addr;
NEXT_P0;
IF_TOS(sp[0] = TOS);
sp += -1;
{
/* this can also be used to implement lp@ */
c_addr = (Char *)(lp+(Cell)NEXT_INST);
INC_IP(1);
}
NEXT_P1;
TOS = (Cell)c_addr;
NEXT_P2;
}

I_lp_plus_store_number:	/* lp+!# ( -- ) */
/* used with negative immediate values it allocates memory on the
local stack, a positive immediate argument drops memory from the local
stack */
NAME("lp+!#")
{
DEF_CA
NEXT_P0;
{
lp += (Cell)NEXT_INST;
INC_IP(1);
}
NEXT_P1;
NEXT_P2;
}

I_minus_four_lp_plus_store:	/* lp- ( -- ) */
/*  */
NAME("lp-")
{
DEF_CA
NEXT_P0;
{
lp += -sizeof(Cell);
}
NEXT_P1;
NEXT_P2;
}

I_eight_lp_plus_store:	/* lp+ ( -- ) */
/*  */
NAME("lp+")
{
DEF_CA
NEXT_P0;
{
lp += sizeof(Float);
}
NEXT_P1;
NEXT_P2;
}

I_sixteen_lp_plus_store:	/* lp+2 ( -- ) */
/*  */
NAME("lp+2")
{
DEF_CA
NEXT_P0;
{
lp += 2*sizeof(Float);
}
NEXT_P1;
NEXT_P2;
}

I_lp_store:	/* lp! ( c_addr -- ) */
/*  */
NAME("lp!")
{
DEF_CA
Char * c_addr;
NEXT_P0;
c_addr = (Char *) TOS;
sp += 1;
{
lp = (Address)c_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_to_l:	/* >l ( w -- ) */
/*  */
NAME(">l")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
lp -= sizeof(Cell);
*(Cell *)lp = w;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_f_to_l:	/* f>l ( r -- ) */
/*  */
NAME("f>l")
{
DEF_CA
Float r;
NEXT_P0;
r = FTOS;
fp += 1;
{
lp -= sizeof(Float);
*(Float *)lp = r;
}
NEXT_P1;
IF_FTOS(FTOS = fp[0]);
NEXT_P2;
}

I_up_store:	/* up! ( a_addr -- ) */
/*  */
NAME("up!")
{
DEF_CA
Cell * a_addr;
NEXT_P0;
a_addr = (Cell *) TOS;
sp += 1;
{
up0=up=(char *)a_addr;
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_call_c:	/* call-c ( w -- ) */
/* Call the C function pointed to by @i{w}. The C function has to
access the stack itself. The stack pointers are exported in the gloabl
variables @code{SP} and @code{FP}. */
NAME("call-c")
{
DEF_CA
Cell w;
NEXT_P0;
w = (Cell) TOS;
sp += 1;
{
/* This is a first attempt at support for calls to C. This may change in
   the future */
IF_FTOS(fp[0]=FTOS);
FP=fp;
SP=sp;
((void (*)())w)();
sp=SP;
fp=FP;
IF_TOS(TOS=sp[0]);
IF_FTOS(FTOS=fp[0]);
}
NEXT_P1;
IF_TOS(TOS = sp[0]);
NEXT_P2;
}

I_strerror:	/* strerror ( n -- c_addr u ) */
/*  */
NAME("strerror")
{
DEF_CA
Cell n;
Char * c_addr;
UCell u;
NEXT_P0;
n = (Cell) TOS;
sp += -1;
{
c_addr = strerror(n);
u = strlen(c_addr);
}
NEXT_P1;
sp[1] = (Cell)c_addr;
TOS = (Cell)u;
NEXT_P2;
}

