\ *
\ * forth2c.fs
\ *	This file contains the interface to the Forth to C converter.
\ *	This is the file to be loaded with gforth.
\ *
\ *	(C) Martin Maierhofer 1994
\ *	m.maierhofer@ieee.org
\ *

false  constant _C_debug 	( set to true to enable debugging msgs )
variable 	_C_oldFileId	( contains the FileId when forth2c is )
				( disabled )

require search-order.fs		\ need wordlist etc.
require _c_funcs.fs		\ the converter words
			 
\ enable the converter; if _C_oldFileId is not zero, it contains the
\ original file id; otherwise, we have to re-initialize the package
\ via _C_init
: forth2c-enable	( -- )
	_C_fileId @
	0= if
		_C_oldFileId @ dup 
		0= if
			_C_init
			drop
		else
			_C_fileId !
			0 _C_oldFileId !
		then
	then
;
								       
\ disable the converter; save the file-id to our private variable
\ and set it to 0, disabling the converter words.
: forth2c-disable	( -- )
	_C_fileId dup @ dup 0= if 2drop exit then
	_C_oldFileId !
	0 swap !
;
		
\ forth2c-newfile is used to specify a new name for the C file
\ note that either _C_fileId is zero (forth2c temporarily disabled),
\ _C_oldFileId is zero (forth2c enabled) or both of them are
\ zero (no file currently is open), so we can use or the get the
\ fileid.
: forth2c-newfile	( c-addr u -- flag )
	_C_fileName 2!		\ save the file name
	
	_C_fileId @ _C_oldFileId @ 	( n n )
	or dup
	0= if			\ no file is currently open
		drop true 
		exit
	then
				\ close the old file and try to
	close-file if
		cr ." forth2c: Could not close the C output file."
		." Disabling the converter." cr
		0 dup _C_fileId ! _C_oldFileId !
		false
		exit
	then
	
	_C_init			\ opens the new one, stores the new
				\ file id to _C_fileId in any case !
			     
	_C_fileId @		\ will be returned as the 'flag'
	
	_C_oldFileId @ if	\ move the fileid to _C_oldFileId
		_C_fileId @ _C_oldFileId !
		0 _C_fileId !
	then
	
	exit
;

wordlist _C_wordlist !		\ create our wordlist once and for all
0 _C_oldFileId !		\ initialize the old file id
forth2c-enable			\ and try to enable the converter

