\ auxiliar functions
\ (c) by Gerald Wodni 2008

: cs clearstack ;
: freet free throw ;

: 2pi pi 2.e0 f* ;

: n>u ( n -- u )
	dup 0< if -1 else 0 then ;	\ only check the sign and add a cell containing it onto the stack

: u>n ( u -- n )
	drop ;

: n>f ( n -- r )
	n>u d>f ;

: f>n ( r -- n )
	f>d u>n ;

: square dup * ;
: sqrt n>f fsqrt f>n ;

: fmean-2 ( r1 r2 -- r-mean )
	f+ 2.e0 f/ ;

: fsquare fdup f* ;

: -tuck	over swap ;

: -frot frot frot ;
: 2fdup fover fover ;
: 2fdrop fdrop fdrop ;

: third 2 pick ;
: fourth 3 pick ;
: sixth 5 pick ;
: 3drop drop drop drop ;
: 3dup third third third ;
: 3over sixth sixth sixth ;
: 3swap { n1 n2 n3 n4 n5 n6 -- n4 n5 n6 n1 n2 n3 }	\ this seems close to impossible without locals!
	n4 n5 n6 n1 n2 n3 ;
: 3nip 3swap 3drop ;

: 6drop 3drop 3drop ;
: 6dup 3over 3over ;

: fthird 2 fpick ;
: ffourth 3 fpick ;
: 3fdup fthird fthird fthird ;

: nbind ( n-value n-min n-max -- n-[min, max] )		\ binds a value to an interval
	rot min max ;

: fbind ( r-value r-min r-max -- r-[min, max] )		\ binds a value to an interval
	frot fmin fmax ;

: fpbind ( a r-min r-max -- ) 				\ like fbind but uses a pointer
	dup f@ fmin fmax f! ;
	
: deg-to-rad
	18.e1 f/ pi f* ;

: vector-length-2r ( r-x r-y -- r-length )
	fsquare fswap fsquare f+ fsqrt ;

: vector-length-3r ( r-x r-y -- r-length )
	fsquare fswap fsquare f+ fswap fsquare f+ fsqrt ;

: vector-normalize-2r ( r-x r-y -- r-nx r2-ny )		\ set vector's length to 1
	2fdup vector-length-2r ftuck f/ -frot f/ fswap ;

: vector-normalize-3r ( r-x r-y r-z -- r-nx r-ny t-nz )
	;	

: vector-add-2n ( n-vertex-x n-vertex-y n-offset-x n-offset-y -- n-vertex-x n-vertex-y )
	rot + -rot + swap ;

: vector-add-3n ( n-vx n-vy n-vz n-ox n-oy n-oz -- n-vx n-vy n-vz )
	>r rot r> + >r	\ add z-components and store them on r
	vector-add-2n	\ perform normal 2 component add
	r>		\ get z component
	;
	
: terminate-string ( a n -- a )		\ replaces the last character of a string with \0
	over + 1- 0 swap c! ; 

: digitify ( n -- n1 n2 ... nN  n# )
	0 swap					\ store number of digits
	begin
		dup 10 mod tuck - 10 / 		\ calulate last digit and get new remainder
		rot 1+ swap			\ increment number of digits
		dup 0=				\ check if there is a remainder
	until
	drop					\ delete last zero
;

: get-variable-by-name ( addr n -- addr-variable )
	forth-wordlist search-wordlist 0= if
		0	\ if nothing was found, return blank
	then ;

: 1.+ 1.e0 f+ ;
: 1.- 1.e0 f- ;

: f@neg	( addr -- r )
	f@ fnegate ;

: sign 0< if -1 else 1 then ;

