\ (c) copyright 2011 by Gerald Wodni

\ include c-definitions
require random.fs
require ../sdl.fs
require ../glsimple.fs

\ configuration
1024	constant  window-width
768	constant  window-height
45.e0	fconstant window-fovy
1.e-1	fconstant window-clipping-near
3.e2	fconstant window-clipping-far
1.e-2	fconstant player-movement-basic-speed
1.e-1	fconstant player-rotation-speed

\ globals
512	constant  selection-buffer-size
selection-buffer-size allocate throw constant selection-buffer

4 allocate throw constant viewport

variable mouse-x		\ n
variable mouse-y		\ n
variable mouse-buttons		\ n
variable keystate		\ a
variable old-keystate		\ a
variable num-keys		\ n
variable seeder
variable num-selected		\ n
fvariable pos-x			\ r
fvariable pos-z			\ r
fvariable rot-y			\ r
0 num-keys !

0.e0 pos-x f!
0.e0 pos-z f!
0.e0 rot-y f!

: n>u ( n -- u )
	dup 0< if -1 else 0 then ;	\ only check the sign and add a cell containing it onto the stack

: u>n ( u -- n )
	drop ;

: n>f ( n -- r )
	n>u d>f ;

: f>n ( r -- n )
	f>d u>n ;

: error-end ( f addr n -- )
	rot if
		type
		cr
		bye
	else
		2drop
	then ;

: terminate-string ( a n -- a )		\ replaces the last character of a string with \0
	over + 1- 0 swap c! ; 

: init ( -- )				\ create window and opengl-context
	s" SDL" add-lib
	s" GL"  add-lib
	s" GLU" add-lib

	512 chars allocate throw old-keystate !

	SDL_INIT_VIDEO sdl-init						\ start sdl		
	0<> s" Unable to initialize SDL" error-end

	SDL_OPENGL
	window-width window-height rot 8 swap sdl-set-video-mode	\ create window
	0< s" Unable to set video mode" error-end

	GL_DEPTH_TEST gl-enable						\ setup depth-test
	GL_LEQUAL gl-depth-func

	GL_NORMALIZE gl-enable						\ make gl calculate the normals

	s" Picking example0" terminate-string NULL sdl-wm-set-caption 

	3.e0 gl-line-width
;

: is-keydown ( n-key -- flag )
	keystate @ + c@ ;	\ get pointer address, add array index and return this value

: human-input
	\ save current keystate to old-keystate
	keystate @ old-keystate @ num-keys @ move

	sdl-pump-events							\ as we can't handle with structs, leave that to SDL
	num-keys sdl-get-key-state keystate !				\ get current keystates
	mouse-x mouse-y sdl-get-mouse-state mouse-buttons !		\ get current mouseposition and buttons

	'a is-keydown if pos-x dup f@ 5.e-3 f+ f!  then
	'd is-keydown if pos-x dup f@ 5.e-3 f- f!  then
	'w is-keydown if pos-z dup f@ 5.e-3 f+ f!  then
	's is-keydown if pos-z dup f@ 5.e-3 f- f!  then
	'q is-keydown if rot-y dup f@ 5.e-2 f+ f!  then
	'e is-keydown if rot-y dup f@ 5.e-2 f- f!  then
	;

: clear-buffers
	0.e0 3.e-1 0.e0 1.e0 gl-clear-color
	GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT or gl-clear		\ clear depth & color buffer
	;

: perspective
	0 0 window-width window-height gl-viewport			\ only one fullscreen viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	window-fovy							\ field of view
	window-width n>f window-height n>f f/				\ aspect ratio
	window-clipping-near window-clipping-far			\ clipping ( range )
	glu-perspective							\ set up perspective projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix

: start-picking ( -- )
	0 0 window-width window-height gl-viewport			\ only one fullscreen viewport
	GL_VIEWPORT viewport gl-get-nv
	selection-buffer-size selection-buffer gl-select-buffer
	GL_SELECT gl-render-mode drop
	gl-init-names

	0 0 window-width window-height gl-viewport			\ only one fullscreen viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix

	\ mouse-x n>f mouse-y n>f 5.e2 5.e2 viewport glu-pick-matrix	\ assemble a pick-matrix
	mouse-x @ n>f window-height mouse-y @ - n>f 1.e0 1.e0 viewport glu-pick-matrix	\ assemble a pick-matrix
	\ window-width 2/ n>f window-height 2/ n>f 10.e1 10.e1 viewport glu-pick-matrix	\ assemble a pick-matrix
	
	window-fovy							\ field of view
	window-width n>f window-height n>f f/				\ aspect ratio
	window-clipping-near window-clipping-far			\ clipping ( range )
	glu-perspective							\ set up perspective projection matrix

	GL_MODELVIEW gl-matrix-mode			\ reset modelview matrix
	gl-load-identity
	;

: stop-picking ( -- n )
	gl-flush
	GL_RENDER gl-render-mode dup num-selected ! ;

: quad  ( -- )
	gl-quads 
		 1  1 0 gl-vertex-3n
		-1  1 0 gl-vertex-3n
		-1 -1 0 gl-vertex-3n
		 1 -1 0 gl-vertex-3n
	gl-end ;

: rect  ( -- )
	gl-line-loop
		1.e0 1.e0 1.e0 gl-color-3r
		 1  1 0 gl-vertex-3n
		-1  1 0 gl-vertex-3n
		-1 -1 0 gl-vertex-3n
		 1 -1 0 gl-vertex-3n
	gl-end ;

: is-selected ( n -- f )
	{ n }
	0
	selection-buffer 3 cells +
	num-selected @ 0 u+do
		dup @ n = if
			nip 1 swap
			\ leave
		then
		4 cells +
	loop drop ;

: draw
	0.e0 -5.e-1 -5.e0 gl-translate
	42 gl-push-name
	1.e0 1.e0 0.e0 gl-color-3r
	quad
	gl-pop-name

	42 is-selected if rect then

	43 gl-push-name
	3.e0 0.e0 -4.e0 gl-translate
	1.e0 0.e0 0.e0 gl-color-3r
	quad
	gl-pop-name

	43 is-selected if rect then

	41 gl-push-name
	-4.e0 1.e0 5.e0 gl-translate
	45.e0 0.e0 0.e0 1.e0 gl-rotate
	50.e0 1.e0 0.e0 0.e0 gl-rotate
	0.e0 3.e-1 1.e0 gl-color-3r
	quad
	gl-pop-name

	41 is-selected if rect then
	;

: playerpos
	pos-x f@ 0.e0 pos-z f@ gl-translate
	rot-y f@ 0.e0 1.e0 0.e0 gl-rotate
	;
	
: render
	clear-buffers

	selection-buffer selection-buffer-size erase

	\ select
	start-picking
	playerpos
	draw
	stop-picking ." selected: " u. ." :"
	
	selection-buffer
	32 0 do
		dup @ u.
		cell+
	loop drop
		
	seeder random u. cr

	1 if	\ draw
		clear-buffers
		perspective
		playerpos
		
		draw

		gl-flush						\ just flush & swap
	then
	sdl-gl-swap-buffers
	;

: main ( -- )
	init	\ create window and opengl-context

	begin
		human-input
		render
		27 is-keydown
	until
;

main
bye

