\ GL scene setup and handling
\ (c) by Gerald Wodni 2008-2009

\ static calulated values ( do not change unless you're sure )
window-width 2 /	constant window-half-width
window-height 2 /	constant window-half-height

4 allocate throw constant scene-viewport-nv

: window-center ( -- n n )
	window-half-width window-half-height ;

: error-end ( f addr n -- )
	rot if
		type
		cr
		bye
	else
		2drop
	then ;


: scene-init ( -- )
	SDL_INIT_VIDEO sdl-init								\ start sdl		
	0<> s" Unable to initialize SDL" error-end

	\ SDL_GL_MULTISAMPLEBUFFERS cell allocate throw sdl-gl-get-attribute . ." samples"

	gl-multisamples if								\ multisamples
		SDL_GL_MULTISAMPLEBUFFERS 1 sdl-gl-set-attribute 0=
		SDL_GL_MULTISAMPLESAMPLES gl-multisamples sdl-gl-set-attribute 0=
		and 0 s" Unable to initialize Multisamples, please set gl-multisamples to 0" error-end
	then
	
	window-fullscreen if SDL_FULLSCREEN else 0 then					\ fullscreen
	SDL_OPENGL or
	window-width window-height rot 8 swap sdl-set-video-mode			\ create window
	0< s" Unable to set video mode" error-end

	GL_DEPTH_TEST gl-enable								\ setup depth-test
	GL_LEQUAL gl-depth-func

	GL_NORMALIZE gl-enable								\ make gl calculate the normals
	
	\ window-half-width window-half-height sdl-warp-mouse drop			\ set mouse to center of window

	light-init

	s" GLforth0" terminate-string NULL sdl-wm-set-caption 

	cube-number if 
		." You are displaying " cube-number dup dup * * dup . 6 * dup
		." cubes, that makes a total of " . ." quads"
		10000 > if ." ( glforth rocks )" then
		cr
	then ;

: scene-begin ( -- )
	\ 0.e0 5.e-1 0.e0 1.e0 gl-clear-color
	0.e0 0.e0 0.e0 1.e0 gl-clear-color
	GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT or gl-clear		\ clear depth & color buffer
	0 0 window-width window-height gl-viewport			\ only one fullscreen viewport
	pick-buffer pick-buffer-size erase ;				\ clear pick buffer

: scene-finalize ( -- )
	gl-flush							\ just flush & swap
	sdl-gl-swap-buffers
	;

: scene-viewport ( -- )
	0 0 window-width window-height gl-viewport ;

: scene-player-view ( -- )
	\ normal camera in player mode
	player-tilt f@ 1.e0 0.e0 0.e0 gl-rotate
	player-pan f@ 0.e0 1.e0 0.e0 gl-rotate
	player-x f@ player-y f@ player-z f@ gl-translate ;

: scene-setup-perspective
	window-fovy							\ field of view
	window-width n>f window-height n>f f/				\ aspect ratio
	window-clipping-near window-clipping-far			\ clipping ( range )
	glu-perspective							\ set up perspective projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity			\ reset modelview matrix
	scene-player-view ;						\ offset to player view

: scene-perspective ( -- )
	scene-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix

	scene-setup-perspective ;

: scene-start-picking ( -- )
	scene-viewport							\ set default viewport 
	GL_VIEWPORT scene-viewport-nv gl-get-nv				\ get its settings in -nv
	pick-buffer-size pick-buffer gl-select-buffer			\ bind buffer
	GL_SELECT gl-render-mode drop					\ render to selection buffer
	gl-init-names

	scene-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix

	\ set pick-matrix to pick coordinates, and make it only 1x1 px wide
	\ pick-x f@ window-height n>f pick-y f@ f- 1.e2 1.e2 scene-viewport-nv glu-pick-matrix
	\ pick-x f@ pick-y f@ window-width n>f window-height n>f scene-viewport-nv glu-pick-matrix
	pick-x f@ pick-y f@ 1.e0 1.e0 scene-viewport-nv glu-pick-matrix
	
	scene-setup-perspective ;

: scene-stop-picking ( -- )
	gl-flush
	GL_RENDER gl-render-mode num-picked !
	;

: scene-ortho ( -- )
	0 0 window-width window-height gl-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	0.e0 window-width n>f 0.e0 window-height n>f glu-ortho		\ set up orthogonal projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix

: player-movement-speed ( -- r-speed )
	player-movement-basic-speed player-movement-factor f@ f* fps @ n>f f/ 1.e3 f* ;

: player-movement-vectors ( -- r-x r-z )
	player-movement-speed player-pan f@
		\ fdup f. ." , z: "		\ debug
	deg-to-rad 2fdup
	fcos f* -frot
	fsin f* -1.e0 f*
		\ 2fdup f.
		\ ." x: " f. 			\ debug
		\ cr	 			\ debug
	
	;

: player-change-position player-x f@ f+ player-x f! player-z f@ f+ player-z f! ; ( x z -- )

