\ selectable model base-class
\ (c) by Gerald Wodni 2009

array heap-new constant selectable-model-array

\ model class is the basic class for all music-based models
\ and handles all instantiated models
model class
	cell%	inst-var selected

	m:
		\ 0 selected !
		this [parent] construct
		this selectable-model-array add
 	;m
	overrides construct

	\ selection methods
	m:	this stacked-draw ;m
	method stacked-selection-draw

	m:	gl-push-matrix
			this gl-push-name
				position @ 3fv> gl-translate
				this stacked-selection-draw
			gl-pop-name
		gl-pop-matrix
	;m
	method selection-draw

	m:	selected !  ;m
	method set-selected

end-class selectable-model

\ calls the selected model's set-selected
: notify-selected ( -- )
	pick-buffer 3 cells +
	num-picked @ 0 u+do
		true over @ set-selected 
		4 cells +
	loop drop
	;

\ clear the selected flag on each model
: unselect-model ( item -- )
	false swap set-selected ;

: unselect-models ( -- )
	['] unselect-model selectable-model-array map ;

