\ music model interface
\ (c) by Gerald Wodni 2008

require array.fs

array heap-new constant model-array

\ model class is the basic class for all music-based models
\ and handles all instantiated models
object class
	cell% inst-var position
	cell% inst-var scale
	cell% inst-var color

	m:	this model-array add
		0.e0 0.e0 0.e0 create-3fv position !
		1.e0 1.e0 1.e0 create-3fv scale !
		5.e-1 0.e0 1.e0 create-3fv color !
 	;m
	overrides construct
	
	m: this model-array remove ;m
	method destruct

	m:	position @ >3fv ;m
	method set-position

	m:	scale @ >3fv ;m
	method set-scale

	m:	color @ >3fv ;m
	method set-col

	m: ;m
	method beat

	m: ;m
	method animate ( r1 -- r1 )

	\ drawing methods
	m: ." model-stacked-draw" cr ;m
	method stacked-draw

	m:	gl-push-matrix
		position @ 3fv> gl-translate
		scale @ 3fv> gl-scale
		this stacked-draw
		gl-pop-matrix
	;m
	method draw
	
	m: ." model-here" cr ;m
	overrides print

end-class model

model class

	m: this [parent] construct ;m
	overrides construct

	m: ." blueroom-here" cr ;m
	overrides print

	m: ." blueroom-draw" cr ;m
	overrides draw

end-class blueroom

\ TODO: create models/models.fs ( like the old models.fs ?)
require starfield.fs 
require house.fs
require vent.fs

require selectable-model.fs
require button.fs


\ house heap-new drop

\ model heap-new constant model-inst
\ blueroom heap-new constant blueroom-inst

: models-destruct  ( -- )
	begin
		model-array get-length 0>
	while
		0 model-array item-index destruct
	repeat
	;

