\ House Music Model
\ (c) by Gerald Wodni 2008

 3 constant house-min-stories
10 constant house-max-stories

: sidewalk-draw ( n-x-size -- )
	1+ 0 u+do
		i 2 mod 0= if
			2.e-1 2.e-1 2.e-1 gl-color-3r
		else
			1.e-1 1.e-1 1.e-1 gl-color-3r
		then
		\ front
		i 0= if
			-1  0 0 gl-vertex-3n
			-1  0 1 gl-vertex-3n
			-1 -1 1 gl-vertex-3n
			-1 -1 0 gl-vertex-3n	
		then
		\ top
		i 1- 0 0 gl-vertex-3n
		i    0 0 gl-vertex-3n
		i    0 1 gl-vertex-3n
		i 1- 0 1 gl-vertex-3n
		\ side
		i 1- -1 1 gl-vertex-3n
		i    -1 1 gl-vertex-3n
		i     0 1 gl-vertex-3n
		i 1-  0 1 gl-vertex-3n
	loop ;

: window-story-draw ( n-x-size -- )
	0 u+do
		i 2 mod 0= if
			3.e-1 3.e-1 3.e-1 gl-color-3r
		else
			1.e0 1.e0 0.e0 gl-color-3r
		then
		i	1 0 gl-vertex-3n
		i 1+	1 0 gl-vertex-3n
		i 1+	2 0 gl-vertex-3n
		i	2 0 gl-vertex-3n
	loop ;

\ old version of blank-story (only one quad)
: blank-story-draw ( n-x-size -- )
	0   0 0 gl-vertex-3n
	dup 0 0 gl-vertex-3n
	    1 0 gl-vertex-3n
	0   1 0 gl-vertex-3n ;

: blank-story-draw ( n-x-size -- )
	0 u+do
		i	0 0 gl-vertex-3n
		i 1+	0 0 gl-vertex-3n
		i 1+	1 0 gl-vertex-3n
		i	1 0 gl-vertex-3n
	loop ;

: story-draw ( n-x-size -- )
	dup window-story-draw
	blank-story-draw
	;

: stories-draw ( n-x-size n-y-size -- )
	gl-quads
		over sidewalk-draw
	gl-end
	dup 4 + n>f \ store for backtranslation
	0 u+do
		gl-quads
			dup story-draw
		gl-end
		0.e 2.e 0.e gl-translate
	loop 
	gl-quads
		blank-story-draw \ roof
	gl-end
	0.e fswap fnegate 0.e gl-translate ;

model class
	cell% inst-var stories
	cell% inst-var size

	m:	this [parent] construct
		house-max-stories random dup house-min-stories < if drop house-min-stories then stories !
		7 size !
	;m
	overrides construct

	m:	;m
	overrides animate

	m:	gl-push-matrix
		position @ 3fv> gl-translate

		\ front & back wall
		4 0 u+do
			9.e1 gl-rotate-y
			gl-push-matrix
			size @ n>f -2.e f/ 0.e0 fover fnegate gl-translate
			size @ stories @ stories-draw
			gl-pop-matrix
		loop

		\ side walls
		( gl-pop-matrix
		90.e gl-rotate-y
		size @ n>f -2.e f/ 0.e0 fover fnegate gl-translate
		size @ stories @ stories-draw
		0.e 0.e size @ negate n>f gl-translate
		size @ stories @ stories-draw )

		\ roof
		size @ n>f -2.e f/ 0.e0 fover gl-translate
		size @ n>f 1.e fover gl-scale
		5.e-1 5.e-1 5.e-1 gl-color-3r
		gl-quads
			stories @ 2 * 1+
			0 over  1 gl-vertex-3n
			1 over  1 gl-vertex-3n
			1 over  0 gl-vertex-3n
			0 swap 0 gl-vertex-3n
		gl-end

		gl-pop-matrix ;m
	overrides draw

end-class house

