\ glsimple - simplify the OpenGL interface ( forth it )
\ (c) by Gerald Wodni 2008

\ require libraries/gl.fs
require gl.fs

: gl-lines		GL_LINES 	gl-begin ;
: gl-line-loop		GL_LINE_LOOP	gl-begin ;
: gl-line-strip		GL_LINE_STRIP	gl-begin ;
: gl-quads		GL_QUADS	gl-begin ;
: gl-quad-strip		GL_QUAD_STRIP	gl-begin ;
: gl-triangles		GL_TRIANGLES	gl-begin ;
: gl-triangle-fan	GL_TRIANGLE_FAN	gl-begin ;

\ : gl-rotate		 POSTPONE gl-rotated 	; immediate
: gl-rotate-x		1.e0 0.e0 0.e0	gl-rotate ;
: gl-rotate-y		0.e0 1.e0 0.e0	gl-rotate ;
: gl-rotate-z		0.e0 0.e0 1.e0	gl-rotate ;

(
: gl-light-f		 POSTPONE gl-lightf	; immediate
: gl-light-n		 POSTPONE gl-lighti	; immediate
: gl-light-fv		 POSTPONE gl-lightfv	; immediate
: gl-light-nv		 POSTPONE gl-lightiv	; immediate

: gl-vertex-2n		 POSTPONE gl-vertex-2-i	; immediate
: gl-vertex-2r		 POSTPONE gl-vertex-2-d	; immediate

: gl-vertex-3n		 POSTPONE gl-vertex-3-i	; immediate
: gl-vertex-3r		 POSTPONE gl-vertex-3-d	; immediate

: gl-vertex-2nv		 POSTPONE gl-vertex-2-iv	; immediate
: gl-vertex-2fv		 POSTPONE gl-vertex-2-fv	; immediate

: gl-vertex-3nv		 POSTPONE gl-vertex-3-iv	; immediate
: gl-vertex-3fv		 POSTPONE gl-vertex-3-fv	; immediate

: gl-color-3r		 POSTPONE gl-color-3-d	; immediate
: gl-color-4r		 POSTPONE gl-color-4-d	; immediate

: gl-normal		 POSTPONE gl-normal-3-d	; immediate

: gl-scale		 POSTPONE gl-scaled	; immediate
: gl-translate		 POSTPONE gl-translated	; immediate

: glu-ortho		 POSTPONE glu-ortho-2-d	; immediate
)

: print-matrix-4x4-nv ( addr -- )
	16 0 u+do
		i 4 mod 0= if cr then
		i cells over + @ dec. 9 emit
	loop drop
	;

: gl-get-modelview-translation-n ( -- n-x n-y n-z ) 
	here GL_MODELVIEW_MATRIX over
	16 allot \ allocate for buffer
	gl-get-nv

	12 cells + >r r@ @	\ fetch translations
	r@ cell+ @
	r> 2 cells + @

	-16 allot
	; 

