\ Startup game selector
\ (c) by Gerald Wodni 2011

100 constant gamelist-margin
50 constant gamelist-padding

gameclass class
	cell% inst-var		game-index		\ n
	cell% 2* inst-var	cursor-x
	cell% 2* inst-var	cursor-y
	cell% inst-var		mouse-clicked		\ flag
	cell% inst-var		last-mouse-buttons	\ n

	m:	( -- ) \ init
		this [parent] init
		s" Selector0" terminate-string game-name !
		s" selector" game-forth-name 2!

		window-half-width cursor-x !
		window-half-height cursor-y !
		0 last-mouse-buttons !

		starfield heap-new
		0.e 0.e -1.e2 set-position

		;m
	overrides init

	m:	( x y w h -- flag )
			rot	( w h y )
			dup -rot + ( y h+y )
			\ cursor-y sf@ f>n ~~ < swap cursor-y @ > and -rot
			cursor-y @ dup -rot > -rot < and >r
			over + ( x w+x )
			cursor-x @ dup -rot > -rot < and
			r> and
		;m
	method check-inside


	m:	( n-height -- )
		dup
		window-width gamelist-margin 2* - >r	\ width
		>r gl-get-modelview-translation-n drop	\ get translation, drop z
		r> r@ swap				\ w and h
		this check-inside { inside } inside if
			mouse-clicked @ if
				." clicked" cr
				>r >r >r
				dup set-active-game
				r> r> r>
			then
			5.e-1 5.e-1 1.e0 3.e-1 gl-color-4r
		else
			0.e-1 2.e-1 6.e-1 3.e-1 gl-color-4r
		then
		gl-quads
			0 0 gl-vertex-2n
			0 over gl-vertex-2n
			r@ over gl-vertex-2n
			r@ 0 gl-vertex-2n
		gl-end
		inside if
			7.e-1 7.e-1 1.e0 gl-color-3r
		else
			4.e-1 4.e-1 1.e0 gl-color-3r
		then
		gl-line-loop
			0 0 gl-vertex-2n
			0 over gl-vertex-2n
			r@ over gl-vertex-2n
			r@ 0 gl-vertex-2n
		gl-end
		gl-push-matrix
			r> 2/ n>f 2/ n>f 0.e0 gl-translate
			30.e0 fdup fdup gl-scale
			font-both-centered-string
		gl-pop-matrix
		;m
	method draw-gamelist-item

	m:	( n-item-count -- )
		gamelist-margin n>f gamelist-margin n>f 0.e0 gl-translate
		window-height gamelist-margin 2* -	\ remaining space without margin
		over 1- gamelist-padding * -		\ space per item without padding
		over /
		swap
 		0 u+do
			dup dup gamelist-padding + i 0> 1 and *
			0.e0 n>f 0.e0 gl-translate
			i game-array item-index dup this <> if
				swap >r dup get-forth-name r> this draw-gamelist-item
				drop
			else
				drop
			then
		loop drop
		;m
	method draw-gamelist

	m:	( -- ) \ crosshairs
		cursor-x @ n>f cursor-y @ n>f 0.e0 gl-translate
		mouse-buttons @ 1 and if 2.e0 fdup fdup gl-scale then

		1.e0 gl-line-width

		4 0 u+do

			mouse-buttons @ 0= if
				45.e0 0.e0 0.e0 1.e0 gl-rotate
			then

			1.e0 0.e0 0.e0 5.e-1 gl-color-4r
			gl-triangles
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end

			mouse-buttons @ 0= if
				-45.e0 0.e0 0.e0 1.e0 gl-rotate
			then
			
			1.e0 1.e0 1.e0 gl-color-3r
			gl-line-loop
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end
			90.e0 0.e0 0.e0 1.e0 gl-rotate
		loop
		;m
	method crosshairs

	m: 	( -- ) \ draw-2d
		GL_BLEND gl-enable
		GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA gl-blend-func

		gl-load-identity
		375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset

		1.e0 gl-line-width
		1.e0 1.e0 1.e0 gl-color-3r

		game-array get-length 1- this draw-gamelist

		gl-load-identity

		this crosshairs

		;m
	overrides draw-2d

	m: 	( -- ) \ draw-3d
		1.e0 fdup fdup fdup gl-color-4r
		1.e1 0.e0 -1.e1 gl-translate
		['] draw model-array map
		-1.e1 0.e0 1.e1 gl-translate
	;m
	overrides draw-3d

	m:	( -- ) \ update-navigation
		mouse-x @ window-half-width - cursor-x @ + 0 window-width nbind cursor-x !
		window-half-height mouse-y @ - cursor-y @ + 0 window-height nbind cursor-y !

		mouse-buttons @ 1 and 0= last-mouse-buttons @ 1 and and mouse-clicked !
		mouse-buttons @ last-mouse-buttons !
	;m
	overrides update-navigation

	m:
		1 exit-glforth !
	;m
	overrides escape-hit

end-class selector

selector heap-new set-active-game

