\ The very first and original GLforth game ( The Tron-Shooter )
\ (c) by Gerald Wodni 2008-2009

variable kills			\ n

fvariable text-offset		\ r
variable text-display		\ n
variable text-lock		\ n

variable flashlight-on		\ n
variable flashlight-lock	\ n

variable mouse-shot-lock	\ n
variable enemies-on		\ n

require oof.fs
require enemies.fs
require rockets.fs
require weapon.fs

gameclass class

	m:	this [parent] construct
		s" GLforth0" terminate-string game-name !
		s" glforth" game-forth-name 2!
		;m
	overrides construct

	m:	( -- ) \ init
		this [parent] init

		0 kills !
		15.e0 text-offset f!

		false text-lock !
		false flashlight-on !
		false flashlight-lock !

		enemies-init
		rockets-init

		false mouse-shot-lock !
		false enemies-on !

		vent heap-new drop
		;m
	overrides init

	m:	
		1 player-x f@neg player-y f@neg player-z f@neg 1.e0 light-position

		player-pan f@neg deg-to-rad fdup fsin -1.e-1 frot fcos create-3fv
		dup 3 -1.e1 scale-nfv
		1 over 3fv> 1.e0 light-spot-direction
		free-v ;m
	method light-flashlight-update

	m:	( -- ) \ crosshairs
		gl-load-identity

		window-center n>f n>f fswap 0.e0 gl-translate
		mouse-buttons @ 1 and if 2.e0 fdup fdup gl-scale then

		1.e0 gl-line-width

		4 0 u+do

			mouse-buttons @ 0= if
				45.e0 0.e0 0.e0 1.e0 gl-rotate
			then

			1.e0 0.e0 0.e0 5.e-1 gl-color-4r
			gl-triangles
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end

			mouse-buttons @ 0= if
				-45.e0 0.e0 0.e0 1.e0 gl-rotate
			then
			
			1.e0 1.e0 1.e0 gl-color-3r
			gl-line-loop
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end
			90.e0 0.e0 0.e0 1.e0 gl-rotate
		loop

		gl-load-identity
		375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset
		;m
	method crosshairs

	m: 	( -- ) \ draw-2d
		GL_BLEND gl-enable
		GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA gl-blend-func

		weapon-draw

		console-on @ false = if
		this crosshairs
		then

		GL_BLEND gl-disable

		gl-push-matrix
			15.e0 window-height 15 - n>f 0.e0 gl-translate
			10.e0 fdup fdup gl-scale
			s" kills:" font-string kills @ font-number
		gl-pop-matrix ;m
	overrides draw-2d

	m: 	( -- ) \ draw-3d
		\ environment
		sky
		light-enable
		light-update
		this light-flashlight-update
		
		1.e0 player-pan f@neg 18.e1 f+ deg-to-rad player-tilt f@neg deg-to-rad create-3fv
		dup spherical-to-cartesian
		1 over 3fv> 1.e0 light-spot-direction
		free-v

		world-draw

		rockets-draw
		
		\ presentation spot
		light-disable
		10.e0 0.e0 -10.e0 gl-translate
		-10.e0 -0.e0 10.e0 gl-translate
		\ enemies ( no lighting, fill-shaded )
		GL_BLEND gl-enable
		enemies-on @ if
			enemies-draw
		then
		light-enable

		
		\ additional stuff
		1.e0 fdup fdup fdup gl-color-4r
		1.e1 0.e0 -1.e1 gl-translate
		['] draw model-array map
		-1.e1 0.e0 1.e1 gl-translate

		\ starting pipe
		1.e0 fdup fdup 2.e-1 gl-color-4r
		24 pipe-draw

		GL_BLEND gl-disable
		light-disable

		\ nin-starwars style text
		text-display @ if
			-45.e0 1.e0 0.e0 0.e0 gl-rotate
			2.e0 gl-line-width
			0.e0 text-offset f@ world-offset- 1- n>f gl-translate
			75.e-2 fdup fdup gl-scale
			s" nin.txt" font-file
			1.e0 gl-line-width
		then
		-45.e0 1.e0 0.e0 0.e0 gl-rotate
		2.e0 gl-line-width
		-10.e0 20.e0 world-offset- 1- n>f gl-translate
		75.e-2 fdup fdup gl-scale
		console-draw
		1.e0 gl-line-width ;m
	overrides draw-3d

	m:	( -- ) \ update-navigation
		this [parent] update-navigation

		mouse-buttons @ 1 and if	\ shoot management
			mouse-shot-lock @ false = if
				rocket-shoot
			then
			true mouse-shot-lock !
		else
			false mouse-shot-lock !
		then

		'f is-keydown if 		\ flashlight
			flashlight-lock @ false = if
				flashlight-on @ invert dup if
					1 1.e0 1.e0 1.e0 1.e0 light-diffuse
				else
					1 0.e0 0.e0 0.e0 1.e0 light-diffuse
				then
				flashlight-on !
			then
			true flashlight-lock !
		else
			false flashlight-lock !
		then

		text-display @ if
			player-movement-speed 1.e1 f/ text-offset dup f@ f+ f!
		then

		't is-keydown if	\ text management
			text-lock @ false = if
				text-display @ if
					false text-display !
				else
					true text-display !
				then

				." display" text-display @ dec.
			then
				true text-lock !
		else
			false text-lock !
		then
	;m
	overrides update-navigation

	m:	enemies-update
		rockets-update ;m
	overrides update-world

end-class original

original heap-new drop

