\ Game base class, overload what you feel like
\ (c) by Gerald Wodni 2009

array heap-new constant game-array

defer set-active-game

object class
	cell%	 inst-var game-name
	cell% 2* inst-var game-forth-name

	m: game-name @ ;m
	method get-name

	m:	( -- addr n )
		game-forth-name 2@ ;m
	method get-forth-name

	m:
		s" Gameclass0" terminate-string game-name !
		s" gameclass" game-forth-name 2!
		this game-array add
		;m
	overrides construct

	m: this game-array remove ;m
	method destruct

	m:	( -- ) \ init
		0.e0 player-x f!					\ initialize player's position
		0.e0 player-y f!
		0.e0 player-z f!
		0.e0 player-pan f!
		0.e0 player-tilt f!
		1.e0 player-movement-factor f!

		SDL_DISABLE sdl-show-cursor drop
		false console-on !
		false console-lock !
		false presentation-on !
		false presentation-lock !
		0 presentation-animation !
		0 presentation-number !
		0 next-beat !
		0 picking-on !

		models-destruct
		;m
	method init

	m:	( -- )
		SDL_ENABLE sdl-show-cursor drop
		sdl-quit ;m
	method dispose

	m:
		2.e0 gl-line-width
		-45.e0 1.e0 0.e0 0.e0 gl-rotate
		-10.e0 20.e0 world-offset- 1- n>f gl-translate
		75.e-2 fdup fdup gl-scale
		console-draw
		1.e0 gl-line-width ;m
	method draw-3d-console

	m: 	( -- ) \ draw-2d
		1.e0 1.e0 1.e0 gl-color-3r
		gl-push-matrix
			15.e0 window-height 15 - n>f 0.e0 gl-translate
			10.e0 fdup fdup gl-scale
			s" 2d" font-string
		gl-pop-matrix ;m
	method draw-2d

	m: 	( -- ) \ draw-3d
		world-draw 
		this draw-3d-console ;m
	method draw-3d

	m:	( r-x r-y -- [addt-n]* n ) \ select
		['] selection-draw selectable-model-array map
	;m
	method draw-selectable

	m:	( -- ) \ update-navigation
		presentation-on @ invert if
			mouse-x @ window-half-width - n>f player-rotation-speed f* player-pan dup f@ f+ f!	\ mouse rotation
			mouse-y @ window-half-height - n>f player-rotation-speed f* player-tilt dup f@ f+ -9.e1 9.e1 fbind f!
		then

		9 is-keydown if			\ console
			console-lock @ false = if
				true console-on !
			then
			true console-lock !
		else
			false console-lock !
		then

		'p is-keydown if
			presentation-lock @ invert if
				presentation-on @ invert dup if
					-1 
				else
					1
				then
				presentation-animation !
				presentation-on !
			then	
			true presentation-lock !
		else
			'k is-keydown 'j is-keydown over or if
				presentation-lock @ invert if
					if -1 else 1 then
					presentation-number tuck @ +
					0 max presentation-slides 1- min
					swap !
				else
					drop
				then
				true presentation-lock !
			else
				false presentation-lock !
				drop
			then
		then

		\ presentation-animation @ dec. cr

		'a is-keydown if player-movement-vectors -1.e0 f* fswap player-change-position then	\ keyboard navigation
		'd is-keydown if player-movement-vectors fswap -1.e0 f* player-change-position then
		'e is-keydown if player-y f@ player-movement-speed f- player-y f! then
		'r is-keydown if player-y f@ player-movement-speed f+ player-y f! then
		
		cube-number if
			's is-keydown if player-z f@ player-movement-speed f- player-z f! then
			'w is-keydown if player-z f@ player-movement-speed f+ player-z f! then
		else
			's is-keydown if player-movement-vectors -1.e0 f* fswap -1.e0 f* fswap player-change-position then
			'w is-keydown if player-movement-vectors player-change-position then

			player-x world-offset- 1+ n>f world-offset+ 1- n>f fpbind
			player-z world-offset- 1+ n>f world-offset+ 1- n>f fpbind

		then ;m
	method update-navigation

	m: ;m
	method update-world

	m: ( -- )
		\ reset active game to first game
		game-array dup get-length 1- swap item-index set-active-game
		;m
	method escape-hit

	m: ." game-here" cr ;m
	overrides print

end-class gameclass

:noname ( addr -- )
	dup dup active-game !
	get-name NULL sdl-wm-set-caption
	init
	; is set-active-game

