\ level base class and level-primitives provider
\ (c) by Gerald Wodni 2011

require gate.fs
require plane.fs

array heap-new constant level-array

variable currentLevel
variable currentEntity

0 constant level-plane
1 constant level-gate

struct
	cell%	field type%
	cell%	field id-number%
	float%	field pos-x%
	float%	field pos-y%
	float%	field pos-z%
	float%	field color-red%
	float%	field color-green%
	float%	field color-blue%
	float%	field scale-x%
	float%	field scale-z%
end-struct entity%

an-object class
	cell% inst-var id-number
	cell% inst-var entities
	cell% inst-var planes
	cell% inst-var gates
 
	m:
		this level-array add
		0 planes !
		0 gates !
		array heap-new entities ! ;m
	overrides construct

	\ instance entities from structs
	m:
		cr
		." -----------instance" cr
		array heap-new planes !
		array heap-new gates !

		entities @ get-length 0 u+do
			~~
			i entities @ item-index
			~~
			dup type% @ case
				level-plane of ." plane!"
					plane heap-new dup
					planes @ add
				endof
				level-gate of ." gate!"
					gate heap-new dup		
					gates @ add
				endof
				." level: unknown entity" bye
			endcase
	
			( addr-struct addr-entity )
			~~

			over pos-x% f@ fdup f.
			over pos-y% f@ 
			over pos-z% f@ fdup f.
			dup set-position

			over scale-x% f@ fdup f.
			1.e0
			over scale-z% f@ fdup f.
			dup set-scale

			." col:"
			over color-red% f@ fdup f.
			over color-green% f@ fdup f.
			over color-blue% f@ fdup f.
			dup set-col

			drop

			drop \ drop s
			cr
		loop
		;m
	method instance-entities

	m:	
		planes @ 0<> if
		then
		;m
	method destruct-entities
 
	m:
		id-number !  ;m
	method set-id-number

	m:
		entity% nip allocate throw dup >r entities @ add r>
	;m method add-entity

end-class level

: new-level ( n -- )
	level heap-new dup currentLevel !
	set-id-number ;

: end-level ( -- ) ;

: new-entity ( -- )
	currentLevel @ add-entity currentEntity ! ;

: new-plane ( n -- )
	level-plane
	new-entity
	currentEntity @ type% !
	currentEntity @ id-number% !
	1.e0 currentEntity @ scale-x% f!
	1.e0 currentEntity @ scale-z% f! ;

: new-gate ( -- )
	level-gate
	new-entity
	currentEntity @ type% !
	1.e0 currentEntity @ scale-x% f!
	1.e0 currentEntity @ scale-z% f! ;

: entity-position ( r-x r-y r-z -- )
	currentEntity @
	dup pos-x% f!
	dup pos-y% f!
	pos-z% f! ;

: entity-scale ( r-w r-h -- )
	currentEntity @
	dup scale-x% f!
	scale-z% f! ;

: entity-color ( r-w r-h -- )
	currentEntity @
	dup color-red% f!
	dup color-green% f!
	color-blue% f! ;

