\ Real Time Strategy game for Boolean Enthusiasts
\ (c) by Gerald Wodni 2009

require levels.fs

gameclass class
	cell% 2* inst-var cursor-x
	cell% 2* inst-var cursor-y
	cell% 2* inst-var map-x
	cell% 2* inst-var map-z
	cell% 2* inst-var scroll-border
	cell% 	 inst-var hit-lock
	
	cell% 2* 16 *	inst-var modelview-matrix	\ r
	cell% 2* 16 *	inst-var projection-matrix	\ r
	cell% 4 *	inst-var viewport		\ n
	cell% inst-var		win-x			\ f
	cell% inst-var		win-y			\ f
	cell% inst-var		win-z			\ f
	cell% 2* inst-var	pos-x			\ r
	cell% 2* inst-var	pos-y			\ r
	cell% 2* inst-var	pos-z			\ r

	m:	this [parent] construct
		s" Boolean Takeover0" terminate-string game-name !
		s" boolean-takeover" game-forth-name 2!
		;m
	overrides construct

	m:	( -- ) \ init
		this [parent] init

		true picking-on !

		\ put player in strategical view
		45.e0 player-pan f!
		45.e0 player-tilt f!
		-5.e0 player-y f!

		window-half-width n>f cursor-x f!
		window-half-height n>f cursor-y f!

		5.e0 scroll-border f!
		1.3e0 player-movement-factor f!

		false hit-lock !

		\ 3.e0 0.5e0 -3.e0 button heap-new dup set-position
		\ 1.e0 0.e0 1.e0 set-color

		0 level-array item-index instance-entities 

		;m
	overrides init

	\ TODO: understand and fix this madness
	m:	( -- )
		GL_MODELVIEW_MATRIX modelview-matrix gl-get-rv
		GL_PROJECTION_MATRIX projection-matrix gl-get-rv
		GL_VIEWPORT viewport gl-get-nv

		cursor-x f@ win-x sf!
		viewport 3 cells + @ n>f cursor-y f@ f- win-y sf!
\ c-function	gl-read-pixels	glReadPixels	n n n n n n a -- void		( x y width height format type pixels -- )
		
		win-x sf@ f>n win-y sf@ f>n 1 1 GL_DEPTH_COMPONENT GL_FLOAT win-z gl-read-pixels

		win-y sf@ win-z sf@ win-y sf! win-z sf!

		\ ." mouse: " cursor-x f@ fe. cursor-y f@ fe. cr
		." win: " win-x sf@ fe. win-y sf@ fe. win-z sf@ fe. cr
		
\ c-function	glu-un-project	gluUnProject	r r r a a a a a a -- n		( winX winY winZ model proj view objX objY objZ -- )
		win-x sf@ win-y sf@ win-z sf@ modelview-matrix projection-matrix viewport pos-x pos-y pos-z glu-un-project
		." res: " dec. cr
	;m	
	method get-3d-pos

	m:	( -- ) \ crosshairs
		gl-load-identity

		cursor-x f@ cursor-y f@ 0.e0 gl-translate
		mouse-buttons @ 1 and if 2.e0 fdup fdup gl-scale then

		1.e0 gl-line-width

		4 0 u+do

			mouse-buttons @ 0= if
				45.e0 0.e0 0.e0 1.e0 gl-rotate
			then

			1.e0 0.e0 0.e0 5.e-1 gl-color-4r
			gl-triangles
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end

			mouse-buttons @ 0= if
				-45.e0 0.e0 0.e0 1.e0 gl-rotate
			then
			
			1.e0 1.e0 1.e0 gl-color-3r
			gl-line-loop
				3 dup	gl-vertex-2n
				10 20	gl-vertex-2n
				20 10	gl-vertex-2n
			gl-end
			90.e0 0.e0 0.e0 1.e0 gl-rotate
		loop

		gl-load-identity
		375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset
		;m
	method crosshairs

	m: 	( -- ) \ draw-2d
		gl-push-matrix
			this crosshairs
			1.e0 gl-line-width

			1.e0 1.e0 1.e0 gl-color-3r

			15.e0 window-height 15 - n>f 0.e0 gl-translate
			10.e0 fdup fdup gl-scale
			s" boolean takeover" font-string
		gl-pop-matrix ;m
	overrides draw-2d

	m: 	( -- ) \ draw-3d
		( gl-push-matrix
			player-x f@ fnegate
			map-x f@ f+
			0.e0
			player-z f@ fnegate
			map-z f@ f+
			gl-translate
			cube-draw
		gl-pop-matrix )

		\ world-draw 

		1.e0 fdup fdup fdup gl-color-4r
		['] draw model-array map

		this draw-3d-console ;m
	overrides draw-3d

	m:	( -- ) \ update-navigation

		\ rotate camera
		mouse-buttons @ 2 and if
			mouse-x @ window-half-width - n>f player-rotation-speed f* player-pan dup f@ f+ f!	\ mouse rotation
			mouse-y @ window-half-height - n>f player-rotation-speed f* player-tilt dup f@ f+ -9.e1 9.e1 fbind f!
			player-tilt 10.e0 90.e0 fpbind
		\ move cursor
		else
			mouse-x @ window-half-width - n>f cursor-x dup f@ f+ 0.e0 window-width n>f fbind f!
			window-half-height mouse-y @ - n>f cursor-y dup f@ f+ 0.e0 window-height n>f fbind f!
		then

		cursor-x f@ pick-x f! cursor-y f@ pick-y f!

		mouse-buttons @ 1 and if
			hit-lock @ invert if
				true hit-lock !
				( \ 10.e0 0.e0 0.e0 vent heap-new set-position )
				player-x f@ fnegate
				map-x f@ f+
				0.e0
				player-z f@ fnegate
				map-z f@ f+
				." m " frot fe. fswap fe. fe. cr
				
				\ vent heap-new set-position )

				this get-3d-pos
				." o " pos-x f@ fe. pos-y f@ fe. pos-z f@ fe. cr
				cr
			then
		else
			false hit-lock !
		then

		\ update position
		'a is-keydown cursor-x f@ scroll-border f@ f< or
		if player-movement-vectors -1.e0 f* fswap player-change-position then	

		'd is-keydown cursor-x f@ window-width n>f scroll-border f@ f- f> or
		if player-movement-vectors fswap -1.e0 f* player-change-position then

		's is-keydown cursor-y f@ scroll-border f@ f< or
		if player-movement-vectors -1.e0 f* fswap -1.e0 f* fswap player-change-position then

		'w is-keydown cursor-y f@ window-height n>f scroll-border f@ f- f> or
		if player-movement-vectors player-change-position then

		\ compute tilt-offset ( real-ground-pivot )
		player-y f@ 9.e1 player-tilt f@ f- deg-to-rad ftan f*

		fdup player-pan dup f@ deg-to-rad fcos f* fdup map-z f!
		player-z world-offset- 1+ n>f fover f+ world-offset+ 1- n>f frot f+ fpbind
		f@ deg-to-rad fnegate fsin f* fdup map-x f!
		player-x world-offset- 1+ n>f fover f+ world-offset+ 1- n>f frot f+ fpbind

		\ map-x f!
		\ map-z f!
	;m
	overrides update-navigation

end-class boolean-takeover

boolean-takeover heap-new drop

