require utils.fs
require sdl.fs
require glsimple.fs
require vector.fs
require models.fs
require light.fs
require font.fs

\ static values ( configureable )
1024	constant  window-width
768	constant  window-height
0	constant  window-fullscreen
45.e0	fconstant window-fovy
1.e-1	fconstant window-clipping-near
3.e2	fconstant window-clipping-far
1.e-2	fconstant player-movement-basic-speed
1.e-1	fconstant player-rotation-speed

100	constant  fps-update
1000	constant  beat-interval
4	constant  gl-multisamples

0 	constant  cube-number
0	constant  debug-mode

8	constant  presentation-slides

512	constant  pick-buffer-size
pick-buffer-size allocate throw constant pick-buffer

variable lock-escape
0 lock-escape !

\ globals
variable exit-glforth		\ flag
0 exit-glforth !

variable mouse-x		\ n
variable mouse-y		\ n
variable mouse-buttons		\ n
variable num-keys		\ n
variable keystate		\ a
variable fps			\ n

variable console-on		\ n
variable console-lock		\ n 
variable presentation-on	\ n
variable presentation-lock	\ n 
variable presentation-animation	\ n
variable presentation-number	\ n

variable next-beat		\ n

fvariable beat-state		\ r

fvariable player-x		\ r
fvariable player-y		\ r
fvariable player-z		\ r
fvariable player-pan		\ r
fvariable player-tilt		\ r
fvariable player-movement-factor	\ r

variable  picking-on		\ f
0 picking-on !
variable  num-picked		\ n
fvariable pick-x		\ r	picking coordinates
fvariable pick-y		\ r


require models/model.fs

: is-keydown ( n-key -- flag )
	keystate @ + c@ ;	\ get pointer address, add array index and return this value

require console.fs
require scene.fs

require games/games.fs
require console-commands.fs

: display-fps ( -- )
	gl-load-identity
	1.e0 1.e0 1.e0 gl-color-3r
	window-width 120 - n>f window-height 15 - n>f 0.e0 gl-translate
	10.e0 fdup fdup gl-scale
	s" fps=" font-string
	fps @ font-number
	;


: sprint-n ( number n-digits addr -- )
	over + swap
	0 u+do
		1- swap		\ addr number
		10 /mod 	\ addr digit remainder
		-rot		\ remainder addr digit
		'0 + over c!
	loop 2drop ;

: presentation-draw-3d
 
	gl-load-identity
	-1.e0 0.e0 -181.e-2 gl-translate

	presentation-animation @ abs 2 = if
		beat-state f@
		presentation-animation @ 0< if
			1.e0 fswap f-
		then
		120.e0 f* 0.e0 1.e0 0.e0 gl-rotate
	then

	1.e0 0.e0 0.e0  gl-translate

	1.e0 1.e0 1.e0 1.e0 gl-color-4r
	gl-quads
		-1.e0 -75.e-2 gl-vertex-2r
		 1.e0 -75.e-2 gl-vertex-2r
		 1.e0  75.e-2 gl-vertex-2r
		-1.e0  75.e-2 gl-vertex-2r
	gl-end

	0.e0 0.e0 0.e0 0.e0 gl-color-4r
	
	-95.e-2 65.e-2 1.e-2  gl-translate

	5.e-2 fdup fdup gl-scale
	s" presentation/00.txt" over 13 + presentation-number @ 2 rot sprint-n font-presentation-file
	;

: render ( -- )
	
	;

: game ( -- )
	scene-init
	active-game @ init
	active-game @ get-name NULL sdl-wm-set-caption
	
	0				\ total frames
	sdl-get-ticks fps-update +	\ next tick
	0				\ frame counter
	dup fps !			\ store into framecounter

	window-half-width window-half-height sdl-warp-mouse	\ set mouse to center of window ( to make sure we are looking straight )
	begin
		\ save current keystate to old-keystate
		keystate @ old-keystate @ num-keys @ move

		sdl-pump-events						\ as we can't handle with structs, leave that to SDL
		num-keys sdl-get-key-state keystate !			\ get current keystates
		mouse-x mouse-y sdl-get-mouse-state mouse-buttons !	\ get current mouseposition and buttons
		window-half-width window-half-height sdl-warp-mouse	\ set mouse to center of window
		
		console-on @ false = if
			active-game @ update-navigation
		else
			console-update
		then

		scene-begin

		picking-on @ if
			unselect-models

			scene-start-picking
			active-game @ draw-selectable
			scene-stop-picking

			notify-selected
		then

		1 if
		scene-perspective
			active-game @ draw-3d
		then

			presentation-animation @ dup presentation-on @ or swap -1 <> and if
				presentation-draw-3d
			else
				scene-ortho

				375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset
				active-game @ draw-2d
				display-fps
			then
		scene-finalize


		\ fps handeling
		1+				\ increment frame counter
		over sdl-get-ticks < if		\ fps update necessary?
			active-game @ update-world
			rot over + -rot		\ add current counter to total fps counter
			1000 fps-update / *
			fps !			\ store frame counter into fps
			fps-update +		\ next tick
			0			\ reset frame counter
		then
		
		\ beats
		next-beat @ sdl-get-ticks - dup 0< if	\ check if a beat should occur
			next-beat dup @ beat-interval + swap !
			
			['] beat model-array map \ perform animation beat

			presentation-animation @ if	\ start animation
				presentation-animation @
				dup sign + dup abs 2 > if
					drop 0
				then
				presentation-animation !
			then

			drop beat-interval	\ "reset" animation

		then 
		
		\ animation ( float to next beat [0,1] )
		1.e0 n>f beat-interval n>f f/ f- 
		['] animate model-array map beat-state f!

		\ debug output
		debug-mode if
			1+ dup dec.						\ current frame
			s" playerposition " type
			player-x f@ f.						\ player-position
			player-z f@ f.
			s" rotation " type
			player-pan f@ f.
			player-tilt f@ f.
			cr
		then

		\ exit game handler
		27 is-keydown if
			lock-escape @ 0= if
				1 lock-escape !
				active-game @ escape-hit
			then
		else
			0 lock-escape !
		then
		
		exit-glforth @
	until

	2drop ." You enjoyed " dup n>f dec. ." frames of GLforth in " sdl-get-ticks dup n>f dec. ." ms" cr
	." That makes an average of " 1.e3 f/ f/ f. ." FPS" cr

	active-game @ dispose ;

\ uncomment if you have compiled in sdl & gl support (you most likely won't)
game
bye

