\ font - define and display a very basic gl-font
\ (c) by Gerald Wodni 2008

require glsimple.fs

15e-1 fconstant letter+spacing
256 constant max-line-length

8 constant font-cursor-char
1 constant font-happy-smiley-char
2 constant font-sad-smiley-char

: font-A
	gl-line-strip
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end
;

: font-B
	gl-line-loop
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		5.e-1 1.e0 gl-vertex-2r
		1.e0 75.e-2 gl-vertex-2r
		5.e-1 5.e-1 gl-vertex-2r
		1.e0 25.e-2 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		5.e-1 fdup gl-vertex-2r
	gl-end ;

: font-C
	gl-line-strip
		1 0 gl-vertex-2n
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-D
	gl-line-loop
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		5.e-1 1.e0 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-E
	gl-line-strip
		1 0 gl-vertex-2n
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-F
	gl-line-strip
		1 1 gl-vertex-2n
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
	gl-end
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-G
	gl-line-strip
		5.e-1 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		1 0 gl-vertex-2n
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-H
	gl-lines
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-I
	gl-lines
		5.e-1 0.e0 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
		2.e-1 0.e0 gl-vertex-2r
		8.e-1 0.e0 gl-vertex-2r
		8.e-1 1.e0 gl-vertex-2r
		2.e-1 1.e0 gl-vertex-2r
	gl-end ;

: font-J
	gl-line-strip
		25.e-2 25.e-2 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
		75.e-2 25.e-2 gl-vertex-2r
		75.e-2 1.e0 gl-vertex-2r
		25.e-2 1.e0 gl-vertex-2r
	gl-end ;

: font-K
	gl-line-strip
		1 1 gl-vertex-2n
		5.e-1 5.e-1 gl-vertex-2r
		1 0 gl-vertex-2n
	gl-end
	gl-lines
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		0.e0 5.e-1 gl-vertex-2r
		5.e-1 5.e-1 gl-vertex-2r
	gl-end ;

: font-L
	gl-line-strip
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-M
	gl-line-strip
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		5.e-1 fdup gl-vertex-2r
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-N
	gl-line-strip
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-NIN
	gl-line-strip
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-O
	gl-line-loop
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-P
	gl-line-strip
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-Q
	gl-line-loop
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end
	gl-lines
		5.e-1 fdup gl-vertex-2r
		1 0 gl-vertex-2n
	gl-end ;

: font-R
	gl-line-strip
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
	gl-end
	gl-lines
		5.e-1 5.e-1 gl-vertex-2r
		1 0 gl-vertex-2n
	gl-end ;

: font-S
	gl-line-strip
		0 0 gl-vertex-2n
		75.e-2 0.e0 gl-vertex-2r
		1.e0 25.e-2 gl-vertex-2r
		75.e-2 5.e-1 gl-vertex-2r
		25.e-2 5.e-1 gl-vertex-2r
		0.e0 75.e-2 gl-vertex-2r
		25.e-2 1.e0 gl-vertex-2r
		1 1 gl-vertex-2n
	gl-end ;

: font-T
	gl-lines
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		5.e-1 0.e0 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
	gl-end ;

: font-U
	gl-line-strip
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-V
	gl-line-strip
		0 1 gl-vertex-2n
		5.e-1 0.e0 gl-vertex-2r
		1 1 gl-vertex-2n
	gl-end ;

: font-W
	gl-line-strip
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
		5.e-1 fdup gl-vertex-2r
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-X
	gl-lines
		0 0 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
		0 1 gl-vertex-2n
	gl-end ;

: font-Y
	gl-line-strip
		0 1 gl-vertex-2n
		5.e-1 fdup gl-vertex-2r
		1 1 gl-vertex-2n
	gl-end
	gl-lines
		5.e-1 fdup gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-Z
	gl-line-strip
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-0
	gl-line-loop
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
		0 1 gl-vertex-2n
	gl-end
	gl-lines
		0 0 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-1
	gl-line-strip
		25.e-2 75.e-2 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-2
	gl-line-strip
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-3
	gl-line-strip
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
		0 1 gl-vertex-2n
	gl-end
	gl-lines
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-4
	gl-line-strip
		0 1 gl-vertex-2n
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		1 0 gl-vertex-2n
	gl-end
	gl-lines
		1 1 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-5
	gl-line-strip
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
	gl-end ;

: font-6
	gl-line-strip
		1 1 gl-vertex-2n
		0 1 gl-vertex-2n
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1.e0 5.e-1 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-7
	gl-line-strip
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end ;

: font-8
	gl-line-loop
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1 gl-vertex-2n
		0 1 gl-vertex-2n
	gl-end
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-9
	gl-line-strip
		0 0 gl-vertex-2n
		1 0 gl-vertex-2n
		1 1  gl-vertex-2n
		0 1 gl-vertex-2n
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-'
	gl-lines
		5.e-1 1.e0 gl-vertex-2r
		5.e-1 75.e-2 gl-vertex-2r
	gl-end ;

: font-"
	gl-lines
		33.e-2 1.e0 gl-vertex-2r
		33.e-2 75.e-2 gl-vertex-2r
		66.e-2 1.e0 gl-vertex-2r
		66.e-2 75.e-2 gl-vertex-2r
	gl-end ;

: font-,
	gl-lines
		3.e-1 0.e0 gl-vertex-2r
		7.e-1 4.e-1 gl-vertex-2r
	gl-end ;

: font-.
	gl-lines
		5.e-1 25.e-2 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-:
	gl-lines
		5.e-1 75.e-2 gl-vertex-2r
		5.e-1 5.e-1 gl-vertex-2r
		5.e-1 25.e-2 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-@
	gl-line-strip
		75.e-2 0.e0 gl-vertex-2r
		25.e-2 0.e0 gl-vertex-2r
		0.e0 25.e-2 gl-vertex-2r
		0.e0 75.e-2 gl-vertex-2r
		25.e-2 1.e0 gl-vertex-2r
		75.e-2 1.e0 gl-vertex-2r
		1.e0 75.e-2 gl-vertex-2r
		1.e0 3.e-1 gl-vertex-2r
		4.e-1 3.e-1 gl-vertex-2r
		3.e-1 4.e-1 gl-vertex-2r
		3.e-1 6.e-1 gl-vertex-2r
		4.e-1 7.e-1 gl-vertex-2r
		8.e-1 7.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;

: font-?
	gl-line-strip
		0.e0 75.e-2 gl-vertex-2r
		25.e-2 1.e0 gl-vertex-2r
		75.e-2 1.e0 gl-vertex-2r
		1.e0 75.e-2 gl-vertex-2r
		5.e-1 5.e-1 gl-vertex-2r
		5.e-1 3.e-1 gl-vertex-2r
	gl-end
	gl-lines
		5.e-1 0.e0 gl-vertex-2r
		5.e-1 2.e-1 gl-vertex-2r
	gl-end ;

: font-!
	gl-lines
		5.e-1 1.e0 gl-vertex-2r
		5.e-1 3.e-1 gl-vertex-2r
		5.e-1 2.e-1 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-+
	gl-lines
		5.e-1 0.e0 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end ;


: font-*
	gl-lines
		5.e-1 0.e0 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		1.e-1 fdup gl-vertex-2r
		9.e-1 fdup gl-vertex-2r
		1.e-1 9.e-1 gl-vertex-2r
		9.e-1 1.e-1 gl-vertex-2r
	gl-end ;

: font--
	gl-lines
		75.e-2 5.e-1 gl-vertex-2r
		25.e-2 5.e-1 gl-vertex-2r
	gl-end ;

: font-_
	gl-lines
		0.e0 0.e0 gl-vertex-2r
		1.e0 0.e0 gl-vertex-2r
	gl-end ;


: font-/
	gl-lines
		75.e-2 1.e0 gl-vertex-2r
		25.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-|
	gl-lines
		5.e-1 1.e0 gl-vertex-2r
		5.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-\
	gl-lines
		25.e-2 1.e0 gl-vertex-2r
		75.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-#
	gl-lines
		1.e-1 66.e-2 gl-vertex-2r
		1.e0 66.e-2 gl-vertex-2r
		0.e0 33.e-2 gl-vertex-2r
		9.e-1 33.e-2 gl-vertex-2r
		4.e-1 1.e0 gl-vertex-2r
		3.e-1 0.e0 gl-vertex-2r
		7.e-1 1.e0 gl-vertex-2r
		6.e-1 0.e0 gl-vertex-2r
	gl-end ;

: font-(
	gl-line-strip
		75.e-2 1.e0 gl-vertex-2r
		25.e-2 75.e-2 gl-vertex-2r
		25.e-2 25.e-2 gl-vertex-2r
		75.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-)
	gl-line-strip
		25.e-2 1.e0 gl-vertex-2r
		75.e-2 75.e-2 gl-vertex-2r
		75.e-2 25.e-2 gl-vertex-2r
		25.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-[
	gl-line-strip
		75.e-2 1.e0 gl-vertex-2r
		25.e-2 1.e0 gl-vertex-2r
		25.e-2 0.e0 gl-vertex-2r
		75.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-]
	gl-line-strip
		25.e-2 1.e0 gl-vertex-2r
		75.e-2 1.e0 gl-vertex-2r
		75.e-2 0.e0 gl-vertex-2r
		25.e-2 0.e0 gl-vertex-2r
	gl-end ;

: font-<
	gl-line-strip
		75.e-2 75.e-2 gl-vertex-2r
		25.e-2 5.e-1 gl-vertex-2r
		75.e-2 25.e-2 gl-vertex-2r
	gl-end ;

: font->
	gl-line-strip
		25.e-2 75.e-2 gl-vertex-2r
		75.e-2 5.e-1 gl-vertex-2r
		25.e-2 25.e-2 gl-vertex-2r
	gl-end ;

: font-=
	gl-lines
		0.e0 33.e-2 gl-vertex-2r
		1.e0 33.e-2 gl-vertex-2r
		0.e0 66.e-2 gl-vertex-2r
		1.e0 66.e-2 gl-vertex-2r
	gl-end ;

: font-cursor
	gl-line-loop
		0.e0 1.e0 gl-vertex-2r
		5.e-1 5.e-1 gl-vertex-2r
		1.e0 1.e0 gl-vertex-2r
	gl-end
	gl-lines
		0.e0 0.e0 gl-vertex-2r
		1.e0 0.e0 gl-vertex-2r
	gl-end ;

: font-smiley-eyes
	gl-lines
		33.e-2 1.e0 gl-vertex-2r
		33.e-2 75.e-2 gl-vertex-2r
		66.e-2 1.e0 gl-vertex-2r
		66.e-2 75.e-2 gl-vertex-2r
	gl-end ;

: font-happy-smiley
	GL_CURRENT_BIT gl-push-attrib
		5.e-1 1.e0 5.e-1 gl-color-3r
		font-smiley-eyes
		gl-line-strip
			0.e0 33.e-2 gl-vertex-2r
			33.e-2 0.e0 gl-vertex-2r
			66.e-2 0.e0 gl-vertex-2r
			1.e0 33.e-2 gl-vertex-2r
		gl-end
	gl-pop-attrib ;

: font-sad-smiley
	GL_CURRENT_BIT gl-push-attrib
		1.e0 5.e-1 5.e-1 gl-color-3r
		font-smiley-eyes
		gl-line-strip
			0.e0 0.e0 gl-vertex-2r
			33.e-2 33.e-2 gl-vertex-2r
			66.e-2 33.e-2 gl-vertex-2r
			1.e0 0.e0 gl-vertex-2r
		gl-end
	gl-pop-attrib ;

: font-item
	gl-lines
		0.e0 5.e-1 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
	gl-end
	gl-line-strip
		5.e-1 0.e0 gl-vertex-2r
		1.e0 5.e-1 gl-vertex-2r
		5.e-1 1.e0 gl-vertex-2r
	gl-end ;

: font-point
	gl-line-loop
		375.e-3 75.e-2 gl-vertex-2r
		675.e-3 75.e-2 gl-vertex-2r
		75.e-2 675.e-3 gl-vertex-2r
		75.e-2 375.e-3 gl-vertex-2r
		675.e-3 25.e-2 gl-vertex-2r
		375.e-3 25.e-2 gl-vertex-2r
		25.e-2 375.e-3 gl-vertex-2r
		25.e-2 675.e-3 gl-vertex-2r
	gl-end ;

: font-arm
	gl-line-strip
		0.e0 0.e0 gl-vertex-2r
		3.e0 0.e0 gl-vertex-2r
		3.e0 -3.e0 gl-vertex-2r
		1.e0 -5.e0 gl-vertex-2r
	gl-end
	gl-line-strip
		3.e0 -5.e0 gl-vertex-2r
		3.e0 -3.e0 gl-vertex-2r
		5.e0 -5.e0 gl-vertex-2r
	gl-end
	GL_CURRENT_BIT gl-push-attrib
	1.e0 0.e0 fdup gl-color-3r
	10.e0 gl-point-size
	GL_POINTS gl-begin
		0.e0 0.e0 gl-vertex-2r
		3.e0 -3.e0 gl-vertex-2r
		3.e0 0.e0 gl-vertex-2r
	gl-end
	gl-pop-attrib
	;

: font-unknown
	gl-line-loop
		0 0 gl-vertex-2n
		0 1 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
	gl-end
	gl-lines
		0 0 gl-vertex-2n
		1 1 gl-vertex-2n
		1 0 gl-vertex-2n
		0 1 gl-vertex-2n
	gl-end ;

: font-letter ( n -- )		\ render letter
	case
		'a of font-A endof
		'A of font-arm endof
		'b of font-B endof
		'c of font-C endof
		'd of font-D endof
		'e of font-E endof
		'f of font-F endof
		'g of font-G endof
		'h of font-H endof
		'i of font-I endof
		'I of font-item endof
		'j of font-J endof
		'k of font-K endof
		'l of font-L endof
		'm of font-M endof
		'n of font-N endof
		'N of font-NIN endof
		'o of font-O endof
		'P of font-point endof
		'p of font-P endof
		'q of font-Q endof
		'r of font-R endof
		's of font-S endof
		't of font-T endof
		'u of font-U endof
		'v of font-V endof
		'w of font-W endof
		'x of font-X endof
		'y of font-Y endof
		'z of font-Z endof
		'0 of font-0 endof
		'1 of font-1 endof
		'2 of font-2 endof
		'3 of font-3 endof
		'4 of font-4 endof
		'5 of font-5 endof
		'6 of font-6 endof
		'7 of font-7 endof
		'8 of font-8 endof
		'9 of font-9 endof
		'" of font-" endof
		'' of font-' endof
		', of font-, endof
		'. of font-. endof
		': of font-: endof
		'@ of font-@ endof
		'? of font-? endof
		'! of font-! endof
		'+ of font-+ endof
		'* of font-* endof
		'- of font-- endof
		'_ of font-_ endof
		'/ of font-/ endof
		'| of font-| endof
		'\ of font-\ endof
		'# of font-# endof
		'( of font-( endof
		') of font-) endof
		'[ of font-[ endof
		'] of font-] endof
		'< of font-< endof
		'> of font-> endof
		'= of font-= endof
		font-cursor-char	of font-cursor		endof		\ display cursor, cause backspace has nothing to display
		font-happy-smiley-char	of font-happy-smiley	endof		\ smileys
		font-sad-smiley-char	of font-sad-smiley	endof
		32 of endof			\ space has nothing to render ;)
		font-unknown			\ display "unknown-char" if nothing matched
	endcase ;

: font-string ( addr n -- )			\ render string
	0 u+do
		dup c@ font-letter 1+
		letter+spacing 0.e0 fdup gl-translate
	loop drop ;

: font-centered-string ( addr n -- ) 		\ center and render string
	dup negate n>f letter+spacing f* 	\ string width
	2.e0 f/ fdup 0.e0 fdup gl-translate	\ to the left
	font-string				
	fnegate 0.e0 fdup gl-translate			\ back to the center
	;

: font-both-centered-string ( addr n -- )
	0.e0 -5.e-1 0.e0 gl-translate
	font-centered-string
	0.e0 5.e-1 0.e0 gl-translate
	;

: font-number ( n -- ) 				\ render number
	digitify
	0 u+do
		'0 + font-letter
		letter+spacing 0.e0 fdup gl-translate
	loop
	;

: font-file ( addr n -- )	\ render file
	max-line-length 2 + allocate throw dup >r -rot		\ get line-buffer ( one copy on the r-stack and one on the real stack )
	r/o open-file throw					\ get a fd
	max-line-length swap					\ buffer-size

	begin
		3dup						\ line-buffer length fd
		read-line 0= and				\ read line and check result
		swap r@ over font-centered-string		\ render string
		negate n>f					\ return to start point
		letter+spacing f* letter+spacing fnegate 0.e0 gl-translate
	while repeat
	
	r> drop							\ drop line-buffer's copy on the r-stack

	close-file throw					\ close file
	drop							\ drop buffer-size
	free throw						\ free line-buffer
	;

: erase-line 
	0.e0 letter+spacing 0.e0 gl-translate	\ translate back ( pre-eliminate line )
	nip 1 swap		\ set string-length to 0
	;

\ BUG: presentation file with line content " x" produces erase-line event
: font-presentation-file ( addr n -- )	\ render file
	max-line-length 2 + allocate throw dup >r -rot		\ get line-buffer ( one copy on the r-stack and one on the real stack )
	r/o open-file throw					\ get a fd
	max-line-length swap					\ buffer-size

	3.e0 gl-line-width
	\ 2.e0 fdup fdup gl-scale
	begin
		3dup						\ line-buffer length fd
		read-line 0= and				\ read line and check result
		\ swap r@ over dup if 
		swap r@ over if
			dup c@ case
				'# of	erase-line	endof			
				'e of	
					0.e0 1.e0 0.e0 gl-translate
					endof			
				'+ of	
					0.e0 -1.e0 0.e0 gl-translate
					2.e0  fdup fdup gl-scale 
					3.e0 gl-line-width
					endof
				'- of	
					5.e-1 fdup fdup gl-scale
					0.e0  15.e-1 0.e0 gl-translate
					2.e0 gl-line-width
					endof
				'> of
					letter+spacing 13.e0 f* 0.e0 0.e0 gl-translate
					endof
				'< of
					letter+spacing -13.e0 f* 0.e0 0.e0 gl-translate
					endof
				'| of	-1 >r	endof

			endcase
			swap 1- swap 1+				\ don't display first char
		then

		over 1 = if erase-line then			\ erase command-only lines
		over
		
		r@ -1 = if
			r> drop
			font-centered-string
		else
			font-string					\ render string
		then
		negate n>f					\ return to start point
		letter+spacing f* letter+spacing fnegate 0.e0 gl-translate
	while repeat
	
	r> drop							\ drop line-buffer's copy on the r-stack

	close-file throw					\ close file
	drop							\ drop buffer-size
	free throw						\ free line-buffer
	;

