\ lightwight in-game console
\ (c) by Gerald Wodni 2008

require string-array.fs

80 constant console-max-line-size

variable execution-token-value
variable execution-token-number
variable console-catch-keys
variable console-input-string
variable console-input-count
variable console-history

variable old-keystate		\ a

: console-init
	\ s" console" console-input-count ! console-input-string !
	0 allocate throw 0 console-input-count ! console-input-string !
	512 chars allocate throw old-keystate !
	string-array heap-new console-history !
	;

: append-c	( addr1 u1 n-char -- addr u )
	>r 1+ tuck resize throw	swap 2dup 1- chars + r> swap c! ;

: remove-c	( addr1 u1 -- addr u )
	1- tuck 1 max resize throw swap ;

: console-append-c	( c -- )
	console-input-string @ console-input-count @ rot append-c console-input-count ! console-input-string ! ;

: console-remove-c	( -- )
	console-input-string @ console-input-count @ remove-c console-input-count ! console-input-string ! ;

: copy-string ( addr n -- addr2 - n )
	." Do not use copy-string, there is a very strange error" cr
	dup allocate throw	\ a l s
	swap 2dup >r >r		\ a s l
	move			\ <0>
	r> r> ;

: execute-string ( addr n -- )
	2dup 2dup forth-wordlist search-wordlist
	0= if 
		." Error, unknown command >" type ." <" cr 
		font-sad-smiley-char append-c
	else
		execute
		." >" type ." < successfully executed" cr
		font-happy-smiley-char append-c
	then
	
	\ copy-string console-history @ add 
	console-history @ add 
	;

: console-print
	console-history @ print ;

: console-draw-line
	0.e0 2.e0 0.e0 gl-translate 
	gl-push-matrix
	font-string
	gl-pop-matrix
	;

: console-draw
	'a keystate @ + @ if
	\	'x console-append-c
	then
	gl-push-matrix
	console-input-string @ console-input-count @ font-string 
	\ draw cursor
	console-on @ if
		GL_CURRENT_BIT gl-push-attrib
		beat-state f@ 1.e0 fover f-	\ 0->1 1->0
		fover 5.e-1 f> if
			fswap 1.e0 gl-color-3r
		else
			1.e0 gl-color-3r
		then
		font-cursor
		gl-pop-attrib
	then
	gl-pop-matrix

	['] console-draw-line console-history @ rmap

	;


: console-update
	\ switch back to game
	9 is-keydown if	
		console-lock @ invert if
			false console-on !
		then
		true console-lock !
	else
		false console-lock !

		\ check for new keypresses
		keystate @ old-keystate @ num-keys @ 0 u+do
			over c@ over c@ <> if	\ button changed
				over c@ if	\ button pressed

					i case
						8 of
							console-input-count @ if	\ only remove chars if there are some
								console-remove-c
							then
						endof
						13 of
							console-input-string @ console-input-count @ execute-string
							0 console-input-string !
							0 console-input-count !
						endof

						i console-append-c			\ append char to input string
					endcase
				then
			then
			1+ swap 1+ swap
		loop 2drop
	then
	;



console-init

: test cr ." this is a simple, though powerful function if it gets called via the in game console" cr ;

s" please come here" console-history @ add
s" hit tab" console-history @ add
s" and type 'test'" console-history @ add
s" hit enter" console-history @ add
s" hopefully you'll" console-history @ add
s" get a smile" console-history @ add

