\ starfield model
\ (c) by Gerald Wodni 2008

1000 constant starfield-default-size
1.e2 fconstant starfield-default-range
1.e2 fconstant starfield-default-speed

: random-color-part ( n-offset -- r-number )
	255 over - random + n>f 255.e f/ ;

: random-color ( n-offset -- )
	dup random-color-part dup random-color-part random-color-part gl-color-3r ;

model class
	cell% inst-var hmStars
	cell% inst-var stars
	cell% inst-var range
	cell% inst-var speed
	cell% inst-var lastAnimationValue
	cell% inst-var position
	cell% inst-var color-seed

	m:	this [parent] construct
		starfield-default-size hmStars !
		starfield-default-range range sf!
		starfield-default-speed speed sf!
		0.e lastAnimationValue sf!
		0.e 0.e 0.e create-3fv position !
		0 color-seed !
		range sf@ f>n
		hmStars @ dup cells allocate throw dup stars !
		swap 0 u+do
			over dup 2* random swap - n>f
			over dup 2* random swap - n>f
			over dup 2* random swap - n>f
			 create-3fv over !
			cell+
		loop drop ;m
	overrides construct

	m:	position @ >3fv	;m
	method set-position

	m:	fdup lastAnimationValue sf@ f-	\ get difference to last beat
		speed sf@ f*
		0.e 0.e frot create-3fv		\ create difference vector
		stars @ hmStars @ 0 u+do
			over over @ 3fv+	\ add difference vector to star
			dup @ 2 cells + dup sf@ range sf@ f> if
				range sf@ -1.e f* sf!		\ reset to starting point
			else
				drop		\ no need for the address
			then
			cell+		
		loop drop free-v
		fdup lastAnimationValue sf! ;m
	overrides animate

	m:	0.e lastAnimationValue sf!
		color-seed dup @ 1+ swap ! ;m		
	overrides beat
	
	m:	gl-push-matrix
		position @ 3fv> gl-translate
		color-seed @ seed !
		gl-triangles
		stars @ hmStars @ 0 u+do
			color-seed @ 2 mod 128 * random-color
			dup @ dup	3fv> gl-vertex-3r
			dup		3fv> frot 1.e f+ -frot gl-vertex-3r
					3fv> fswap 1.e f- fswap gl-vertex-3r
			cell+
		loop drop
		gl-end
		gl-pop-matrix ;m
	overrides draw

end-class starfield

