require oof.fs

require utils.fs
require sdl.fs
require glsimple.fs
require vector.fs
require models.fs
require light.fs
require font.fs

\ static values ( configureable )
640	constant  window-width
480	constant  window-height
0	constant  window-fullscreen
45.e0	fconstant window-fovy
1.e-1	fconstant window-clipping-near
3.e2	fconstant window-clipping-far
1.e-2	fconstant player-movement-basic-speed
1.e-1	fconstant player-rotation-speed

100	constant  fps-update
1000	constant  beat-interval
0	constant  gl-multisamples

0 	constant  cube-number
0	constant  debug-mode

8	constant  presentation-slides

\ static calulated values ( do not change unless you're sure )
window-width 2 /	constant window-half-width
window-height 2 /	constant window-half-height

\ globals
variable mouse-x		\ n
variable mouse-y		\ n
variable mouse-buttons		\ n
variable mouse-shot-lock	\ n
variable num-keys		\ n
variable keystate		\ a
variable fps			\ n
variable kills			\ n

variable text-display		\ n
variable text-lock		\ n
variable flashlight-on		\ n
variable flashlight-lock	\ n
variable console-on		\ n
variable console-lock		\ n 
variable presentation-on	\ n
variable presentation-lock	\ n 
variable presentation-animation	\ n
variable presentation-number	\ n
variable enemies-on		\ n

variable next-beat		\ n

fvariable beat-state		\ r

fvariable player-x		\ r
fvariable player-y		\ r
fvariable player-z		\ r
fvariable player-pan		\ r
fvariable player-tilt		\ r

fvariable text-offset		\ r

require enemies.fs
require rockets.fs
require weapon.fs

require music/model.fs

: is-keydown ( n-key -- flag )
	keystate @ + c@ ;	\ get pointer address, add array index and return this value

require console.fs

: error-end ( f addr n -- )
	rot if
		type
		cr
		bye
	else
		2drop
	then ;

: scene-init ( -- )
	SDL_INIT_VIDEO sdl-init								\ start sdl		
	0<> s" Unable to initialize SDL" error-end

	\ SDL_GL_MULTISAMPLEBUFFERS cell allocate throw sdl-gl-get-attribute . ." samples"

	gl-multisamples if								\ multisamples
		SDL_GL_MULTISAMPLEBUFFERS 1 sdl-gl-set-attribute 0=
		SDL_GL_MULTISAMPLESAMPLES gl-multisamples sdl-gl-set-attribute 0=
		and 0 s" Unable to initialize Multisamples, please set gl-multisamples to 0" error-end
	then
	
	window-fullscreen if SDL_FULLSCREEN else 0 then					\ fullscreen
	SDL_OPENGL or
	window-width window-height rot 8 swap sdl-set-video-mode			\ create window
	0< s" Unable to set video mode" error-end

	GL_DEPTH_TEST gl-enable								\ setup depth-test
	GL_LEQUAL gl-depth-func

	GL_NORMALIZE gl-enable								\ make gl calculate the normals
	
	\ window-half-width window-half-height sdl-warp-mouse drop			\ set mouse to center of window

	light-init

	s" GLforth0" terminate-string NULL sdl-wm-set-caption 

	cube-number if 
		." You are displaying " cube-number dup dup * * dup . 6 * dup
		." cubes, that makes a total of " . ." quads"
		10000 > if ." ( glforth rocks )" then
		cr
	then ;

: scene-begin ( -- )
	\ 0.e0 5.e-1 0.e0 1.e0 gl-clear-color
	0.e0 0.e0 0.e0 1.e0 gl-clear-color
	GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT or gl-clear		\ clear depth & color buffer
	0 0 window-width window-height gl-viewport ;			\ only one fullscreen viewport

: scene-finalize ( -- )
	gl-flush							\ just flush & swap
	sdl-gl-swap-buffers ;

: scene-perspective ( -- )
	0 0 window-width window-height gl-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	window-fovy							\ field of view
	window-width n>f window-height n>f f/				\ aspect ratio
	window-clipping-near window-clipping-far			\ clipping ( range )
	glu-perspective							\ set up perspective projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix


: scene-ortho ( -- )
	0 0 window-width window-height gl-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	0.e0 window-width n>f 0.e0 window-height n>f glu-ortho		\ set up orthogonal projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix

: f@neg	( addr -- r )
	f@ fnegate ;

: 1.+ 1.e0 f+ ;
: 1.- 1.e0 f- ;

: light-flashlight-update
	1 player-x f@neg player-y f@neg player-z f@neg 1.e0 light-position

	player-pan f@neg deg-to-rad fdup fsin -1.e-1 frot fcos create-3fv
	dup 3 -1.e1 scale-nfv
	1 over 3fv> 1.e0 light-spot-direction
	free-v
	;

: gl-point ( addr-vector -- )
	gl-lines
		dup 3fv> 1.+ gl-vertex-3r
		dup 3fv> 1.- gl-vertex-3r
		dup 3fv> fswap 1.+ fswap gl-vertex-3r
		dup 3fv> fswap 1.- fswap gl-vertex-3r
		dup 3fv> frot 1.+ -frot gl-vertex-3r
		3fv> frot 1.- -frot gl-vertex-3r
	gl-end ;
		

: scene-draw-3d ( -- )
	cube-number if
		25.e-1 cube-number 2 / -1 * n>f f* fdup fdup gl-translate
		cube-number 0 u+do							\ x
			cube-number 0 u+do						\ y
				cube-number 0 u+do					\ z
					cube-draw
					0.e0 0.e0 25e-1 gl-translate			\ shift z
				loop
				0.e0 0.e0 25.e-1 cube-number -1 * n>f f* gl-translate	\ return z
				0.e0 25e-1 0.e0 gl-translate				\ shift y
			loop
			0.e0 25.e-1 cube-number -1 * n>f f* 0.e0 gl-translate		\ return y
			25.e-1 0.e0 0.e0 gl-translate					\ shift x
		loop
	else
		\ environment
		sky
		light-enable
		light-update
		light-flashlight-update
		
		1.e0 player-pan f@neg 18.e1 f+ deg-to-rad player-tilt f@neg deg-to-rad create-3fv
		dup spherical-to-cartesian
		1 over 3fv> 1.e0 light-spot-direction
		free-v

		world-draw

		rockets-draw
		
		\ presentation spot
		light-disable
		10.e0 0.e0 -10.e0 gl-translate
		-10.e0 -0.e0 10.e0 gl-translate
		\ enemies ( no lighting, fill-shaded )
		GL_BLEND gl-enable
		enemies-on @ if
			enemies-draw
		then
		light-enable

		
		\ additional stuff
		1.e0 fdup fdup fdup gl-color-4r
		1.e1 0.e0 -1.e1 gl-translate
		['] draw model-array map
		-1.e1 0.e0 1.e1 gl-translate

		\ starting pipe
		1.e0 fdup fdup 2.e-1 gl-color-4r
		24 pipe-draw

		GL_BLEND gl-disable
		light-disable

		\ nin-starwars style text
		text-display @ if
			-45.e0 1.e0 0.e0 0.e0 gl-rotate
			2.e0 gl-line-width
			0.e0 text-offset f@ world-offset- 1- n>f gl-translate
			75.e-2 fdup fdup gl-scale
			s" nin.txt" font-file
			1.e0 gl-line-width
		then
		-45.e0 1.e0 0.e0 0.e0 gl-rotate
		2.e0 gl-line-width
		-10.e0 20.e0 world-offset- 1- n>f gl-translate
		75.e-2 fdup fdup gl-scale
		console-draw
		1.e0 gl-line-width

	then
	;

: window-center ( -- n n )
	window-half-width window-half-height ;

: crosshairs

	gl-load-identity

        window-center n>f n>f fswap 0.e0 gl-translate
	mouse-buttons @ 1 and if 2.e0 fdup fdup gl-scale then

	1.e0 gl-line-width

	4 0 u+do

		mouse-buttons @ 0= if
	 		45.e0 0.e0 0.e0 1.e0 gl-rotate
		then

		1.e0 0.e0 0.e0 5.e-1 gl-color-4r
		gl-triangles
			3 dup	gl-vertex-2n
			10 20	gl-vertex-2n
			20 10	gl-vertex-2n
		gl-end

		mouse-buttons @ 0= if
	 		-45.e0 0.e0 0.e0 1.e0 gl-rotate
		then
		
		1.e0 1.e0 1.e0 gl-color-3r
		gl-line-loop
			3 dup	gl-vertex-2n
			10 20	gl-vertex-2n
			20 10	gl-vertex-2n
		gl-end
		90.e0 0.e0 0.e0 1.e0 gl-rotate
	loop

	gl-load-identity
	375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset
	;

: scene-draw-2d ( -- )
	375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset

	cube-number 0= if
		GL_BLEND gl-enable
		GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA gl-blend-func

		weapon-draw

		console-on @ false = if
		crosshairs
		then

		GL_BLEND gl-disable

		gl-push-matrix
			15.e0 window-height 15 - n>f 0.e0 gl-translate
			10.e0 fdup fdup gl-scale
			s" kills:" font-string kills @ font-number
		gl-pop-matrix
	then

	1.e0 1.e0 1.e0 gl-color-3r
	window-width 120 - n>f window-height 15 - n>f 0.e0 gl-translate
	10.e0 fdup fdup gl-scale
	s" fps=" font-string
	fps @ font-number

	;


: game-init ( -- )
	scene-init
	0 kills !
	0.e0 player-x f!					\ initialize player's position
	0.e0 player-y f!
	0.e0 player-z f!
	0.e0 player-pan f!
	0.e0 player-tilt f!
	15.e0 text-offset f!
	SDL_DISABLE sdl-show-cursor drop
	enemies-init
	rockets-init
	false mouse-shot-lock !
	false text-lock !
	false flashlight-on !
	false flashlight-lock !
	false console-on !
	false console-lock !
	false presentation-on !
	false presentation-lock !
	0 presentation-animation !
	0 presentation-number !
	false enemies-on !
	0 next-beat !
	;

: game-end ( -- )
	SDL_ENABLE sdl-show-cursor drop
	sdl-quit ;

: player-movement-speed ( -- r-speed )
	player-movement-basic-speed fps @ n>f f/ 1.e3 f* ;

: player-movement-vectors ( -- r-x r-z )
	player-movement-speed player-pan f@
		\ fdup f. ." , z: "		\ debug
	deg-to-rad 2fdup
	fcos f* -frot
	fsin f* -1.e0 f*
		\ 2fdup f.
		\ ." x: " f. 			\ debug
		\ cr	 			\ debug
	
	;

: player-change-position player-x f@ f+ player-x f! player-z f@ f+ player-z f! ; ( x z -- )

\ console commands
: reset-position 
	0.e0 player-x f!
	0.e0 player-y f!
	0.e0 player-z f!
	0.e0 player-pan f!
	0.e0 player-tilt f!
	;
: enemies-show true enemies-on ! ;
: enemies-hide false enemies-on ! ;

: game-update-navigation
	presentation-on @ invert if
		mouse-x @ window-half-width - n>f player-rotation-speed f* player-pan dup f@ f+ f!	\ mouse rotation
		mouse-y @ window-half-height - n>f player-rotation-speed f* player-tilt dup f@ f+ -9.e1 9.e1 fbind f!
	then

	mouse-buttons @ 1 and if	\ shoot management
		mouse-shot-lock @ false = if
			rocket-shoot
		then
		true mouse-shot-lock !
	else
		false mouse-shot-lock !
	then

	'f is-keydown if 		\ flashlight
		flashlight-lock @ false = if
			flashlight-on @ invert dup if
				1 1.e0 1.e0 1.e0 1.e0 light-diffuse
			else
				1 0.e0 0.e0 0.e0 1.e0 light-diffuse
			then
			flashlight-on !
		then
		true flashlight-lock !
	else
		false flashlight-lock !
	then

	9 is-keydown if			\ console
		console-lock @ false = if
			true console-on !
		then
		true console-lock !
	else
		false console-lock !
	then

	'p is-keydown if
		presentation-lock @ invert if
			presentation-on @ invert dup if
				-1 
			else
				1
			then
			presentation-animation !
			presentation-on !
		then	
		true presentation-lock !
	else
		'k is-keydown 'j is-keydown over or if
			presentation-lock @ invert if
				if -1 else 1 then
				presentation-number tuck @ +
				0 max presentation-slides 1- min
				swap !
			else
				drop
			then
			true presentation-lock !
		else
			false presentation-lock !
			drop
		then
	then

	\ presentation-animation @ dec. cr

	'a is-keydown if player-movement-vectors -1.e0 f* fswap player-change-position then	\ keyboard navigation
	'd is-keydown if player-movement-vectors fswap -1.e0 f* player-change-position then
	'e is-keydown if player-y f@ player-movement-speed f- player-y f! then
	'r is-keydown if player-y f@ player-movement-speed f+ player-y f! then
	
	cube-number if
		's is-keydown if player-z f@ player-movement-speed f- player-z f! then
		'w is-keydown if player-z f@ player-movement-speed f+ player-z f! then
	else
		's is-keydown if player-movement-vectors -1.e0 f* fswap -1.e0 f* fswap player-change-position then
		'w is-keydown if player-movement-vectors player-change-position then

		player-x world-offset- 1+ n>f world-offset+ 1- n>f fpbind
		player-z world-offset- 1+ n>f world-offset+ 1- n>f fpbind

		text-display @ if
			player-movement-speed 1.e1 f/ text-offset dup f@ f+ f!
		then

		't is-keydown if	\ text management
			text-lock @ false = if
				text-display @ if
					false text-display !
				else
					true text-display !
				then

				." display" text-display @ dec.
			then
				true text-lock !
		else
			false text-lock !
		then


	then

	;

: sprint-n ( number n-digits addr -- )
	over + swap
	0 u+do
		1- swap		\ addr number
		10 /mod 	\ addr digit remainder
		-rot		\ remainder addr digit
		'0 + over c!
	loop 2drop ;

: presentation-draw-3d
 
	gl-load-identity
	-1.e0 0.e0 -181.e-2 gl-translate

	presentation-animation @ abs 2 = if
		beat-state f@
		presentation-animation @ 0< if
			1.e0 fswap f-
		then
		120.e0 f* 0.e0 1.e0 0.e0 gl-rotate
	then

	1.e0 0.e0 0.e0  gl-translate

	1.e0 1.e0 1.e0 1.e0 gl-color-4r
	gl-quads
		-1.e0 -75.e-2 gl-vertex-2r
		 1.e0 -75.e-2 gl-vertex-2r
		 1.e0  75.e-2 gl-vertex-2r
		-1.e0  75.e-2 gl-vertex-2r
	gl-end

	0.e0 0.e0 0.e0 0.e0 gl-color-4r
	
	-95.e-2 65.e-2 1.e-2  gl-translate

	5.e-2 fdup fdup gl-scale
	s" presentation/00.txt" over 13 + presentation-number @ 2 rot sprint-n font-presentation-file
	;

: sign 0< if -1 else 1 then ;

: houses-show 
	0.e0 -7.e-1 20.e0 house heap-new set-position 
	-20.e0 -7.e-1 20.e0 house heap-new set-position ;

: game ( -- )
	game-init
	
	0				\ total frames
	sdl-get-ticks fps-update +	\ next tick
	0				\ frame counter
	dup fps !			\ store into framecounter

	window-half-width window-half-height sdl-warp-mouse	\ set mouse to center of window ( to make sure we are looking straight )
	begin
		\ save current keystate to old-keystate
		keystate @ old-keystate @ num-keys @ move

		sdl-pump-events						\ as we can't handle with structs, leave that to SDL
		num-keys sdl-get-key-state keystate !			\ get current keystates
		mouse-x mouse-y sdl-get-mouse-state mouse-buttons !	\ get current mouseposition and buttons
		window-half-width window-half-height sdl-warp-mouse	\ set mouse to center of window
		
		console-on @ false = if
			game-update-navigation
		else
			console-update
		then

		scene-begin
		scene-perspective
			cube-number if						\ special camera if we are in benchmark mode
				0.e0 0.e0 player-z f@ gl-translate
				player-pan f@ 0.e0 1.e0 0.e0 gl-rotate
				player-tilt f@ 1.e0 0.e0 0.e0 gl-rotate
			else							\ normal camera in player mode
				player-tilt f@ 1.e0 0.e0 0.e0 gl-rotate
				player-pan f@ 0.e0 1.e0 0.e0 gl-rotate
				player-x f@ player-y f@ player-z f@ gl-translate
			then
			scene-draw-3d
			presentation-animation @ dup presentation-on @ or swap -1 <> and if
				presentation-draw-3d
			else
				scene-ortho
				scene-draw-2d
			then
		scene-finalize


		\ fps handeling
		1+				\ increment frame counter
		over sdl-get-ticks < if		\ fps update necessary?
			enemies-update
			rockets-update
			rot over + -rot		\ add current counter to total fps counter
			1000 fps-update / *
			fps !			\ store frame counter into fps
			fps-update +		\ next tick
			0			\ reset frame counter
		then
		
		\ beats
		next-beat @ sdl-get-ticks - dup 0< if	\ check if a beat should occur
			next-beat dup @ beat-interval + swap !
			
			['] beat model-array map \ perform animation beat

			presentation-animation @ if	\ start animation
				presentation-animation @
				dup sign + dup abs 2 > if
					drop 0
				then
				presentation-animation !
			then

			drop beat-interval	\ "reset" animation

		then 
		
		\ animation ( float to next beat [0,1] )
		1.e0 n>f beat-interval n>f f/ f- 
		['] animate model-array map beat-state f!

		\ debug output
		debug-mode if
			1+ dup dec.						\ current frame
			s" playerposition " type
			player-x f@ f.						\ player-position
			player-z f@ f.
			s" rotation " type
			player-pan f@ f.
			player-tilt f@ f.
			cr
		then
		
		27 is-keydown						\ is escape pressed?
	until

	2drop ." You enjoyed " dup n>f dec. ." frames of GLforth in " sdl-get-ticks dup n>f dec. ." ms" cr
	." That makes an average of " 1.e3 f/ f/ f. ." FPS" cr

	game-end ;

\ uncomment if you have compiled in sdl & gl support (you most likely won't)
game
bye

