require oof.fs

require utils.fs
require sdl.fs
require glsimple.fs
require vector.fs
require font.fs
require models.fs
require light.fs

\ xbloome
1 	constant  pressure

\ static values
800	constant  window-width
600	constant  window-height
0	constant  window-fullscreen
45.e0	fconstant window-fovy
1.e-1	fconstant window-clipping-near
3.e2	fconstant window-clipping-far
1.e-2	fconstant player-movement-basic-speed
1.e-1	fconstant player-rotation-speed

100	constant  fps-update
1000	constant  beat-interval
4	constant  gl-multisamples

0 	constant  cube-number
0	constant  debug-mode

\ static calulated values ( do not change unless you're sure )
window-width 2 /	constant window-half-width
window-height 2 /	constant window-half-height

\ globals
variable mouse-x		\ n
variable mouse-y		\ n
variable mouse-buttons		\ n
variable mouse-shot-lock	\ n
variable keystate		\ a
variable fps			\ n
variable kills			\ n

variable text-display		\ n
variable text-lock		\ n

variable next-beat		\ n

fvariable player-x		\ r
fvariable player-y		\ r
fvariable player-z		\ r
fvariable player-pan		\ r
fvariable player-tilt		\ r

fvariable text-offset		\ r

require enemies.fs
require rockets.fs
require weapon.fs
require console.fs

require music/model.fs

: is-keydown ( n-key -- flag )
	keystate @ + c@ ;	\ get pointer adress, add array index and return this value

: error-end ( f addr n -- )
	rot if
		type
		cr
		bye
	else
		2drop
	then ;

: origin
	2.e0 gl-line-width
	gl-lines
		1.e0 0.e0 0.e0 gl-color-3r
		0 0 0 gl-vertex-3n
		1 0 0 gl-vertex-3n

		0.e0 1.e0 0.e0 gl-color-3r
		0 0 0 gl-vertex-3n
		0 1 0 gl-vertex-3n

		5.e-1 5.e-1 1.e0 gl-color-3r
		0 0 0 gl-vertex-3n
		0 0 1 gl-vertex-3n
	gl-end
	1.e0 gl-line-width ;


: scene-init ( -- )
	SDL_INIT_VIDEO sdl-init								\ start sdl		
	0<> s" Unable to initialize SDL" error-end

	\ SDL_GL_MULTISAMPLEBUFFERS cell allocate throw sdl-gl-get-attribute . ." samples"

	gl-multisamples if								\ multisamples
		SDL_GL_MULTISAMPLEBUFFERS 1 sdl-gl-set-attribute 0=
		SDL_GL_MULTISAMPLESAMPLES gl-multisamples sdl-gl-set-attribute 0=
		and 0 s" Unable to initialize Multisamples, please set gl-multisamples to 0" error-end
	then
	
	window-fullscreen if SDL_FULLSCREEN else 0 then					\ fullscreen
	SDL_OPENGL or
	window-width window-height rot 8 swap sdl-set-video-mode			\ create window
	0< s" Unable to set video mode" error-end

	GL_DEPTH_TEST gl-enable								\ setup depth-test
	GL_LEQUAL gl-depth-func

	GL_NORMALIZE gl-enable								\ make gl calculate the normals
	
	\ window-half-width window-half-height sdl-warp-mouse drop			\ set mouse to center of window

	light-init

	s" GLforth0" terminate-string NULL sdl-wm-set-caption 

	cube-number if 
		." You are displaying " cube-number dup dup * * dup . 6 * dup
		." cubes, that makes a total of " . ." quads"
		10000 > if ." ( glforth rocks )" then
		cr
	then ;

: scene-begin ( -- )
	\ 0.e0 5.e-1 0.e0 1.e0 gl-clear-color
	0.e0 0.e0 0.e0 1.e0 gl-clear-color
	GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT or gl-clear		\ clear depth & color buffer
	0 0 window-width window-height gl-viewport ;			\ only one fullscreen viewport

: scene-finalize
	gl-flush							\ just flush & swap
	sdl-gl-swap-buffers ;

: scene-perspective ( -- )
	0 0 window-width window-height gl-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	window-fovy							\ field of view
	window-width n>f window-height n>f f/				\ aspect ratio
	window-clipping-near window-clipping-far			\ clipping ( range )
	glu-perspective							\ set up perspective projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix


: scene-ortho ( -- )
	0 0 window-width window-height gl-viewport
	GL_PROJECTION gl-matrix-mode gl-load-identity			\ reset projection matrix
	
	0.e0 window-width n>f 0.e0 window-height n>f glu-ortho		\ set up orthogonal projection matrix

	GL_MODELVIEW gl-matrix-mode gl-load-identity ;			\ reset modelview matrix

: scene-draw-3d ( -- )
	cube-number if
		25.e-1 cube-number 2 / -1 * n>f f* fdup fdup gl-translate
		cube-number 0 u+do							\ x
			cube-number 0 u+do						\ y
				cube-number 0 u+do					\ z
					cube-draw
					0.e0 0.e0 25e-1 gl-translate			\ shift z
				loop
				0.e0 0.e0 25.e-1 cube-number -1 * n>f f* gl-translate	\ return z
				0.e0 25e-1 0.e0 gl-translate				\ shift y
			loop
			0.e0 25.e-1 cube-number -1 * n>f f* 0.e0 gl-translate		\ return y
			25.e-1 0.e0 0.e0 gl-translate					\ shift x
		loop
	else
		\ light-enable
		\ light-update
		pressure if 
			origin

			0.e 0.e -1.e1 gl-translate
			origin
			0.e 0.e  1.e1 gl-translate

			sky
			world-draw
		then

	
		1.e0 1.e0 1.e0 gl-color-3r

		['] draw model-array map
		GL_BLEND gl-disable
		light-disable

		\ nin-starwars style text
		text-display @ if
			-45.e0 1.e0 0.e0 0.e0 gl-rotate
			2.e0 gl-line-width
			0.e0 text-offset f@ world-offset- 1- n>f gl-translate
			75.e-2 fdup fdup gl-scale
			s" nin.txt" font-file
			1.e0 gl-line-width
		then
		-45.e0 1.e0 0.e0 0.e0 gl-rotate
		2.e0 gl-line-width
		0.e0 20.e0 world-offset- 1- n>f gl-translate
		75.e-2 fdup fdup gl-scale
		\ console-draw
		1.e0 gl-line-width

	then
	;

: window-center ( -- n n )
	window-half-width window-half-height ;

: crosshairs

	gl-load-identity

        window-center n>f n>f fswap 0.e0 gl-translate
	mouse-buttons @ 1 and if 2.e0 fdup fdup gl-scale then

	1.e0 gl-line-width

	4 0 u+do

		mouse-buttons @ 0= if
	 		45.e0 0.e0 0.e0 1.e0 gl-rotate
		then

		1.e0 0.e0 0.e0 5.e-1 gl-color-4r
		gl-triangles
			3 dup	gl-vertex-2n
			10 20	gl-vertex-2n
			20 10	gl-vertex-2n
		gl-end

		mouse-buttons @ 0= if
	 		-45.e0 0.e0 0.e0 1.e0 gl-rotate
		then
		
		1.e0 1.e0 1.e0 gl-color-3r
		gl-line-loop
			3 dup	gl-vertex-2n
			10 20	gl-vertex-2n
			20 10	gl-vertex-2n
		gl-end
		90.e0 0.e0 0.e0 1.e0 gl-rotate
	loop

	gl-load-identity
	375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset
	;

: scene-draw-2d ( -- )
	375.e-3 fdup 0.e0 gl-translate	\ pixel-correction offset

	cube-number 0= if
		GL_BLEND gl-enable
		GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA gl-blend-func

		weapon-draw

		\ crosshairs

		GL_BLEND gl-disable

		gl-push-matrix
			15.e0 window-height 15 - n>f 0.e0 gl-translate
			10.e0 fdup fdup gl-scale
			s" kills:" font-string kills @ font-number
		gl-pop-matrix
	then

	1.e0 1.e0 1.e0 gl-color-3r
	window-width 120 - n>f window-height 15 - n>f 0.e0 gl-translate
	10.e0 fdup fdup gl-scale
	s" fps=" font-string
	fps @ font-number

	;


: game-init ( -- )
	scene-init
	0 kills !
	0.e0 player-x f!					\ initialize player's position
	0.e0 player-y f!
	-1.e1 player-z f!
	0.e0 player-pan f!
	0.e0 player-tilt f!
	15.e0 text-offset f!
	SDL_DISABLE sdl-show-cursor drop
	enemies-init
	rockets-init
	false mouse-shot-lock !
	false text-lock !
	0 next-beat !

	pressure if
		house heap-new 
		0.e0 0.e0 -1.e1 set-position
	else
		starfield heap-new
		0.e 0.e -1.e2 set-position
	then

	;

: game-end ( -- )
	SDL_ENABLE sdl-show-cursor drop
	sdl-quit ;

: player-movement-speed ( -- r-speed )
	player-movement-basic-speed fps @ n>f f/ 1.e3 f* ;

: player-movement-vectors ( -- r-x r-z )
	player-movement-speed player-pan f@
		\ fdup f. ." , z: "		\ debug
	deg-to-rad 2fdup
	fcos f* -frot
	fsin f* -1.e0 f*
		\ 2fdup f.
		\ ." x: " f. 			\ debug
		\ cr	 			\ debug
	
	;

: player-change-position player-x f@ f+ player-x f! player-z f@ f+ player-z f! ; ( x z -- )

: game-update-navigation
	mouse-x @ window-half-width - n>f player-rotation-speed f* player-pan dup f@ f+ f!	\ mouse rotation
	mouse-y @ window-half-height - n>f player-rotation-speed f* player-tilt dup f@ f+ -9.e1 9.e1 fbind f!

	mouse-buttons @ 1 and if	\ shoot management
		mouse-shot-lock @ false = if
			rocket-shoot
		then
		true mouse-shot-lock !
	else
		false mouse-shot-lock !
	then

	'a is-keydown if player-movement-vectors -1.e0 f* fswap player-change-position then	\ keyboard navigation
	'd is-keydown if player-movement-vectors fswap -1.e0 f* player-change-position then
	'f is-keydown if player-y f@ player-movement-speed f- player-y f! then
	'r is-keydown if player-y f@ player-movement-speed f+ player-y f! then

	\ player-x f@ f>n dec. player-z f@ f>n dec. cr
	
	cube-number if
		's is-keydown if player-z f@ player-movement-speed f- player-z f! then
		'w is-keydown if player-z f@ player-movement-speed f+ player-z f! then
	else
		's is-keydown if player-movement-vectors -1.e0 f* fswap -1.e0 f* fswap player-change-position then
		'w is-keydown if player-movement-vectors player-change-position then

		player-x world-offset- 1+ n>f world-offset+ 1- n>f fpbind
		player-z world-offset- 1+ n>f world-offset+ 1- n>f fpbind

		text-display @ if
			player-movement-speed 1.e1 f/ text-offset dup f@ f+ f!
		then

		't is-keydown if	\ text management
			text-lock @ false = if
				text-display @ if
					false text-display !
				else
					true text-display !
				then

				." display" text-display @ dec.
			then
				true text-lock !
		else
			false text-lock !
		then


	then

	;

: game ( -- )
	game-init
	
	0				\ total frames
	sdl-get-ticks fps-update +	\ next tick
	0				\ frame counter
	dup fps !			\ store into framecounter

	begin
		sdl-pump-events						\ as we can't handle with structs, leave that to SDL
		0 sdl-get-key-state keystate !				\ get current keystates
		mouse-x mouse-y sdl-get-mouse-state mouse-buttons !	\ get current mouseposition and buttons
		window-half-width window-half-height sdl-warp-mouse	\ set mouse to center of window
		game-update-navigation

		scene-begin
		scene-perspective
			cube-number if						\ special camera if we are in benchmark mode
				0.e0 0.e0 player-z f@ gl-translate
				player-pan f@ 0.e0 1.e0 0.e0 gl-rotate
				player-tilt f@ 1.e0 0.e0 0.e0 gl-rotate
			else							\ normal camera in player mode
				player-tilt f@ 1.e0 0.e0 0.e0 gl-rotate
				player-pan f@ 0.e0 1.e0 0.e0 gl-rotate
				player-x f@ player-y f@ player-z f@ gl-translate
			then
			scene-draw-3d
		scene-ortho
			scene-draw-2d
		scene-finalize


		\ fps handeling
		1+				\ increment frame counter
		over sdl-get-ticks < if		\ fps update necessary?
			enemies-update
			rockets-update
			rot over + -rot		\ add current counter to total fps counter
			1000 fps-update / *
			fps !			\ store frame counter into fps
			fps-update +		\ next tick
			0			\ reset frame counter
		then
		
		\ beats
		next-beat @ sdl-get-ticks - dup 0< if	\ check if a beat should occur
			next-beat dup @ beat-interval + swap !
			
			['] beat model-array map \ perform animation beat

			drop beat-interval	\ "reset" animation

		then 
		
		\ animation ( float to next beat [0,1] )
		1.e0 n>f beat-interval n>f f/ f- 
		['] animate model-array map fdrop

		\ debug output
		debug-mode if
			1+ dup dec.						\ current frame
			s" playerposition " type
			player-x f@ f.						\ player-position
			player-z f@ f.
			s" rotation " type
			player-pan f@ f.
			player-tilt f@ f.
			cr
		then
		
		27 is-keydown						\ is escape pressed?
	until

	2drop ." You enjoyed " dup n>f dec. ." frames of GLforth in " sdl-get-ticks dup n>f dec. ." ms" cr
	." That makes an average of " 1.e3 f/ f/ f. ." FPS" cr

	game-end ;

\ uncomment if you have compiled in sdl & gl support (you most likely won't)
game
bye

