\ rockets updateing and drawing management
\ (c) by Gerald Wodni 2008

4	constant rockets-light-offset
4	constant rockets-number
8	constant rocket-segments

5.e-1	fconstant rocket-length-scale
3.e-1	fconstant rocket-diameter-scale

15.e0 2.e0 fsqrt f* fsquare	fconstant rocket-max-distance
2.e0 fsquare			fconstant rocket-destruction-distance

variable rockets

object class rocket
	cell var pos
	cell var movement
	cell var pan
	cell var tilt
	cell var visible
	cell var num
	method m_pos
	method m_movement
	method m_pan
	method m_tilt
	method m_visible
	method m_number
	method light-init
	method light-update
	method move
	method draw
how:
	: init		( x y z -- )
		create-3fv pos !
		true visible !
		0.e0 0.e0 -1.e-1 create-3fv movement !
		;

	: m_pos		( -- addr )	\ access functions 
		pos ;
	: m_movement	( -- addr )
		movement ;
	: m_pan		( -- addr )
		pan ;
	: m_tilt	( -- addr )
		tilt ;
	: m_visible	( -- addr )
		visible ;
	: m_number	( -- addr )
		num ;

	: light-init
		num @ rockets-light-offset +
		dup 1.e0 1.e0 0.e0 1.e0 light-diffuse
		dup 0.e0 fdup fdup 1.e0 light-ambient
		dup 0.e0 fdup fdup 1.e0 light-specular
		dup 180.e0 light-spot-cutoff		\ pointlight
		dup 12.e0 light-spot-exponent
		dup 0.e0 1.e0 1.e-1 light-attenuation
		0.e0 -1.e0 0.e0 0.e0 light-spot-direction
		;

	: light-update
		num @ rockets-light-offset +
		dup light-get visible @ if gl-enable else gl-disable then
		dup pos @ 3fv> 1.e0 light-position
		0.e0 -1.e0 0.e0 1.e0 light-spot-direction
		;

	: move
		pos @ movement @ +3fv ;

	: draw		( -- )
		visible @ if
			gl-push-matrix
			pos @ 3fv> gl-translate
			pan sf@ gl-rotate-y
			tilt sf@ gl-rotate-x
			rocket-diameter-scale fdup rocket-length-scale gl-scale
			rocket-segments rocket-draw
			gl-pop-matrix
		then ;
class;

: rockets-init	( -- )
	rockets-number dup cells allocate throw tuck rockets !	\ allocate array
	0 u+do
		i 2* 2* n>f 1.e0 1.e1 rocket new over !
		i over @	>o
				rocket m_number !
				rocket light-init 
				false rocket m_visible !
				o>
		cell +
	loop drop ;

: rocket-enemies-collission	( addr-v -- n-flag )
	enemies @ enemies-number 0 u+do
		dup @ >o over enemy m_pos @ 
		3 distance-nfv dup 3 squared-sum-nfv freet rocket-destruction-distance
		f< enemy m_dying @ 0= and if	\ object hit, destroy rocket and start dying
			0.e0 0.e0 1.e0 1.e0 enemy m_line-color @ >4fv
			true enemy m_dying !
			kills dup @ 1+ swap !
			o>
			false rocket m_visible !
		else
			o>
		then
		cell +
	loop drop ;

: rockets-update ( -- )
	\ rocket-enemies-collission
	rockets @ rockets-number 0 u+do
		dup @	>o
			rocket m_visible @ if
				rocket m_pos @ 3 squared-sum-nfv rocket-max-distance f< if	\ check if rocket is within our arena
					rocket move
					rocket pos @
						rocket-enemies-collission
					drop
				else
					false rocket m_visible !
				then
			then
			o>
		cell +
	loop drop ;

: rockets-draw	( -- )
	rockets @ rockets-number 0 u+do
		dup @ >o rocket light-update rocket draw o>
		cell +
	loop drop ;

: rocket-shoot	( -- )
	rockets @ rockets-number 0 u+do
		dup @	>o rocket m_visible @ 0= if	\ if rocket is not visible, activate it and leave loop
				true rocket m_visible !
				player-x f@ fnegate player-y f@ fnegate player-z f@ fnegate rocket m_pos @ >3fv \ start position
				
				player-pan f@ deg-to-rad fdup fsin fswap fcos fnegate 		\ x & z ( from pan )
				player-tilt dup f@ deg-to-rad fcos ftuck f* -frot f*		\ scale x & z by tilt
				f@ deg-to-rad fsin fnegate frot					\ y ( from tilt )
				rocket m_movement @ dup >3fv 3.e-1 3 scale-nfv			\ scale total movement

				player-pan f@ fnegate rocket m_pan sf!				\ store player's pan as rocket's pan
				player-tilt f@ fnegate rocket m_tilt sf!			\ same for tilt
				o>

				leave
			then o>				\ make sure return stack is left okay
		cell +
	loop drop ;

