\ music model interface
\ (c) by Gerald Wodni 2008

require objects.fs
require array.fs

array heap-new constant model-array

\ model class is the basic class for all music-based models
\ and handles all instantiated models
object class

	m: this model-array add ;m
	overrides construct

	m: this model-array remove ;m
	method destruct

	m: ." model-beat" cr ;m
	method beat

	m: ." model-animate" cr ;m
	method animate ( r1 -- r1 )

	m: ." model-draw" cr ;m
	method draw

	m: ." model-here" cr ;m
	overrides print

end-class model

model class

	m: this [parent] construct ;m
	overrides construct

	m: ." blueroom-here" cr ;m
	overrides print

	m: ." blueroom-draw" cr ;m
	overrides draw

end-class blueroom

require starfield.fs 
require house.fs
require vent.fs


vent heap-new drop
\ house heap-new drop

\ model heap-new constant model-inst
\ blueroom heap-new constant blueroom-inst


