\ new vector functions (placed in memory instead of stack)
\ (c) by Gerald Wodni 2008

: create-v	( n -- addr )
	dup cells allocate throw over cells + ;	\ allocate n-cells and set pointer to the end ( actually end+1 )

: >nnv	( n1 n2 ... nn addr-v n-number -- addr-v )
	swap 0 u+do
		1 cells - tuck !
	loop ;

: >2nv 2 >nnv ;
: >3nv 3 >nnv ;
: >4nv 4 >nnv ;

: nnv>	( addr-v n-number -- n1 n2 ... nn )
	0 u+do
		@
		1 cells +
	loop drop ;

: 2nv> 2 nnv> ;
: 3nv> 3 nnv> ;
: 4nv> 4 nnv> ;

: create-nnv	( n1 n2 ... nn n-number -- addr )	\ create a n-dimensional vector and return address
	create-v
	>nnv ;

: create-2nv	( n-x n-y -- addr )
	2 create-nnv ;
: create-3nv	( n-x n-y n-z -- addr )
	3 create-nnv ;
: create-4nv	( n-x n-y n-z n-a -- addr )
	4 create-nnv ;



: create-v	( n -- addr )
	cells allocate throw ;	\ allocate n-cells and set pointer to the end ( actually end+1 )

: >nfv		( r1 r2 ... rn addr-v n-number -- addr-v )	
	swap over cells + swap	\ set address pointer to end of array
	0 u+do
		cell - dup sf!
	loop drop ;

: >2fv 2 >nfv ;
: >3fv 3 >nfv ;
: >4fv 4 >nfv ;

: nfv>		( addr-v n-number -- r1 r2 ... rn )	
	0 u+do
		dup sf@
		cell +
	loop drop ;

: 2fv> 2 nfv> ;
: 3fv> 3 nfv> ;
: 4fv> 4 nfv> ;



: create-nfv	( r1 r2 ... rn n-number -- addr )
	dup create-v dup rot
	>nfv ;

: create-2fv	( r-x r-y -- addr )
	2 create-nfv ;
: create-3fv	( r-x r-y r-z -- addr )
	3 create-nfv ;
: create-4fv	( r-x r-y r-z r-a -- addr )
	4 create-nfv ;

: free-v 	( addr-v -- )
	free throw ;

	

: nnv. 	( addr-v n-number -- )		\ prints the vector
	0 u+do
		dup @ dec.
		1 cells +
	loop drop ;

: 2nv.	2 nnv. ;
: 3nv.	3 nnv. ;
: 4nv.	4 nnv. ;

: nfv.	( addr-v n-number -- )		\ prints the vector
	0 u+do
		dup sf@ f.
		1 cells +
	loop drop ;

: 2fv.	2 nfv. ;
: 3fv.	3 nfv. ;
: 4fv.	4 nfv. ;

: 2+	( n1 n2 n3 -- n1+n3 n2+n3 )
	tuck + -rot + swap ;

: f2+	( r1 r2 r3 -- r1+r3 r2+r3 )
	ftuck f+ -frot f+ fswap ;

: f1/	( r1 -- r2 )
	1.e0 fswap f/ ;

: +nnv	( addr-v1 addr-v2 n-number -- addr-v1 addr-v2[+v1] )
	0 2over 2swap u+do	\ duplicate the original vectors
		2dup 2@ +	\ now add the 2 values
		over !		\ store result in the 2nd vector
		1 cells 2+	\ increment both to the next cell
	loop 2drop ;

: +2nv	2 +nnv ;
: +3nv	3 +nnv ;
: +4nv	4 +nnv ;

: +nfv	( addr-v1 addr-v2 n-number -- )
	0 u+do
		2dup sf@ sf@ f+	\ now add the 2 values
		over sf!	\ store result in the 2nd vector
		1 cells 2+	\ increment both to the next cell
	loop 2drop ;

: +2fv	2 +nfv ;
: +3fv	3 +nfv ;
: +4fv	4 +nfv ;

: nnv+	( addr-v1 addr-v2 n-number -- addr-v1[+v2] addr-v2 )
	-rot swap rot +nnv ;

: 2nv+	2 nnv+ ;
: 3nv+	3 nnv+ ;
: 4nv+	4 nnv+ ;

: nfv+	( addr-v1 addr-v2 n-number -- )
	-rot swap rot +nfv ;

: 2fv+	2 nfv+ ;
: 3fv+	3 nfv+ ;
: 4fv+	4 nfv+ ;

: spherical-to-cartesian ( addr-r-pan-tilt -- )
	dup 3fv> fcos fswap fsin f* f*	\ x
	dup 3fv> fsin fnip f*		\ y
	dup 3fv> fcos fswap fcos f* f*	\ z
	>3fv ;

: set-component-fv	( addr-v n-number r-value -- )
	cells + sf! ;

: component-sum-nnv 	( addr-v n-number -- addr-n n-sum )
	0 swap 0 u+do
		over @ +
	loop ;

: mean-nnv		( addr-v n-number -- addr-n n-mean )
	dup -rot component-sum-nnv rot / ;

: squared-sum-nnv	( addr-v n-number -- addr-v n-squared-length )
	0 swap 0 u+do
		over i cells + @ square + 
	loop ;

: length-nnv ( addr-v n-number -- addr-v n-length )
	squared-sum-nnv sqrt ;

: squared-sum-nfv	( addr-v n-number -- r-squared-length )
	0 0.e0 u+do
		dup sf@ fsquare f+	\ add squared sum
		cell +	 		\ increment pointer
	loop drop ;

: length-nfv		( addr-v n-number -- addr-v r-length )
	squared-sum-nfv fsqrt ;


: scale-nfv		( addr-v n-number r-scale -- )
	0 u+do
		dup fdup sf@ f* dup sf!
		cell +
	loop drop fdrop ;

: normalize-nfv		( addr-v1 n-number -- addr-v )
	2dup length-nfv f1/ scale-nfv ;

: copy-nfv		( addr-v1 n-number -- addr-v )
	tuck nfv> create-nfv ;

: distance-nfv		( addr-v1 addr-v2 n-number -- addr-v )
	>r r@ tuck copy-nfv swap
	0 u+do
		dup sf@ over sf@ f- dup sf!	\ calculate difference
		cell 2+				\ increment both pointers
	loop r> cells - nip ;			\ calulate array-start and drop v1

