\ Array - Manages an Array (includes function-mapping)
\ (c) by Gerald Wodni

require objects.fs

100 constant out-of-bounds-exception

: nmove ( addr-from addr-to ucount -- )	\ behaves like move except that its ucount is specified in cells
	cells move ;

object class
	cell% inst-var array-start
	cell% inst-var array-length

	m:	0 array-start ! .\" \narray-construct\n"
		0 array-length ! ;m
	overrides construct	( -- )

	m:	array-start @ free throw ;m
	method destruct		( -- )

	m:	array-length dup @ dup >r 1+ dup rot ! cells
		array-start dup @ rot resize throw dup rot !
		r> cells + ! ;m
	method add		( n-value -- )

	m:	array-length ! array-start dup @ array-length @ resize throw swap ! ;m
	method resize-array	( n-length -- )

	m:	array-length @ dup >r 2dup >= abs out-of-bounds-exception * throw
		over - 1- swap cells array-start @ + dup cell+ swap rot
		nmove r> 1- this resize-array ;m
	method remove-index	( n-index -- )

	m:	array-start @ array-length @ 0 u+do
			2dup @ = if \ value matches current item, remove it
				i this remove-index
				leave
			then
			cell+
		loop drop ;m
	method remove		( n-value -- )

	m:	cells array-start @ + @ ;m
	method item-index	( n-index -- addr-item )

	m:	{ xt } array-start @ array-length @ 0 u+do
			dup @ xt execute
			cell+
		loop drop ;m
	method map		( xt-function -- )

	m:	cr array-start @ array-length @ 0 u+do
			i dec. ." ( " dup dec. ." ) = " dup @ dec. cr
			cell+
		loop drop ;m
	overrides print		( -- )

end-class array


variable array-instance

: array-demo
	array heap-new array-instance !

	6 1 u+do
		i 11 * array-instance @ add
	loop 

	array-instance @ print

	." -- " cr

	1 array-instance @ remove-index 
	44 array-instance @ remove
	33 array-instance @ remove
	12 array-instance @ remove

	array-instance @ print

	array-instance @ destruct
	;

