\ Loads the libraries needed by GLforth
\ (c) by Gerald Wodni 2008

require game.fs

: load-lib ( n addr n -- n )
	2dup type ."  "
	open-lib if	\ check if library loaded successfully
		." ok"
	else
		." failed"
		1+
	then
	cr ;

: game-load
	." Loading GLforth components..." cr

	0	\ error-counter
	s" libSDL.so" load-lib
	s" libGL.so"  load-lib
	s" libGLU.so" load-lib

	if 
		." loading failed, please install the missing libraries" cr
		bye
	else
		." everything loaded great, let's start the game" cr
		game
	then ;

game-load
bye
