\ require glsimple.fs
require random.fs

200	constant star-number
200	constant star-seed
10	constant star-size
star-seed 2 / -1 *	constant star-offset-
10	constant star-y-offset
30 constant  world-sections
world-sections 2 / -1 *  constant world-offset-
world-offset- world-sections + constant world-offset+

: world-field { x z }
	0.e0 1.e0 0.e0 gl-normal
	gl-quads
		x	-1	z	gl-vertex-3n
		x 1+	-1	z	gl-vertex-3n
		x 1+	-1	z 1+	gl-vertex-3n
		x	-1	z 1+	gl-vertex-3n
	gl-end
	;


: sky
	1.e0 fdup fdup gl-color-3r
	42 seed !
	gl-triangles
		star-number 0 u+do
			star-seed random star-offset- + 	\ x
			star-seed random star-y-offset +	\ y
			star-seed random star-offset- + 	\ z
			
			3dup 				gl-vertex-3n		\ first
			3dup 0 0 1 vector-add-3n	gl-vertex-3n
			1 0 1 vector-add-3n		gl-vertex-3n
		loop 
	gl-end
 	;

\ 4--3  3 = end-point
\ |  |
\ 1--2  1 = start-point

: vector-quad-6n { n-x n-y n-z n-x2 n-y2 n-z2 -- }
	n-x	n-y	n-z	gl-vertex-3n
	n-x2	n-y	n-z2	gl-vertex-3n
	n-x2	n-y 1-	n-z2	gl-vertex-3n
	n-x	n-y 1-	n-z	gl-vertex-3n
	;

: world-border ( n-incrx n-incry n-incrz n-startx n-starty n-startz n-segments -- )
	0 u+do
		6dup vector-add-3n	\ calulate next incrementation step
		6dup vector-quad-6n	\ render quad
		3nip			\ drop old step
	loop
	6drop
	;

: world-borders
	gl-quads
		7.e-1 fdup fdup gl-color-3r				\ front
		0.e0 0.e0 1.e0 gl-normal
		-1 0 0 world-offset+ 0 world-offset- world-sections world-border

		0.e0 0.e0 7.e-1 gl-color-3r				\ back
		0.e0 0.e0 -1.e0 gl-normal
		-1 0 0 world-offset+ 0 world-offset+ world-sections world-border

		7.e-1 0.e0 0.e0 gl-color-3r				\ left
		1.e0 0.e0 0.e0 gl-normal
		0 0 -1 world-offset- 0 world-offset+ world-sections world-border
		
		0.e0 7.e-1 0.e0 gl-color-3r				\ right
		-1.e0 0.e0 0.e0 gl-normal
		0 0 -1 world-offset+ 0 world-offset+ world-sections world-border
	gl-end
	;

: world-draw	
	world-borders

	0.e0 1.e0 0.e0 gl-normal
	world-sections dup 2 / -1 * 1-
	swap 0 u+do
		1+
		world-sections dup 2 / -1 * 1-
		swap 0 u+do
			1+
			2dup + 2 mod if 2.e-1 else 5.e-1 then
			fdup fdup gl-color-3r
		
			2dup
			world-field
		loop drop
	loop drop
	;
