\ Draw primitives
\ (c) by Gerald Wodni 2008
require gl.fs

: cube-draw
	gl_quads gl-begin
		1.e0 1.e0 0.e0 1.e0 gl-color-4r	\ front
		0.e0 0.e0 1.e0 gl-normal 
		-1 -1  1 gl-vertex-3n
		 1 -1  1 gl-vertex-3n
		 1  1  1 gl-vertex-3n
		-1  1  1 gl-vertex-3n
		0.e0 0.e0 1.e0 1.e0 gl-color-4r	\ back
		0.e0 0.e0 -1.e0 gl-normal 
		-1 -1 -1 gl-vertex-3n
		 1 -1 -1 gl-vertex-3n
		 1  1 -1 gl-vertex-3n
		-1  1 -1 gl-vertex-3n
		1.e0 0.e0 0.e0 1.e0 gl-color-4r	\ left
		-1.e0 0.e0 0.e0 gl-normal 
		-1 -1 -1 gl-vertex-3n
		-1  1 -1 gl-vertex-3n
		-1  1  1 gl-vertex-3n
		-1 -1  1 gl-vertex-3n
		0.e0 1.e0 0.e0 1.e0 gl-color-4r	\ right
		1.e0 0.e0 1.e0 gl-normal 
		 1 -1 -1 gl-vertex-3n
		 1  1 -1 gl-vertex-3n
		 1  1  1 gl-vertex-3n
		 1 -1  1 gl-vertex-3n
		1.e0 1.e0 1.e0 1.e0 gl-color-4r	\ top
		0.e0 1.e0 1.e0 gl-normal 
		-1  1 -1 gl-vertex-3n
		 1  1 -1 gl-vertex-3n
		 1  1  1 gl-vertex-3n
		-1  1  1 gl-vertex-3n
		1.e0 0.e0 1.e0 1.e0 gl-color-4r	\ bottom
		0.e0 -1.e0 1.e0 gl-normal 
		-1 -1 -1 gl-vertex-3n
		 1 -1 -1 gl-vertex-3n
		 1 -1  1 gl-vertex-3n
		-1 -1  1 gl-vertex-3n
	gl-end ;

: get-sequence ( r-start r-increment n-segments -- r1 ... rN )
	1- 0 u+do
		2fdup f+ fswap
	loop
	fdrop ;

: circle-get-angles ( n-segments -- r1 ... rN )
	0.e0		\ angle-starting-value
	dup 2pi n>f f/	\ get angle step width
	get-sequence	\ calculate sequence
	;
	
: angle-to-xy ( r-angle -- r-x r-y )
	fdup fsin fswap fcos ;

: circle-draw ( n-segments -- )
	dup circle-get-angles
	0.e0 0.e0 1.e0 gl-normal
	gl_polygon gl-begin
		0 u+do
			angle-to-xy gl-vertex-2r
		loop
	gl-end
	;

: cone-draw ( n-segments -- )
	dup circle-get-angles
	gl-triangle-fan
		0 0 -1 gl-vertex-3n
		2pi
		1+ 0 u+do
			angle-to-xy 2fdup 5.e-1 gl-normal
			1.e0 gl-vertex-3r
		loop
	gl-end ;

: pipe-draw ( n-segments -- )
	dup circle-get-angles
	gl-quads
		2pi	\ starts at 2pi, not at 0.0, otherwise mean-value is futile
	 	0 u+do
			2fdup fmean-2 fdup fsin fswap fcos 0.e0 gl-normal
			angle-to-xy 2fdup -1.e0 gl-vertex-3r
			1.e0 gl-vertex-3r
			fdup angle-to-xy 2fdup 1.e0 gl-vertex-3r
			-1.e0 gl-vertex-3r
		loop
		fdrop
	gl-end ;

: rocket-draw ( n-segments -- )
	dup
	1.e0 0.e0 0.e0 1.e0 gl-color-4r
	0.e0 0.e0 -2.e0 gl-translate
	cone-draw
	0.e0 0.e0 2.e0 gl-translate
	
	dup
	1.e0 1.e0 1.e0 1.e0 gl-color-4r
	pipe-draw
	
	1.e0 1.e0 0.e0 1.e0 gl-color-4r
	0.e0 0.e0 1.e0 gl-translate
	circle-draw
	0.e0 0.e0 -1.e0 gl-translate ;

: cylinder-draw ( n-segments -- )
	\ 5 circle-draw
	\ 5 pipe-draw
	;

