variable max-lights
variable p

: light-vector-4n ( n1 n2 n3 n4 -- a )
	4 cells allocate throw 3 cells +	\ allocate 4 cells
	tuck !					\ store first item in first cell
	1 cells - tuck !			\ increment address and store next item
	1 cells - tuck !
	1 cells - tuck !
	;

: light-vector-4f ( n1 n2 n3 n4 -- a )
	4 cells allocate throw 3 cells +	\ allocate 4 cells
	dup sf!					\ store first item in first cell
	1 cells - dup sf!			\ increment address and store next item
	1 cells - dup sf!
	1 cells - dup sf!
	;

: light-get ( n-light -- n-light-constant )
	GL_LIGHT0 + ;

: light-set-vector ( n-light n-enum r-0 r-1 r-2 r-3 -- )
	light-vector-4f -rot third gl-light-fv freet ;

\ vector simplifier
: light-diffuse ( n-light r-red r-green r-blue -- )
			light-get GL_DIFFUSE 		light-set-vector ;
: light-ambient		light-get GL_AMBIENT		light-set-vector ;
: light-specular	light-get GL_SPECULAR		light-set-vector ;
: light-spot-direction	light-get GL_SPOT_DIRECTION	light-set-vector ;
: light-position	light-get GL_POSITION		light-set-vector ;

: light-attenuation	( n-light r-constant r-linear r-quadratic -- )
	light-get
	dup GL_QUADRATIC_ATTENUATION	gl-light-f
	dup GL_LINEAR_ATTENUATION	gl-light-f
	GL_CONSTANT_ATTENUATION		gl-light-f ;

\ floating simplifier
: light-spot-cutoff	light-get GL_SPOT_CUTOFF	gl-light-f ;
: light-spot-exponent	light-get GL_SPOT_EXPONENT	gl-light-f ;

: light-enable GL_LIGHTING gl-enable ;
: light-disable GL_LIGHTING gl-disable ;

: gl-store ( n-enum -- n-state )
	gl-is-enabled ;

: gl-restore ( n-enum n-state -- )
	if gl-enable else gl-disable then ;

: light-store ( -- n-state )
	GL_LIGHTING gl-store ;

: light-restore ( n-state )
	GL_LIGHTING swap gl-restore ;

: light-init
	\ GL_MAX_LIGHTS max-lights gl-get-nv max-lights @ .

	GL_COLOR_MATERIAL gl-enable	\ use the polygons original value instead of a material

	0 light-get gl-enable
	1 light-get gl-enable

	0 0.e0 0.e0 1.e0 1.e0 light-diffuse
	0 5.e-1 fdup fdup 1.e0 light-ambient
	0 5.e-1 fdup fdup 1.e0 light-specular

	1 1.e0 0.e0 0.e0 1.e0 light-diffuse
	1 0.e-1 fdup fdup 1.e0 light-ambient
	1 0.e0 -1.e0 0.e0 0.e0 light-spot-direction

	1 50.e0 light-spot-cutoff
	1 12.e0 light-spot-exponent

	0 0.e0 -1.e0 0.e0 0.e0 light-spot-direction

	0 50.e0 light-spot-cutoff
	0 12.e0 light-spot-exponent
	;

: light-update
	0 0.e0 1.e1 0.e0 1.e0 light-position
	0 0.e0 -1.e0 0.e0 1.e0 light-spot-direction

	1 13.e0 1.e1 -13.e0 1.e0 light-position
	1 0.e0 -1.e0 0.e0 1.e0 light-spot-direction
;

