\ GL - Library import
\ (c) by Gerald Wodni 2008

\c #if defined(__APPLE__) && defined(__MACH__)
\c	#include <OpenGL/gl.h>
\c	#include <OpenGL/glu.h>
\c #else
\c 	#include <GL/gl.h>
\c 	#include <GL/glu.h>
\c #endif


\ ### GL ###

c-function gl-begin		glBegin			n -- void	( enum-mode -- )
c-function gl-end		glEnd			-- void

c-function gl-clear		glClear			n -- void	( mask -- )
c-function gl-clear-color	glClearColor		r r r r -- void	( red green blue alpha -- )
c-function gl-color-3r		glColor3f		r r r -- void	( red green blue -- )
c-function gl-color-4r		glColor4f		r r r r -- void	( red green blue alpha -- )

c-function gl-blend-func	glBlendFunc		n n -- void	( sfactor dfactor -- )
c-function gl-depth-func	glDepthFunc		n -- void	( enum-function -- )
c-function gl-line-width	glLineWidth		r -- void	( width -- )
c-function gl-point-size	glPointSize		r -- void	( size -- ) 

c-function gl-cull-face		glCullFace		n -- void	( enum-face -- )
c-function gl-front-face	glFrontFace		n -- void	( enum-orientation -- )
c-function gl-disable		glDisable		n -- void	( enum-capability -- )
c-function gl-enable		glEnable		n -- void	( enum-capability -- )
c-function gl-is-enabled	glIsEnabled		n -- n		( enum-capability -- state )

c-function gl-flush		glFlush			-- void

c-function gl-get-nv		glGetIntegerv		n a -- void 	( parameter-name pointer -- )
c-function gl-get-fv		glGetFloatv		n a -- void 	( parameter-name pointer -- )
c-function gl-get-rv		glGetDoublev		n a -- void 	( parameter-name pointer -- )

c-function gl-color-material	glColorMaterial		n n -- void	( enum-face enum-mode -- )
c-function gl-light-f		glLightf		n n r -- void	( light parameter-name parameter-value )
c-function gl-light-n		glLighti		n n n -- void	( light parameter-name parameter-value )
c-function gl-light-fv		glLightfv		n n a -- void	( light parameter-name parameter-array-pointer )
c-function gl-light-nv		glLightiv		n n a -- void	( light parameter-name parameter-array-pointer )
c-function gl-normal		glNormal3f		r r r -- void 	( x y z -- )

c-function gl-load-identity	glLoadIdentity		-- void
c-function gl-matrix-mode	glMatrixMode		n -- void	( enum-mode -- )
c-function gl-push-matrix	glPushMatrix		-- void
c-function gl-pop-matrix	glPopMatrix		-- void
c-function gl-rotate		glRotated		r r r r -- void	( angle x y z -- )
c-function gl-scale		glScaled		r r r -- void	( x y z -- )
c-function gl-translate		glTranslated		r r r -- void	( x y z -- )

c-function gl-polygon-mode	glPolygonMode		n n -- void	( enum-face enum-mode -- )

c-function gl-vertex-2n		glVertex2i		n n -- void 	( x y -- )
c-function gl-vertex-2r		glVertex2d		r r -- void 	( x y -- )

c-function gl-vertex-3n		glVertex3i		n n n -- void 	( x y -- )
c-function gl-vertex-3r		glVertex3d		r r r -- void 	( x y -- )

c-function gl-vertex-2nv	glVertex2iv		a -- void	( array-pointer -- )
c-function gl-vertex-2fv	glVertex2fv		a -- void	( array-pointer -- )

c-function gl-vertex-3nv	glVertex3iv		a -- void	( array-pointer -- )
c-function gl-vertex-3fv	glVertex3fv		a -- void	( array-pointer -- )

c-function gl-viewport		glViewport		n n n n -- void	( x y width height -- )



\ ### GLU ###

c-function glu-ortho		gluOrtho2D		r r r r -- void	( left right bottom top -- )
c-function glu-perspective	gluPerspective		r r r r -- void ( fovy aspect zNear zFar -- )

include glconstants.fs

