\ Enemy management
\ (c) by Gerald Wodni 2008

3	constant enemies-number

1.e-1	fconstant enemy-dying-decrease

variable enemies \ a

: random-var 
	20 random 10 - ;

object class enemy
	cell var pos		\ addr - 3fv
	cell var movement	\ addr - 3fv
	cell var line-color	\ addr - 4fv
	cell var fill-color	\ addr - 4fv
	cell var dying		\ flag
	method m_pos		\ access functions
	method m_movement
	method m_line-color
	method m_fill-color
	method m_dying
	method set-alpha	\ modify the line and fill color's alpha
	method get-alpha
	method random-place	\ place to random position
	method move
	method draw
how:
	: init ( x y z -- )
		create-3fv pos !
		0.e0 0.e0 1.e-1 create-3fv movement !
		1.e0 0.e0 0.e0 1.e0 create-4fv line-color !
		1.e-1 fdup fdup 1.e0 create-4fv fill-color !
		false dying ! ;

	: m_pos		( -- addr )
		pos ;
	: m_movement	( -- addr )
		movement ;
	: m_line-color	( -- addr )
		line-color ;
	: m_fill-color	( -- addr )
		fill-color ;
	: m_dying	( -- addr )
		dying ;

	: set-alpha	( r-alpha -- )
		line-color @ 3 cells + fdup sf!
		fill-color @ 3 cells + sf! ;

	: get-alpha	( -- r-alpha )
		line-color @ 3 cells + sf@ ;

	: random-place	( -- )
		random-var n>f 2.e0 random-var n>f pos @ >3fv  ;

	: move
		pos @ movement @ +3fv ;

	: draw
		gl-push-matrix
		pos @ 3fv> gl-translate
		tron-draw
		
		gl-pop-matrix ;
class;

: enemies-init 
	sdl-get-ticks seed !
	enemies-number dup cells allocate throw tuck enemies !	\ allocate array
	0 u+do
		1.e0 2.e0 i 2* 2* n>f enemy new over !
		dup @ >o enemy random-place o>
		cell +
	loop drop ;

: enemies-update
	sdl-get-ticks seed !		\ re-seed ( because of the constant seed at world-draw )
	enemies @ enemies-number 0 u+do
		dup @ >o
			enemy m_dying @ if
				enemy get-alpha enemy-dying-decrease f-
				fdup 0.e0 f< if				\ respan
					1.e0 0.e0 0.e0 1.e0 enemy m_line-color @ >4fv	\ set line color to red
					1.e0 enemy set-alpha		\ make opaque
					enemy random-place		
					false enemy dying !		\ tell the enemy that he's alive
				else
					enemy set-alpha			\ fade out
				then
			else
				enemy m_pos @ player-x f@ fnegate player-y f@ fnegate player-z f@ fnegate create-3fv tuck
				3 distance-nfv dup dup
					dup 1 0.e0 set-component-fv	\ eliminate y-component
					3 2dup squared-sum-nfv 1.e0 f> if	\ only normalize if vector is bigger than one, to elimiate jumping around over player
						2dup normalize-nfv	\ normalize
					then
					1.e-1 scale-nfv			\ scale to slower movement
					3fv> enemy m_movement @ >3fv 
				freet freet
				enemy move
			then
		o>
		cell +
	loop drop ;

: enemies-draw
	2.e0 gl-line-width					\ prepare culling and wireframe
	GL_CW gl-front-face
	GL_BACK gl-cull-face

	enemies @ enemies-number 0 u+do
		dup @ >o
		
		enemy fill-color @ 4fv> gl-color-4r		\ normal fill rendering
		enemy draw

		GL_FRONT GL_LINE gl-polygon-mode		\ wireframe extension
		GL_CULL_FACE gl-enable
		enemy line-color @ 4fv> gl-color-4r		\ normal fill rendering
		enemy draw
		GL_CULL_FACE gl-disable

		GL_FRONT_AND_BACK GL_FILL gl-polygon-mode

		o>

		cell +
	loop drop ;

