\ lightwight in-game console
\ (c) by Gerald Wodni 2008

variable execution-token-value
variable execution-token-number

: set ( addr -- )
	true swap ! 
	0 ;	\ execution-token-value

: clear ( addr --  )
	false swap !
	0 ;	\ execution-token-value

: execute-string ( n addr n -- )
	chars - swap 2dup forth-wordlist search-wordlist
	0= if 
		." Error, unknown command >" type ." <" cr 
	else
		execution-token-number @ if	\ if there has been a result, display it
			execution-token-value @ swap
		then
		execute
		execution-token-value !		\ store current result
		." >" type ." < successfully executed" cr
	then
	;

: execute-line	( addr n -- )
	0 execution-token-number !
	0 swap 0 u+do
		over c@ 32 = if		\ space, execute current token
			dup 0<> if	\ only execute if there is something to execute ;)
				2dup execute-string
				execution-token-number dup @ 1+ swap !
			else
				drop
			then
			0		\ reset current-token-length
		else
			1+		\ increment current-token-length
		then
		swap 1 chars + swap
	loop
	dup -rot execute-string
	;

